/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.clients.api.dto.catalogue;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.qubership.atp.ram.clients.api.dto.catalogue.CaseDataSetRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraComponentDto;

@JsonTypeName(value="CaseCreationRequest")
public class CaseCreationRequestDto {
    @JsonProperty(value="components")
    @Valid
    private List<JiraComponentDto> components = null;
    @JsonProperty(value="dataSets")
    @Valid
    private List<CaseDataSetRequestDto> dataSets = new ArrayList<CaseDataSetRequestDto>();
    @JsonProperty(value="groupId")
    private UUID groupId;
    @JsonProperty(value="jiraTicket")
    private String jiraTicket;
    @JsonProperty(value="labelIds")
    @Valid
    private List<UUID> labelIds = null;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="projectId")
    private UUID projectId;
    @JsonProperty(value="scenarioIds")
    @Valid
    private List<UUID> scenarioIds = new ArrayList<UUID>();
    @JsonProperty(value="testPlanUuid")
    private UUID testPlanUuid;
    @JsonProperty(value="logCollectorTemplateId")
    private UUID logCollectorTemplateId;

    public CaseCreationRequestDto components(List<JiraComponentDto> components) {
        this.components = components;
        return this;
    }

    public CaseCreationRequestDto addComponentsItem(JiraComponentDto componentsItem) {
        if (this.components == null) {
            this.components = new ArrayList<JiraComponentDto>();
        }
        this.components.add(componentsItem);
        return this;
    }

    @Valid
    @Schema(name="components", required=false)
    public List<JiraComponentDto> getComponents() {
        return this.components;
    }

    public void setComponents(List<JiraComponentDto> components) {
        this.components = components;
    }

    public CaseCreationRequestDto dataSets(List<CaseDataSetRequestDto> dataSets) {
        this.dataSets = dataSets;
        return this;
    }

    public CaseCreationRequestDto addDataSetsItem(CaseDataSetRequestDto dataSetsItem) {
        this.dataSets.add(dataSetsItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="dataSets", required=true)
    public List<CaseDataSetRequestDto> getDataSets() {
        return this.dataSets;
    }

    public void setDataSets(List<CaseDataSetRequestDto> dataSets) {
        this.dataSets = dataSets;
    }

    public CaseCreationRequestDto groupId(UUID groupId) {
        this.groupId = groupId;
        return this;
    }

    @Valid
    @Schema(name="groupId", required=false)
    public UUID getGroupId() {
        return this.groupId;
    }

    public void setGroupId(UUID groupId) {
        this.groupId = groupId;
    }

    public CaseCreationRequestDto jiraTicket(String jiraTicket) {
        this.jiraTicket = jiraTicket;
        return this;
    }

    @Pattern(regexp="((?<!([A-Z]{1,10})-?)[A-Z]+-\\d+)")
    @Schema(name="jiraTicket", required=false)
    public @Pattern(regexp="((?<!([A-Z]{1,10})-?)[A-Z]+-\\d+)") String getJiraTicket() {
        return this.jiraTicket;
    }

    public void setJiraTicket(String jiraTicket) {
        this.jiraTicket = jiraTicket;
    }

    public CaseCreationRequestDto labelIds(List<UUID> labelIds) {
        this.labelIds = labelIds;
        return this;
    }

    public CaseCreationRequestDto addLabelIdsItem(UUID labelIdsItem) {
        if (this.labelIds == null) {
            this.labelIds = new ArrayList<UUID>();
        }
        this.labelIds.add(labelIdsItem);
        return this;
    }

    @Valid
    @Schema(name="labelIds", required=false)
    public List<UUID> getLabelIds() {
        return this.labelIds;
    }

    public void setLabelIds(List<UUID> labelIds) {
        this.labelIds = labelIds;
    }

    public CaseCreationRequestDto name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CaseCreationRequestDto projectId(UUID projectId) {
        this.projectId = projectId;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="projectId", required=true)
    public UUID getProjectId() {
        return this.projectId;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public CaseCreationRequestDto scenarioIds(List<UUID> scenarioIds) {
        this.scenarioIds = scenarioIds;
        return this;
    }

    public CaseCreationRequestDto addScenarioIdsItem(UUID scenarioIdsItem) {
        this.scenarioIds.add(scenarioIdsItem);
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="scenarioIds", required=true)
    public List<UUID> getScenarioIds() {
        return this.scenarioIds;
    }

    public void setScenarioIds(List<UUID> scenarioIds) {
        this.scenarioIds = scenarioIds;
    }

    public CaseCreationRequestDto testPlanUuid(UUID testPlanUuid) {
        this.testPlanUuid = testPlanUuid;
        return this;
    }

    @Valid
    @Schema(name="testPlanUuid", required=false)
    public UUID getTestPlanUuid() {
        return this.testPlanUuid;
    }

    public void setTestPlanUuid(UUID testPlanUuid) {
        this.testPlanUuid = testPlanUuid;
    }

    public CaseCreationRequestDto logCollectorTemplateId(UUID logCollectorTemplateId) {
        this.logCollectorTemplateId = logCollectorTemplateId;
        return this;
    }

    @Valid
    @Schema(name="logCollectorTemplateId", required=false)
    public UUID getLogCollectorTemplateId() {
        return this.logCollectorTemplateId;
    }

    public void setLogCollectorTemplateId(UUID logCollectorTemplateId) {
        this.logCollectorTemplateId = logCollectorTemplateId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaseCreationRequestDto caseCreationRequest = (CaseCreationRequestDto)o;
        return Objects.equals(this.components, caseCreationRequest.components) && Objects.equals(this.dataSets, caseCreationRequest.dataSets) && Objects.equals(this.groupId, caseCreationRequest.groupId) && Objects.equals(this.jiraTicket, caseCreationRequest.jiraTicket) && Objects.equals(this.labelIds, caseCreationRequest.labelIds) && Objects.equals(this.name, caseCreationRequest.name) && Objects.equals(this.projectId, caseCreationRequest.projectId) && Objects.equals(this.scenarioIds, caseCreationRequest.scenarioIds) && Objects.equals(this.testPlanUuid, caseCreationRequest.testPlanUuid) && Objects.equals(this.logCollectorTemplateId, caseCreationRequest.logCollectorTemplateId);
    }

    public int hashCode() {
        return Objects.hash(this.components, this.dataSets, this.groupId, this.jiraTicket, this.labelIds, this.name, this.projectId, this.scenarioIds, this.testPlanUuid, this.logCollectorTemplateId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CaseCreationRequestDto {\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("    dataSets: ").append(this.toIndentedString(this.dataSets)).append("\n");
        sb.append("    groupId: ").append(this.toIndentedString(this.groupId)).append("\n");
        sb.append("    jiraTicket: ").append(this.toIndentedString(this.jiraTicket)).append("\n");
        sb.append("    labelIds: ").append(this.toIndentedString(this.labelIds)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    projectId: ").append(this.toIndentedString(this.projectId)).append("\n");
        sb.append("    scenarioIds: ").append(this.toIndentedString(this.scenarioIds)).append("\n");
        sb.append("    testPlanUuid: ").append(this.toIndentedString(this.testPlanUuid)).append("\n");
        sb.append("    logCollectorTemplateId: ").append(this.toIndentedString(this.logCollectorTemplateId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

