/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.clients.api.dto.catalogue;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraComponentDto;
import org.springframework.format.annotation.DateTimeFormat;

@JsonTypeName(value="CasePatchUpdateRequest")
public class CasePatchUpdateRequestDto {
    @JsonProperty(value="assigneeId")
    private UUID assigneeId;
    @JsonProperty(value="components")
    @Valid
    private List<JiraComponentDto> components = null;
    @JsonProperty(value="datasetId")
    private UUID datasetId;
    @JsonProperty(value="datasetStorageId")
    private UUID datasetStorageId;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="labelIds")
    @Valid
    private List<UUID> labelIds = null;
    @JsonProperty(value="modifiedWhen")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime modifiedWhen;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="priority")
    private PriorityEnum priority;
    @JsonProperty(value="scenarioId")
    private UUID scenarioId;
    @JsonProperty(value="status")
    private StatusEnum status;
    @JsonProperty(value="testScopeIds")
    @Valid
    private List<UUID> testScopeIds = null;

    public CasePatchUpdateRequestDto assigneeId(UUID assigneeId) {
        this.assigneeId = assigneeId;
        return this;
    }

    @Valid
    @Schema(name="assigneeId", required=false)
    public UUID getAssigneeId() {
        return this.assigneeId;
    }

    public void setAssigneeId(UUID assigneeId) {
        this.assigneeId = assigneeId;
    }

    public CasePatchUpdateRequestDto components(List<JiraComponentDto> components) {
        this.components = components;
        return this;
    }

    public CasePatchUpdateRequestDto addComponentsItem(JiraComponentDto componentsItem) {
        if (this.components == null) {
            this.components = new ArrayList<JiraComponentDto>();
        }
        this.components.add(componentsItem);
        return this;
    }

    @Valid
    @Schema(name="components", required=false)
    public List<JiraComponentDto> getComponents() {
        return this.components;
    }

    public void setComponents(List<JiraComponentDto> components) {
        this.components = components;
    }

    public CasePatchUpdateRequestDto datasetId(UUID datasetId) {
        this.datasetId = datasetId;
        return this;
    }

    @Valid
    @Schema(name="datasetId", required=false)
    public UUID getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(UUID datasetId) {
        this.datasetId = datasetId;
    }

    public CasePatchUpdateRequestDto datasetStorageId(UUID datasetStorageId) {
        this.datasetStorageId = datasetStorageId;
        return this;
    }

    @Valid
    @Schema(name="datasetStorageId", required=false)
    public UUID getDatasetStorageId() {
        return this.datasetStorageId;
    }

    public void setDatasetStorageId(UUID datasetStorageId) {
        this.datasetStorageId = datasetStorageId;
    }

    public CasePatchUpdateRequestDto description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", required=false)
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CasePatchUpdateRequestDto labelIds(List<UUID> labelIds) {
        this.labelIds = labelIds;
        return this;
    }

    public CasePatchUpdateRequestDto addLabelIdsItem(UUID labelIdsItem) {
        if (this.labelIds == null) {
            this.labelIds = new ArrayList<UUID>();
        }
        this.labelIds.add(labelIdsItem);
        return this;
    }

    @Valid
    @Schema(name="labelIds", required=false)
    public List<UUID> getLabelIds() {
        return this.labelIds;
    }

    public void setLabelIds(List<UUID> labelIds) {
        this.labelIds = labelIds;
    }

    public CasePatchUpdateRequestDto modifiedWhen(OffsetDateTime modifiedWhen) {
        this.modifiedWhen = modifiedWhen;
        return this;
    }

    @Valid
    @Schema(name="modifiedWhen", required=false)
    public OffsetDateTime getModifiedWhen() {
        return this.modifiedWhen;
    }

    public void setModifiedWhen(OffsetDateTime modifiedWhen) {
        this.modifiedWhen = modifiedWhen;
    }

    public CasePatchUpdateRequestDto name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", required=false)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CasePatchUpdateRequestDto priority(PriorityEnum priority) {
        this.priority = priority;
        return this;
    }

    @Schema(name="priority", required=false)
    public PriorityEnum getPriority() {
        return this.priority;
    }

    public void setPriority(PriorityEnum priority) {
        this.priority = priority;
    }

    public CasePatchUpdateRequestDto scenarioId(UUID scenarioId) {
        this.scenarioId = scenarioId;
        return this;
    }

    @Valid
    @Schema(name="scenarioId", required=false)
    public UUID getScenarioId() {
        return this.scenarioId;
    }

    public void setScenarioId(UUID scenarioId) {
        this.scenarioId = scenarioId;
    }

    public CasePatchUpdateRequestDto status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Schema(name="status", required=false)
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public CasePatchUpdateRequestDto testScopeIds(List<UUID> testScopeIds) {
        this.testScopeIds = testScopeIds;
        return this;
    }

    public CasePatchUpdateRequestDto addTestScopeIdsItem(UUID testScopeIdsItem) {
        if (this.testScopeIds == null) {
            this.testScopeIds = new ArrayList<UUID>();
        }
        this.testScopeIds.add(testScopeIdsItem);
        return this;
    }

    @Valid
    @Schema(name="testScopeIds", required=false)
    public List<UUID> getTestScopeIds() {
        return this.testScopeIds;
    }

    public void setTestScopeIds(List<UUID> testScopeIds) {
        this.testScopeIds = testScopeIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CasePatchUpdateRequestDto casePatchUpdateRequest = (CasePatchUpdateRequestDto)o;
        return Objects.equals(this.assigneeId, casePatchUpdateRequest.assigneeId) && Objects.equals(this.components, casePatchUpdateRequest.components) && Objects.equals(this.datasetId, casePatchUpdateRequest.datasetId) && Objects.equals(this.datasetStorageId, casePatchUpdateRequest.datasetStorageId) && Objects.equals(this.description, casePatchUpdateRequest.description) && Objects.equals(this.labelIds, casePatchUpdateRequest.labelIds) && Objects.equals(this.modifiedWhen, casePatchUpdateRequest.modifiedWhen) && Objects.equals(this.name, casePatchUpdateRequest.name) && Objects.equals((Object)this.priority, (Object)casePatchUpdateRequest.priority) && Objects.equals(this.scenarioId, casePatchUpdateRequest.scenarioId) && Objects.equals((Object)this.status, (Object)casePatchUpdateRequest.status) && Objects.equals(this.testScopeIds, casePatchUpdateRequest.testScopeIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.assigneeId, this.components, this.datasetId, this.datasetStorageId, this.description, this.labelIds, this.modifiedWhen, this.name, this.priority, this.scenarioId, this.status, this.testScopeIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CasePatchUpdateRequestDto {\n");
        sb.append("    assigneeId: ").append(this.toIndentedString(this.assigneeId)).append("\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("    datasetId: ").append(this.toIndentedString(this.datasetId)).append("\n");
        sb.append("    datasetStorageId: ").append(this.toIndentedString(this.datasetStorageId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    labelIds: ").append(this.toIndentedString(this.labelIds)).append("\n");
        sb.append("    modifiedWhen: ").append(this.toIndentedString(this.modifiedWhen)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    scenarioId: ").append(this.toIndentedString(this.scenarioId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    testScopeIds: ").append(this.toIndentedString(this.testScopeIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PriorityEnum {
        BLOCKER("BLOCKER"),
        CRITICAL("CRITICAL"),
        LOW("LOW"),
        MAJOR("MAJOR"),
        NORMAL("NORMAL");

        private String value;

        private PriorityEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PriorityEnum fromValue(String value) {
            for (PriorityEnum b : PriorityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum StatusEnum {
        BLOCKED("BLOCKED"),
        CANCELLED("CANCELLED"),
        FAILED("FAILED"),
        IN_PROGRESS("IN_PROGRESS"),
        NOT_DELIVERED("NOT_DELIVERED"),
        OPEN("OPEN"),
        PASSED("PASSED"),
        PASSED_WITH_MINOR_DEFECTS("PASSED_WITH_MINOR_DEFECTS");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

