/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.history.job;

import com.google.common.collect.Iterators;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.javacrumbs.shedlock.spring.annotation.SchedulerLock;
import org.qubership.atp.ram.model.JaversCountResponse;
import org.qubership.atp.ram.model.JaversIdsResponse;
import org.qubership.atp.ram.model.JaversVersionsResponse;
import org.qubership.atp.ram.repositories.JaversSnapshotRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JaversSnapshotScheduler {
    private static final Logger log = LoggerFactory.getLogger(JaversSnapshotScheduler.class);
    private static final String UTC_TIMEZONE = "UTC";
    private final JaversSnapshotRepository repository;
    @Value(value="${atp.last.revision.count}")
    private Integer maxCount;
    @Value(value="${atp.archive.job.limit-of-data}")
    private Integer step;
    @Value(value="${atp.archive.job.bulk-delete-count}")
    private Integer bulkDeleteCount;

    @Scheduled(cron="${atp.archive.cron.expression}", zone="UTC")
    @SchedulerLock(name="${atp.archive.job.name}", lockAtMostFor="12h", lockAtLeastFor="2h")
    public void run() {
        log.info("Start remove irrelevant data from the change history.");
        this.deleteTerminatedSnapshots();
        Iterators.partition(this.repository.findAllCdoIds().iterator(), (int)this.step).forEachRemaining(listOfCdoId -> this.findCdoIdAndCount(listOfCdoId.stream().map(JaversIdsResponse::getCdoId).collect(Collectors.toList())).forEach(this::execute));
        log.info("Finish remove irrelevant data from the change history.");
    }

    public List<JaversCountResponse> findCdoIdAndCount(List<String> listOfCdoId) {
        List<JaversCountResponse> response = this.repository.findCdoIdAndCount(listOfCdoId);
        response.forEach(entity -> entity.setVersions(entity.getVersions().stream().sorted(Comparator.comparingLong(Long::longValue)).collect(Collectors.toList())));
        log.debug("findCdoIdAndCount [Number of unique cdo: {}]", (Object)response.size());
        return response;
    }

    public List<JaversVersionsResponse> findOldObjects(JaversCountResponse response) {
        int countVersions = response.getVersions().size();
        log.debug("findOldObjects [cdoId={}, count={}]", (Object)response.getCdoId(), (Object)countVersions);
        int countOld = countVersions - this.maxCount;
        if (countOld > 0) {
            List<JaversVersionsResponse> responses = response.getVersions().stream().limit(countOld).map(version -> {
                JaversVersionsResponse javersVersionsResponse = new JaversVersionsResponse();
                javersVersionsResponse.setCdoId(response.getCdoId());
                javersVersionsResponse.setVersion((Long)version);
                return javersVersionsResponse;
            }).collect(Collectors.toList());
            log.debug("findOldObjects [Number of old objects: {} for cdoId: {}]", (Object)responses.size(), (Object)response.getCdoId());
            return responses;
        }
        return null;
    }

    public Long findObjectWithMinVersion(JaversCountResponse response, List<JaversVersionsResponse> oldObjects) {
        log.debug("findObjectWithMinVersion [cdoId={}]", (Object)response.getCdoId());
        Long minVersion = response.getVersions().subList(oldObjects.size(), response.getVersions().size() - 1).stream().min(Comparator.comparingLong(Long::longValue)).get();
        log.debug("findObjectWithMinVersion [minVersion={}]", (Object)minVersion);
        return minVersion;
    }

    public void deleteByCdoIdAndVersions(String cdoId, List<Long> versions) {
        log.debug("deleteByCdoIdAndVersions [cdoId={}, versions={}]", (Object)cdoId, versions);
        Iterators.partition(versions.iterator(), (int)this.bulkDeleteCount).forEachRemaining(ids -> this.repository.deleteByCdoIdAndVersions(cdoId, (List<Long>)ids));
        log.debug("deleteByCdoIdAndVersions [Objects with cdoId={}. Number of old versions for deleting: {}]", (Object)cdoId, (Object)versions.size());
    }

    public void updateObjectAsInitial(String cdoId, Long version) {
        log.debug("updateObjectAsInitial [cdoId={}, version={}]", (Object)cdoId, (Object)version);
        this.repository.updateAsInitial(cdoId, version);
        log.debug("updateObjectAsInitial [Object with cdoId={}, version={} updated]", (Object)cdoId, (Object)version);
    }

    public List<String> findTerminatedCdoId() {
        List<JaversIdsResponse> snapshots = this.repository.findTerminatedSnapshots();
        log.debug("findTerminatedSnapshots [Number of terminated snapshots: {}]", (Object)snapshots.size());
        return this.findOldCdoIds(snapshots);
    }

    public void deleteTerminatedSnapshots() {
        List<String> terminatedCdoId = this.findTerminatedCdoId();
        Iterators.partition(terminatedCdoId.iterator(), (int)this.bulkDeleteCount).forEachRemaining(this.repository::deleteByCdoIds);
        log.debug("Terminated snapshots deleted");
    }

    private List<String> findOldCdoIds(List<JaversIdsResponse> oldObjects) {
        return oldObjects.stream().map(JaversIdsResponse::getCdoId).collect(Collectors.toList());
    }

    private List<Long> findOldVersions(List<JaversVersionsResponse> oldObjects) {
        return oldObjects.stream().filter(response -> Objects.nonNull(response.getVersion())).map(JaversVersionsResponse::getVersion).collect(Collectors.toList());
    }

    @Transactional
    public void execute(JaversCountResponse response) {
        List<JaversVersionsResponse> oldObjects = this.findOldObjects(response);
        if (Objects.nonNull(oldObjects)) {
            List<Long> versions = this.findOldVersions(oldObjects);
            this.deleteByCdoIdAndVersions(response.getCdoId(), versions);
            Long version = this.findObjectWithMinVersion(response, oldObjects);
            this.updateObjectAsInitial(response.getCdoId(), version);
        }
    }

    public JaversSnapshotScheduler(JaversSnapshotRepository repository) {
        this.repository = repository;
    }
}

