/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.repositories.impl;

import java.util.ArrayList;
import java.util.UUID;
import org.qubership.atp.ram.dto.response.PaginationResponse;
import org.qubership.atp.ram.models.BrowserConsoleLog;
import org.qubership.atp.ram.models.BrowserConsoleLogsTable;
import org.qubership.atp.ram.repositories.CustomBrowserConsoleLogRepository;
import org.qubership.atp.ram.repositories.impl.FieldConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.ArrayOperators;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Repository;

@Repository
public class CustomBrowserConsoleLogRepositoryImpl
implements CustomBrowserConsoleLogRepository,
FieldConstants {
    private static final Logger log = LoggerFactory.getLogger(CustomBrowserConsoleLogRepositoryImpl.class);
    private final MongoTemplate mongoTemplate;
    private static final String BROWSER_CONSOLE_LOG_COLLECTION_NAME = BrowserConsoleLog.class.getAnnotation(Document.class).collection();

    @Override
    public PaginationResponse<BrowserConsoleLogsTable> findBrowserConsoleLogsByLogRecordIdWithPagination(UUID logRecordId, Pageable pageable) {
        ArrayList<Object> aggregationOperations = new ArrayList<Object>();
        aggregationOperations.add(Aggregation.match((Criteria)Criteria.where((String)"logRecordId").is((Object)logRecordId)));
        aggregationOperations.add(Aggregation.unwind((String)"$browserConsoleLogsTable"));
        aggregationOperations.add(Aggregation.project((String[])new String[0]).andExpression("$browserConsoleLogsTable.message", new Object[0]).as("message").andExpression("$browserConsoleLogsTable.timestamp", new Object[0]).as("timestamp").andExpression("$browserConsoleLogsTable.level", new Object[0]).as("level").andExpression("$browserConsoleLogsTable.fileName", new Object[0]).as("fileName"));
        aggregationOperations.add(Aggregation.sort((Sort)pageable.getSort()));
        aggregationOperations.add(Aggregation.facet((AggregationOperation[])new AggregationOperation[]{Aggregation.skip((int)(pageable.getPageNumber() * pageable.getPageSize())), Aggregation.limit((long)pageable.getPageSize())}).as("entities").and(new AggregationOperation[]{Aggregation.count().as("totalCount")}).as("metadata"));
        aggregationOperations.add(Aggregation.project((String[])new String[]{"entities"}).and((AggregationExpression)ArrayOperators.ArrayElemAt.arrayOf((String)"$metadata.totalCount").elementAt(0)).as("totalCount"));
        Aggregation aggregation = Aggregation.newAggregation(aggregationOperations);
        log.debug("Aggregation query '{}'", (Object)aggregation.toString());
        return (PaginationResponse)this.mongoTemplate.aggregate(aggregation, BROWSER_CONSOLE_LOG_COLLECTION_NAME, BrowserConsoleLogPaginationResponse.class).getUniqueMappedResult();
    }

    public CustomBrowserConsoleLogRepositoryImpl(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    private static class BrowserConsoleLogPaginationResponse
    extends PaginationResponse<BrowserConsoleLogsTable> {
        private BrowserConsoleLogPaginationResponse() {
        }
    }
}

