/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.repositories.impl;

import com.mongodb.client.result.UpdateResult;
import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.repositories.CustomExecutionRequestRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository
public class CustomExecutionRequestRepositoryImpl
implements CustomExecutionRequestRepository {
    private static final Logger log = LoggerFactory.getLogger(CustomExecutionRequestRepositoryImpl.class);
    private final MongoTemplate mongoTemplate;
    private final String failedLogrecordsCounter = "failedLogrecordsCounter";

    @Override
    public List<ExecutionRequest> searchExecutionRequests(CriteriaDefinition filters, Pageable pageable) {
        Query query = new Query(filters).with(pageable);
        log.debug("Query: {}", (Object)query);
        return this.mongoTemplate.find(query, ExecutionRequest.class);
    }

    @Override
    public int getExecutionRequestsCountByCriteria(CriteriaDefinition filters) {
        Query query = new Query(filters);
        log.debug("Query: {}", (Object)query);
        return (int)this.mongoTemplate.count(query, ExecutionRequest.class);
    }

    @Override
    public List<ExecutionRequest> getByTestPlanAndFinishDateBetweenOrEqualsAndAnalyzedByQa(UUID testPlanId, Timestamp start, boolean analyzedByQa, Pageable page) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"testPlanId").is((Object)testPlanId).and("finishDate").gte((Object)start).and("analyzedByQa").is((Object)analyzedByQa)).with(page);
        return this.mongoTemplate.find(query, ExecutionRequest.class);
    }

    @Override
    public List<ExecutionRequest> getByTestPlanAndFinishDateBetweenOrEquals(UUID testPlanId, Timestamp start, Timestamp end, Pageable page) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"testPlanId").is((Object)testPlanId).and("finishDate").gte((Object)start).lte((Object)end)).with(page);
        return this.mongoTemplate.find(query, ExecutionRequest.class);
    }

    @Override
    public void updateLogRecordsCount(UUID executionRequestId, int logRecordsCount) {
        Query idQuery = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)executionRequestId));
        Update update = new Update().set("failedLogrecordsCounter", (Object)logRecordsCount);
        UpdateResult updateResult = this.mongoTemplate.updateFirst(idQuery, (UpdateDefinition)update, ExecutionRequest.class);
        log.debug("ER: {} was update with params failedLogrecordsCounter: {} result: {}", new Object[]{executionRequestId, logRecordsCount, updateResult});
    }

    public CustomExecutionRequestRepositoryImpl(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }
}

