/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.repositories.impl;

import java.util.Collection;
import java.util.UUID;
import org.qubership.atp.ram.repositories.impl.FieldConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Component;

@Component
public class GenericEntitySearchComponent
implements FieldConstants {
    private static final Logger log = LoggerFactory.getLogger(GenericEntitySearchComponent.class);
    private static final String REGEX_SYMBOLS = "([$.*+?~^!|\\-()\\[\\]{}\\\\])";

    public Criteria namesRegexIgnoreCase(String fieldName, Collection<String> names) {
        Criteria nameCriteria = new Criteria();
        nameCriteria.orOperator((Criteria[])names.stream().map(name -> Criteria.where((String)fieldName).regex(".*" + name.replaceAll(REGEX_SYMBOLS, "\\\\$1") + ".*", "i")).toArray(Criteria[]::new));
        return nameCriteria;
    }

    public Criteria namesRegexIgnoreCase(String fieldName, String name) {
        return Criteria.where((String)fieldName).regex(".*" + name.replaceAll(REGEX_SYMBOLS, "\\\\$1") + ".*", "i");
    }

    public Criteria foundInArrayStrings(String fieldName, Collection<String> fieldValues) {
        return Criteria.where((String)fieldName).in(fieldValues);
    }

    public Criteria foundInArrayIds(String fieldName, Collection<UUID> ids) {
        return Criteria.where((String)fieldName).in(ids);
    }
}

