/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ram.models.AkbRecord;
import org.qubership.atp.ram.models.RootCause;
import org.qubership.atp.ram.repositories.AkbRecordsRepository;
import org.qubership.atp.ram.services.CrudService;
import org.qubership.atp.ram.services.RootCauseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Service;

@Service
public class AkbRecordsService
extends CrudService<AkbRecord> {
    private static final Logger log = LoggerFactory.getLogger(AkbRecordsService.class);
    private final AkbRecordsRepository repository;
    private final RootCauseService rootCauseService;

    @Override
    protected MongoRepository<AkbRecord, UUID> repository() {
        return this.repository;
    }

    public List<AkbRecord> getRecordsByProjectUuid(UUID projectUuid, boolean withRootCauseName) {
        List<AkbRecord> allAkbRecords = this.repository.getAkbRecordsByProjectId(projectUuid);
        if (withRootCauseName) {
            List<RootCause> allRootCauses = this.rootCauseService.getAllRootCauses();
            return allAkbRecords.stream().map(akbRecord -> this.replaceRootCauseIdWithName((AkbRecord)akbRecord, allRootCauses)).collect(Collectors.toList());
        }
        return allAkbRecords;
    }

    public void removeDefectFromAkbRecord(UUID defectUuid) {
        List<AkbRecord> akbRecords = this.repository.getAkbRecordsByUuid(defectUuid);
        akbRecords.forEach(akbRecord -> {
            akbRecord.setDefectId(null);
            this.save(akbRecord);
        });
        this.saveAll(akbRecords);
    }

    public List<AkbRecord> getAllWithRootCauseName() {
        List allAkbRecords = this.getAll();
        List<RootCause> allRootCauses = this.rootCauseService.getAllRootCauses();
        return allAkbRecords.stream().map(akbRecord -> this.replaceRootCauseIdWithName((AkbRecord)akbRecord, allRootCauses)).collect(Collectors.toList());
    }

    private AkbRecord replaceRootCauseIdWithName(AkbRecord akbRecord, List<RootCause> allRootCauses) {
        for (RootCause cause : allRootCauses) {
            if (!cause.getUuid().equals(akbRecord.getRootCauseId())) continue;
            akbRecord.setRootCauseId(cause.getUuid());
            return akbRecord;
        }
        akbRecord.setRootCauseId(null);
        return akbRecord;
    }

    public UUID getProjectIdByAkbRecordId(UUID id) {
        return this.repository.findProjectIdByUuid(id).getProjectId();
    }

    public AkbRecord findByUuid(UUID uuid) {
        return this.repository.findByUuid(uuid);
    }

    public void deleteByUuid(UUID uuid) {
        this.repository.deleteByUuid(uuid);
    }

    public AkbRecordsService(AkbRecordsRepository repository, RootCauseService rootCauseService) {
        this.repository = repository;
        this.rootCauseService = rootCauseService;
    }
}

