/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.qubership.atp.integration.configuration.model.KafkaMailResponse;
import org.qubership.atp.integration.configuration.model.KafkaMailResponseStatus;
import org.qubership.atp.integration.configuration.model.MailResponse;
import org.qubership.atp.ram.enums.MailMetadata;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.models.ExecutionRequestDetails;
import org.qubership.atp.ram.repositories.ExecutionRequestDetailsRepository;
import org.qubership.atp.ram.services.CrudService;
import org.qubership.atp.ram.services.ExecutionRequestReportingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Service;

@Service
public class ExecutionRequestDetailsService
extends CrudService<ExecutionRequestDetails> {
    private static final Logger log = LoggerFactory.getLogger(ExecutionRequestDetailsService.class);
    private static final String DETAILS_SECTION_REPORTING = "Details";
    private final ObjectMapper objectMapper;
    private final ExecutionRequestDetailsRepository detailsRepository;
    private final ExecutionRequestReportingService reportingService;

    @Override
    protected MongoRepository<ExecutionRequestDetails, UUID> repository() {
        return this.detailsRepository;
    }

    public ExecutionRequestDetails createDetails(UUID executionRequestId, ExecutionRequestDetails details) {
        log.debug("Create details for execution request with id '{}'", (Object)executionRequestId);
        details.setUuid(UUID.randomUUID());
        details.setName(DETAILS_SECTION_REPORTING);
        details.setExecutionRequestId(executionRequestId);
        ExecutionRequestDetails savedDetails = (ExecutionRequestDetails)this.detailsRepository.save(details);
        log.debug("Details for execution request successfully created");
        return savedDetails;
    }

    public ExecutionRequestDetails createDetails(UUID executionRequestId, TestingStatuses testingStatuses, String msg) {
        log.debug("Create details for execution request with id '{}'", (Object)executionRequestId);
        ExecutionRequestDetails details = new ExecutionRequestDetails();
        details.setUuid(UUID.randomUUID());
        details.setName(DETAILS_SECTION_REPORTING);
        details.setExecutionRequestId(executionRequestId);
        details.setStatus(testingStatuses);
        details.setMessage(msg);
        details.setDate(new Date());
        ExecutionRequestDetails savedDetails = (ExecutionRequestDetails)this.detailsRepository.save(details);
        log.debug("Details for execution request successfully created");
        return savedDetails;
    }

    public ExecutionRequestDetails createFailedDetails(UUID executionRequestId, Exception e) {
        log.debug("Create details for execution request with id '{}'", (Object)executionRequestId);
        ExecutionRequestDetails details = new ExecutionRequestDetails();
        details.setUuid(UUID.randomUUID());
        details.setName(DETAILS_SECTION_REPORTING);
        details.setExecutionRequestId(executionRequestId);
        details.setStatus(TestingStatuses.FAILED);
        details.setMessage(this.generateErrorMsg(e.getMessage(), Throwables.getStackTraceAsString((Throwable)e)));
        details.setDate(new Date());
        ExecutionRequestDetails savedDetails = (ExecutionRequestDetails)this.detailsRepository.save(details);
        log.debug("Details for execution request successfully created");
        return savedDetails;
    }

    public List<ExecutionRequestDetails> getDetails(UUID executionRequestId) {
        return this.detailsRepository.findAllByExecutionRequestId(executionRequestId);
    }

    public ExecutionRequestDetails updateDetailsStatus(UUID executionRequestId, ExecutionRequestDetails newDataDetails) {
        ExecutionRequestDetails details = this.detailsRepository.findByExecutionRequestId(executionRequestId);
        if (Objects.nonNull(details)) {
            log.debug("Update details section for ER {}, new data {}", (Object)executionRequestId, (Object)newDataDetails);
            details.setStatus(newDataDetails.getStatus());
            details.setMessage(newDataDetails.getMessage());
            return (ExecutionRequestDetails)this.detailsRepository.save(details);
        }
        log.warn("Details section for ER {} is null", (Object)executionRequestId);
        return null;
    }

    public void addMailResponseDetails(String response) throws IOException {
        KafkaMailResponse mailResponse = (KafkaMailResponse)this.objectMapper.readValue(response, KafkaMailResponse.class);
        this.saveMessageResponseDetails(mailResponse);
    }

    private void saveMessageResponseDetails(KafkaMailResponse mailResponse) {
        String executionRequestIdValue;
        Map metadata;
        if (MailMetadata.ATP_RAM.getValue().equals(mailResponse.getService()) && Objects.nonNull(metadata = mailResponse.getMetadata()) && !metadata.isEmpty() && !Strings.isNullOrEmpty((String)(executionRequestIdValue = String.valueOf(metadata.get(MailMetadata.EXECUTION_REQUEST_ID.getValue()))))) {
            UUID executionRequestId = UUID.fromString(executionRequestIdValue);
            log.debug("Create details for mail response for id '{}'", (Object)executionRequestId);
            ExecutionRequestDetails details = new ExecutionRequestDetails();
            details.setUuid(UUID.randomUUID());
            details.setName(DETAILS_SECTION_REPORTING);
            details.setExecutionRequestId(executionRequestId);
            TestingStatuses testingStatuses = mailResponse.getStatus() == KafkaMailResponseStatus.ERROR ? TestingStatuses.FAILED : TestingStatuses.PASSED;
            details.setStatus(testingStatuses);
            this.reportingService.updateReportingStatus(executionRequestId, testingStatuses);
            String message = mailResponse.getMessage();
            String stackTrace = mailResponse.getStacktrace();
            message = this.setMailResponseMessage(message, stackTrace);
            details.setMessage(message);
            details.setDate(new Date());
            this.detailsRepository.save(details);
            log.debug("Details for mail response successfully created");
        }
    }

    public void saveMessageResponseDetails(MailResponse mailResponse, UUID executionRequestId) {
        log.debug("Create details for mail response for id '{}'", (Object)executionRequestId);
        ExecutionRequestDetails details = new ExecutionRequestDetails();
        details.setUuid(UUID.randomUUID());
        details.setName(DETAILS_SECTION_REPORTING);
        details.setExecutionRequestId(executionRequestId);
        int httpStatus = mailResponse.getStatus();
        TestingStatuses testingStatuses = httpStatus >= 300 ? TestingStatuses.FAILED : TestingStatuses.PASSED;
        details.setStatus(testingStatuses);
        String message = mailResponse.getMessage();
        String stackTrace = mailResponse.getTrace();
        message = this.setMailResponseMessage(message, stackTrace);
        details.setMessage(message);
        details.setDate(new Date());
        this.detailsRepository.save(details);
        log.debug("Details for mail response successfully created");
    }

    public void deleteAllByExecutionRequestDetailsIdIn(List<UUID> executionRequestIds) {
        this.detailsRepository.deleteAllByExecutionRequestIdIn(executionRequestIds);
    }

    private String setMailResponseMessage(String message, String stackTrace) {
        if (Objects.nonNull(stackTrace) && !stackTrace.isEmpty()) {
            return this.generateErrorMsg(message, stackTrace);
        }
        return message;
    }

    private String generateErrorMsg(String message, String stackTrace) {
        return String.format("%s\n\nRoot Cause of the Error:\n%s", message, stackTrace);
    }

    public ExecutionRequestDetailsService(ObjectMapper objectMapper, ExecutionRequestDetailsRepository detailsRepository, ExecutionRequestReportingService reportingService) {
        this.objectMapper = objectMapper;
        this.detailsRepository = detailsRepository;
        this.reportingService = reportingService;
    }
}

