/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.modelmapper.ModelMapper;
import org.qubership.atp.ram.converter.DtoConvertService;
import org.qubership.atp.ram.model.TestRunForRefreshFromJira;
import org.qubership.atp.ram.model.TestRunToJiraInfo;
import org.qubership.atp.ram.models.EnvironmentsInfo;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.RamObject;
import org.qubership.atp.ram.models.SystemInfo;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.repositories.ExecutionRequestRepository;
import org.qubership.atp.ram.repositories.TestRunRepository;
import org.qubership.atp.ram.services.CatalogueService;
import org.qubership.atp.ram.services.EnvironmentsInfoService;
import org.qubership.atp.ram.services.TestRunService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class JiraIntegrationService {
    private static final Logger log = LoggerFactory.getLogger(JiraIntegrationService.class);
    private final TestRunRepository repository;
    private final TestRunService testRunService;
    private final ExecutionRequestRepository executionRequestRepository;
    private final CatalogueService catalogueService;
    private final EnvironmentsInfoService environmentsInfoService;
    private final ModelMapper modelMapper;
    private final ObjectMapper objectMapper;
    private final String catalogueUrl;
    private final DtoConvertService dtoConverter;

    public JiraIntegrationService(TestRunRepository repository, TestRunService testRunService, ExecutionRequestRepository executionRequestRepository, CatalogueService catalogueService, EnvironmentsInfoService environmentsInfoService, ModelMapper modelMapper, ObjectMapper objectMapper, @Value(value="${catalogue.url}") String catalogueUrl, DtoConvertService dtoConverter) {
        this.repository = repository;
        this.testRunService = testRunService;
        this.executionRequestRepository = executionRequestRepository;
        this.catalogueService = catalogueService;
        this.environmentsInfoService = environmentsInfoService;
        this.modelMapper = modelMapper;
        this.objectMapper = objectMapper;
        this.catalogueUrl = catalogueUrl;
        this.dtoConverter = dtoConverter;
    }

    public List<TestRunToJiraInfo> getTestRunsForJiraInfoByExecutionId(UUID executionRequestId) {
        List<TestRun> testRuns = this.testRunService.findAllByExecutionRequestId(executionRequestId);
        return this.getTestRunsForJiraInfo(testRuns);
    }

    public List<TestRunToJiraInfo> getTestRunsForJiraInfoByIds(List<UUID> testRunIds) {
        List<TestRun> testRuns = this.repository.findAllByUuidIn(testRunIds);
        return this.getTestRunsForJiraInfo(testRuns);
    }

    public List<TestRunToJiraInfo> getTestRunsForJiraInfo(List<TestRun> testRuns) {
        List<UUID> executionRequestIds = testRuns.stream().map(TestRun::getExecutionRequestId).distinct().collect(Collectors.toList());
        Map erMap = this.executionRequestRepository.findAllByUuidIn(executionRequestIds).stream().collect(Collectors.toMap(RamObject::getUuid, Function.identity()));
        Map environmentsInfoMap = this.environmentsInfoService.findByRequestIds(executionRequestIds).stream().collect(Collectors.toMap(EnvironmentsInfo::getEnvironmentId, Function.identity(), (env1, env2) -> {
            log.trace("Same env found, take any {}", env1);
            return env1;
        }));
        ArrayList<TestRunToJiraInfo> testRunToJiraInfos = new ArrayList<TestRunToJiraInfo>();
        for (TestRun testRun : testRuns) {
            TestRun lastRun = this.testRunService.getByTestCase(testRun.getTestCaseId());
            ExecutionRequest executionRequest = (ExecutionRequest)erMap.get(testRun.getExecutionRequestId());
            boolean isLastRun = testRun.getUuid().equals(lastRun.getUuid());
            TestRunToJiraInfo testRunToJiraInfo = (TestRunToJiraInfo)this.modelMapper.map((Object)testRun, TestRunToJiraInfo.class);
            testRunToJiraInfo.setLastRun(isLastRun);
            testRunToJiraInfo.setTestRunAtpLink(this.generateTestRunLink(testRun, executionRequest));
            EnvironmentsInfo environmentsInfo = (EnvironmentsInfo)environmentsInfoMap.get(executionRequest.getEnvironmentId());
            testRunToJiraInfo.setEnvironmentInfo(this.formatComment(environmentsInfo));
            testRunToJiraInfos.add(testRunToJiraInfo);
        }
        try {
            log.debug("propagateRequests {}", (Object)this.objectMapper.writeValueAsString(testRunToJiraInfos));
        }
        catch (JsonProcessingException e) {
            log.error("Unable to parse propagateRequests json data", (Throwable)e);
        }
        return testRunToJiraInfos;
    }

    private String formatComment(EnvironmentsInfo environmentsInfo) {
        if (environmentsInfo == null || CollectionUtils.isEmpty((Collection)environmentsInfo.getQaSystemInfoList())) {
            return "Environments Info is not available";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("||Environment Name|| Urls|| Version||\n");
        for (SystemInfo systemInfo : environmentsInfo.getQaSystemInfoList()) {
            stringBuilder.append("|").append(systemInfo.getName()).append("|").append(systemInfo.getUrls()).append("|").append(StringUtils.isBlank((CharSequence)systemInfo.getVersion()) ? "-" : systemInfo.getVersion()).append("|\n");
        }
        return stringBuilder.toString();
    }

    private String generateTestRunLink(TestRun testRun, ExecutionRequest executionRequest) {
        String atp2Link = this.catalogueUrl + "/project/" + executionRequest.getProjectId() + "/ram/execution-request/" + executionRequest.getUuid() + "?node=" + testRun.getUuid();
        log.debug("Generated atp link {} for test run {}", (Object)atp2Link, (Object)testRun);
        return atp2Link;
    }

    public List<TestRunForRefreshFromJira> getTestRunsForRefreshFromJira(List<UUID> testRunIds) {
        ArrayList<TestRunForRefreshFromJira> testRunsForRefreshList = new ArrayList<TestRunForRefreshFromJira>();
        List<TestRun> testRuns = this.repository.findAllByUuidIn(testRunIds);
        for (TestRun testRun : testRuns) {
            TestRun lastRun = this.testRunService.getByTestCase(testRun.getTestCaseId());
            boolean isLastRun = testRun.getUuid().equals(lastRun.getUuid());
            TestRunForRefreshFromJira testRunForRefresh = (TestRunForRefreshFromJira)this.modelMapper.map((Object)testRun, TestRunForRefreshFromJira.class);
            testRunForRefresh.setLastRun(isLastRun);
            testRunsForRefreshList.add(testRunForRefresh);
        }
        return testRunsForRefreshList;
    }

    public void syncWithJira(ExecutionRequest executionRequest) {
        UUID erId = executionRequest.getUuid();
        this.catalogueService.autoSyncTestRunsWithJira(executionRequest.getProjectId(), erId, executionRequest.isAutoSyncCasesWithJira(), executionRequest.isAutoSyncRunsWithJira(), this.getTestRunsForJiraInfoByExecutionId(erId));
    }
}

