/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.modelmapper.ModelMapper;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpIllegalNullableArgumentException;
import org.qubership.atp.auth.springbootstarter.utils.ExceptionUtils;
import org.qubership.atp.ram.dto.request.LogRecordQuantityMatchPatternRequest;
import org.qubership.atp.ram.dto.request.UpdateLogRecordContextVariablesRequest;
import org.qubership.atp.ram.dto.request.UpdateLogRecordExecutionStatusRequest;
import org.qubership.atp.ram.dto.request.UpdateLogRecordMessageParametersRequest;
import org.qubership.atp.ram.dto.response.ContextVariablesResponse;
import org.qubership.atp.ram.dto.response.LocationInEditorResponse;
import org.qubership.atp.ram.dto.response.LogRecordPreviewResponse;
import org.qubership.atp.ram.dto.response.LogRecordQuantityResponse;
import org.qubership.atp.ram.dto.response.LogRecordResponse;
import org.qubership.atp.ram.dto.response.LogRecordScreenshotResponse;
import org.qubership.atp.ram.dto.response.LogRecordShort;
import org.qubership.atp.ram.dto.response.MessageParameter;
import org.qubership.atp.ram.dto.response.PaginationResponse;
import org.qubership.atp.ram.dto.response.ScreenshotResponse;
import org.qubership.atp.ram.dto.response.logrecord.Content;
import org.qubership.atp.ram.dto.response.logrecord.LogRecordContentResponse;
import org.qubership.atp.ram.entities.AkbContext;
import org.qubership.atp.ram.entities.ErrorMappingItem;
import org.qubership.atp.ram.enums.ContextVariablesActiveTab;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.MaskCondition;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.enums.TypeAction;
import org.qubership.atp.ram.exceptions.logrecords.RamIllegalLogRecordsFetchSourceException;
import org.qubership.atp.ram.mapper.Mapper;
import org.qubership.atp.ram.model.LogRecordFilteringRequest;
import org.qubership.atp.ram.model.LogRecordWithChildrenResponse;
import org.qubership.atp.ram.model.LogRecordWithParentListResponse;
import org.qubership.atp.ram.model.SubstepScreenshotResponse;
import org.qubership.atp.ram.models.AkbRecord;
import org.qubership.atp.ram.models.BrowserConsoleLogsTable;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.Issue;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.models.LogRecordContextVariable;
import org.qubership.atp.ram.models.LogRecordMessageParameters;
import org.qubership.atp.ram.models.LogRecordStepContextVariable;
import org.qubership.atp.ram.models.MetaInfo;
import org.qubership.atp.ram.models.SsmMetricReports;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.models.logrecords.BvLogRecord;
import org.qubership.atp.ram.models.logrecords.CompoundLogRecord;
import org.qubership.atp.ram.models.logrecords.UiLogRecord;
import org.qubership.atp.ram.models.logrecords.parts.ContextVariable;
import org.qubership.atp.ram.repositories.AkbRecordsRepository;
import org.qubership.atp.ram.repositories.CustomLogRecordRepository;
import org.qubership.atp.ram.repositories.ExecutionRequestRepository;
import org.qubership.atp.ram.repositories.IssueRepository;
import org.qubership.atp.ram.repositories.LogRecordContextVariableCommonRepository;
import org.qubership.atp.ram.repositories.LogRecordContextVariableRepository;
import org.qubership.atp.ram.repositories.LogRecordMessageParametersRepository;
import org.qubership.atp.ram.repositories.LogRecordRepository;
import org.qubership.atp.ram.repositories.LogRecordStepContextVariableRepository;
import org.qubership.atp.ram.repositories.TestRunRepository;
import org.qubership.atp.ram.services.BrowserConsoleLogService;
import org.qubership.atp.ram.services.CatalogueService;
import org.qubership.atp.ram.services.CrudService;
import org.qubership.atp.ram.services.ExecutionRequestService;
import org.qubership.atp.ram.services.GridFsService;
import org.qubership.atp.ram.services.LogRecordContextVariableService;
import org.qubership.atp.ram.utils.PathsGenerator;
import org.qubership.atp.ram.utils.SourceShot;
import org.qubership.atp.ram.utils.StepPath;
import org.qubership.atp.ram.utils.StreamUtils;
import org.qubership.atp.ram.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Service;

@Service
public class LogRecordService
extends CrudService<LogRecord> {
    private static final Logger log = LoggerFactory.getLogger(LogRecordService.class);
    static final Map<TestingStatuses, TestingStatuses> invertStatusMap = new HashMap<TestingStatuses, TestingStatuses>();
    private static final String TEST_RUN = "testrun";
    private static final String EXECUTION_REQUEST = "executionrequest";
    private static final String BASE_64_PREFIX = "data:image/png;base64,";
    @Value(value="${browser.monitoring.link}")
    private String browserMonitoringLinkTemplate;
    private final Mapper<LogRecord, LogRecordShort> logRecordMapper;
    private final LogRecordRepository repository;
    private final LogRecordContextVariableRepository logRecordContextRepository;
    private final LogRecordStepContextVariableRepository logRecordStepContextRepository;
    private final LogRecordMessageParametersRepository logRecordMessageParametersRepository;
    private final TestRunRepository testRunRepository;
    private final GridFsService gridFsService;
    private final AkbRecordsRepository akbRecordsRepository;
    private final ExecutionRequestRepository executionRequestRepository;
    private final ModelMapper modelMapper;
    private final CustomLogRecordRepository customLogRecordRepository;
    private final IssueRepository issueRepository;
    private final CatalogueService catalogueService;
    private final LogRecordContextVariableService contextVariableService;
    private final BrowserConsoleLogService browserConsoleLogService;

    @PostConstruct
    public void init() {
        invertStatusMap.put(TestingStatuses.FAILED, TestingStatuses.PASSED);
        invertStatusMap.put(TestingStatuses.PASSED, TestingStatuses.FAILED);
        invertStatusMap.put(TestingStatuses.WARNING, TestingStatuses.FAILED);
    }

    @Override
    protected MongoRepository<LogRecord, UUID> repository() {
        return this.repository;
    }

    @Override
    public List<LogRecord> getAll() {
        return this.repository.findAll();
    }

    public List<LogRecord> getByIds(List<UUID> logRecordIds) {
        return (List)this.repository.findAllById(logRecordIds);
    }

    public Stream<LogRecord> getLogRecordChildren(UUID id) {
        return this.repository.findAllByParentRecordIdIsOrderByCreatedDateStampAsc(id);
    }

    public List<ContextVariable> getStepContextVariablesOfLogRecord(UUID id) {
        LogRecordStepContextVariable stepContext = (LogRecordStepContextVariable)this.logRecordStepContextRepository.getById(id);
        return Objects.isNull(stepContext) ? Collections.EMPTY_LIST : stepContext.getContextVariables();
    }

    public List<ContextVariable> getContextVariablesByIds(List<UUID> logRecordIds) {
        List<LogRecordContextVariable> logRecordContextVariables = this.logRecordContextRepository.findAllByIdIn(logRecordIds);
        if (logRecordContextVariables == null) {
            return Collections.emptyList();
        }
        return logRecordContextVariables.stream().flatMap(logRecordContextVariable -> logRecordContextVariable.getContextVariables().stream()).collect(Collectors.toList());
    }

    private List<ContextVariable> getContextVariables(UUID id, LogRecordContextVariableCommonRepository repository) {
        Object logRecordContextVariables = repository.getById(id);
        if (logRecordContextVariables == null) {
            return Collections.emptyList();
        }
        return logRecordContextVariables.getContextVariables();
    }

    private Object getContextVariables(UUID id, Integer page, Integer size, List<ContextVariablesActiveTab> activeTabs, LogRecordContextVariableCommonRepository repository) {
        List<ContextVariable> contextVariables = this.getContextVariables(id, repository);
        if (CollectionUtils.isEmpty(contextVariables) || Objects.isNull(page) || Objects.isNull(size) || CollectionUtils.isEmpty(activeTabs)) {
            return Collections.emptyList();
        }
        Collections.sort(contextVariables);
        return this.contextVariableService.getPagedContextVariables(contextVariables, page, size, activeTabs);
    }

    public Object getContextVariables(UUID id, Integer page, Integer size, List<ContextVariablesActiveTab> activeTabs) {
        return this.getContextVariables(id, page, size, activeTabs, this.logRecordContextRepository);
    }

    public List<ContextVariable> getAllContextVariables(UUID id) {
        return this.getContextVariables(id, this.logRecordContextRepository);
    }

    public Object getStepContextVariables(UUID id, Integer page, Integer size, List<ContextVariablesActiveTab> activeTabs) {
        return this.getContextVariables(id, page, size, activeTabs, this.logRecordStepContextRepository);
    }

    private ContextVariablesResponse filterContextVariables(UUID id, List<String> parameters, String beforeValue, String afterValue, LogRecordContextVariableCommonRepository repository) {
        List<ContextVariable> contextVariables = this.getContextVariables(id, repository);
        if (CollectionUtils.isEmpty(contextVariables)) {
            return new ContextVariablesResponse();
        }
        return this.contextVariableService.filterAndSplitContextVariables(contextVariables, parameters, beforeValue, afterValue);
    }

    public ContextVariablesResponse filterContextVariables(UUID id, List<String> parameters, String beforeValue, String afterValue) {
        return this.filterContextVariables(id, parameters, beforeValue, afterValue, this.logRecordContextRepository);
    }

    public ContextVariablesResponse filterStepContextVariables(UUID id, List<String> parameters, String beforeValue, String afterValue) {
        return this.filterContextVariables(id, parameters, beforeValue, afterValue, this.logRecordStepContextRepository);
    }

    public void delete(UUID uuid) {
        this.repository.deleteByUuid(uuid);
    }

    public List<LogRecord> getOrderedChildrenLogRecordsForParentLogRecord(UUID uuid) {
        return this.repository.findAllByParentRecordIdOrderByStartDateAsc(uuid);
    }

    public LogRecord create() {
        return (LogRecord)this.repository.save(new LogRecord());
    }

    @Override
    public LogRecord save(LogRecord logRecord) {
        LogRecord logRecordUpd = (LogRecord)this.repository.save(logRecord);
        this.updateAllParentsStatuses(logRecordUpd);
        return logRecordUpd;
    }

    public LogRecord findById(UUID logRecordId) {
        LogRecord logRecord = this.repository.findByUuid(logRecordId);
        Preconditions.checkNotNull((Object)logRecord, (Object)("Cannot find log record by ID " + logRecordId));
        Stream<LogRecord> children = this.getLogRecordChildren(logRecordId);
        logRecord.setChildren(children.map(LogRecord.Child::new).collect(Collectors.toList()));
        logRecord.setContextVariablesPresent(this.isContextVariablesPresent(logRecordId));
        logRecord.setBrowserConsoleLogsPresent(this.browserConsoleLogService.isBrowserConsoleLogsPresent(logRecordId));
        logRecord.setMessageParametersPresent(this.isMessageParametersPresent(logRecordId));
        if (logRecord instanceof UiLogRecord) {
            this.setBrowserMonitoringLink((UiLogRecord)logRecord);
        }
        return logRecord;
    }

    private void setBrowserMonitoringLink(UiLogRecord uiLogRecord) {
        if (Strings.isNullOrEmpty((String)this.browserMonitoringLinkTemplate) || Objects.isNull(uiLogRecord.getBrowserName()) || Objects.isNull(uiLogRecord.getStartDate()) || Objects.isNull(uiLogRecord.getEndDate())) {
            log.warn("Can't generate browser monitoring link for logRecord '{}' due to empty template or logRecord params: template={}, BrowserName={}, StartDate={}, EndDate={}", new Object[]{uiLogRecord.getUuid(), this.browserMonitoringLinkTemplate, uiLogRecord.getBrowserName(), uiLogRecord.getStartDate(), uiLogRecord.getEndDate()});
        } else {
            uiLogRecord.setBrowserMonitoringLink(this.browserMonitoringLinkTemplate.replace("%{browser_pod}", uiLogRecord.getBrowserName()).replace("%{from_timestamp}", Long.toString(uiLogRecord.getStartDate().getTime())).replace("%{to_timestamp}", Long.toString(uiLogRecord.getEndDate().getTime())));
        }
    }

    public LogRecord findLastInProgressLogRecordByTestRunId(UUID testRunId) {
        return this.repository.findFirstByTestRunIdAndExecutionStatusOrderByCreatedDateStampDesc(testRunId, ExecutionStatuses.IN_PROGRESS);
    }

    public LogRecord findLastInProgressOrcLogRecordByTestRunId(UUID testRunId) {
        return this.customLogRecordRepository.findLastOrcLogRecordByTestRunAndExecutionStatus(testRunId, ExecutionStatuses.IN_PROGRESS);
    }

    private boolean isContextVariablesPresent(UUID logRecordId) {
        return this.logRecordContextRepository.existsById(logRecordId) || this.logRecordStepContextRepository.existsById(logRecordId);
    }

    private boolean isMessageParametersPresent(UUID logRecordId) {
        return this.logRecordMessageParametersRepository.existsById(logRecordId);
    }

    @Deprecated
    private LogRecord findByRequestOrCreate(LogRecord request) {
        UUID logRecordId = request.getUuid();
        LogRecord logRecord = this.repository.findByUuid(logRecordId);
        if (Objects.isNull(logRecord)) {
            log.trace("Log Record: {} not found.", (Object)logRecordId);
            logRecord = this.createLogRecordByRequest(request);
        }
        return logRecord;
    }

    private void updateAllParentsStatuses(@NotNull LogRecord logRecord) {
        UUID parentId = logRecord.getParentRecordId();
        if (Objects.isNull(parentId)) {
            TestRun testRun = this.testRunRepository.findByUuid(logRecord.getTestRunId());
            testRun.updateTestingStatus(logRecord.getTestingStatus());
            this.testRunRepository.save(testRun);
        } else {
            LogRecord parent = this.repository.findByUuid(parentId);
            if (Objects.nonNull(parent)) {
                parent.setTestingStatus(logRecord.getTestingStatus());
                this.save(parent);
            }
        }
    }

    public PaginationResponse<BrowserConsoleLogsTable> getBrowserConsoleLogsTable(UUID logRecordUuid, Pageable pageable) {
        return this.browserConsoleLogService.getBrowserConsoleLogsTable(logRecordUuid, pageable);
    }

    public void createBrowserConsoleLog(UUID logRecordUuid, List<BrowserConsoleLogsTable> logs) {
        this.browserConsoleLogService.createBrowserConsoleLog(logRecordUuid, logs);
    }

    public String addLogRecordAkb(UUID logRecordId, UUID akbRecordId) {
        if (Objects.isNull(logRecordId)) {
            log.error("Found illegal nullable log record id for the validated method parameter");
            throw new AtpIllegalNullableArgumentException("log record id", "method parameter");
        }
        if (Objects.isNull(akbRecordId)) {
            log.error("Found illegal nullable akb record id for the validated method parameter");
            throw new AtpIllegalNullableArgumentException("akb record id", "method parameter");
        }
        LogRecord logRecord = (LogRecord)this.get(logRecordId);
        AkbRecord akbRecord = this.akbRecordsRepository.findByUuid(akbRecordId);
        if (Objects.isNull(akbRecord)) {
            log.warn("AKB wasn't added to Log Record. There is no AKB {}.", (Object)akbRecordId);
            return "There is no AKB with uuid: " + akbRecordId;
        }
        this.repository.save(logRecord);
        log.trace("AKB: {} added to Log Record: {}.", (Object)logRecordId, (Object)akbRecordId);
        return "AKB with uuid: " + akbRecordId + " was successfully added to LogRecord with uuid: " + logRecordId;
    }

    public void saveCountScreenshots(UUID executionRequestUuid, List<TestRun> testRuns) {
        int numberOfScreen = 0;
        HashMap<UUID, String> trIdAndNumberOfScreens = new HashMap<UUID, String>();
        for (TestRun testRun : testRuns) {
            UUID testRunId = testRun.getUuid();
            try {
                List<LogRecord> logRecords = this.getAllLogRecordsUuidByTestRunId(testRunId);
                if (!logRecords.isEmpty()) {
                    numberOfScreen = this.gridFsService.getCountScreen(logRecords);
                }
                trIdAndNumberOfScreens.put(testRunId, String.valueOf(numberOfScreen));
                testRun.setNumberOfScreens(numberOfScreen);
            }
            catch (Exception e) {
                log.error("Error in calculating screenshots count for Test Run {}.", (Object)testRunId, (Object)e);
            }
        }
        this.testRunRepository.saveAll(testRuns);
        log.trace("Number of screens for ER {}: {}", (Object)executionRequestUuid, trIdAndNumberOfScreens);
    }

    public void analyze(TestRun testRun) {
        List<LogRecord> logRecords = this.getAllNotSectionLogRecordsByTestRunId(testRun.getUuid());
        List akbRecords = this.akbRecordsRepository.findAll();
        for (LogRecord logRecord : logRecords) {
            for (AkbRecord akbRecord : akbRecords) {
                this.analyzeAkbRecord(akbRecord, logRecord, testRun);
            }
        }
    }

    @Deprecated
    public LogRecord createLogRecordByRequest(LogRecord request) {
        UUID logRecordId = request.getUuid();
        log.trace("Creating Log Record: {}", (Object)logRecordId);
        LogRecord record = request;
        Timestamp startDate = new Timestamp(System.currentTimeMillis());
        Timestamp finishDate = new Timestamp(System.currentTimeMillis());
        try {
            startDate = record.getStartDate();
        }
        catch (Exception e) {
            log.error("Cannot parse StartDate in request!", (Throwable)e);
        }
        record.setStartDate(startDate);
        record.setEndDate(finishDate);
        record.setDuration(TimeUtils.getDuration(startDate, finishDate));
        record.setCreatedDate(new Timestamp(System.currentTimeMillis()));
        return this.save(record);
    }

    private void analyzeAkbRecord(AkbRecord akbRecord, LogRecord logRecord, TestRun testRun) {
        if (!this.checkAkbByContext(akbRecord, testRun)) {
            log.debug("Limit by AKB context, Akb Record {}, Log Record: {}", (Object)akbRecord.getUuid(), (Object)logRecord.getUuid());
            return;
        }
        String message = logRecord.getMessage();
        String name = logRecord.getName();
        String messageRegularExpression = akbRecord.getMessageRegularExpression();
        String nameRegularExpression = akbRecord.getNameRegularExpression();
        MaskCondition maskCondition = akbRecord.getMaskCondition();
        boolean isOrCondition = maskCondition == null || MaskCondition.OR.equals((Object)maskCondition);
        boolean condition = this.isSuccessfulAnalyzeByAkb(name, nameRegularExpression);
        condition = isOrCondition ? (condition |= this.isSuccessfulAnalyzeByAkb(message, messageRegularExpression)) : (condition &= this.isSuccessfulAnalyzeByAkb(message, messageRegularExpression));
        if (condition) {
            this.updateObjectsAfterAnalyze(testRun, akbRecord, logRecord);
        }
    }

    private boolean checkAkbByContext(AkbRecord akbRecord, TestRun testRun) {
        AkbContext context = akbRecord.getAkbContext();
        if (context == null) {
            return true;
        }
        List tcNameByContext = context.getTestCasesName();
        List tpUuidByContext = context.getTestPlansId();
        String tcNameByTestRun = testRun.getTestCaseName();
        UUID tpUuidByTestRun = this.executionRequestRepository.findByUuid(testRun.getExecutionRequestId()).getTestPlanId();
        boolean res = true;
        if (!tcNameByContext.isEmpty()) {
            res = tcNameByContext.contains(tcNameByTestRun);
        }
        if (!tpUuidByContext.isEmpty()) {
            res &= tpUuidByContext.contains(tpUuidByTestRun);
        }
        return res;
    }

    private boolean isSuccessfulAnalyzeByAkb(String valueForAnalyze, String regularExpression) {
        String regExp = regularExpression;
        if (null != regExp) {
            Pattern p = Pattern.compile(regExp);
            Matcher m = p.matcher(valueForAnalyze);
            return m.find();
        }
        return false;
    }

    private void updateObjectsAfterAnalyze(TestRun testRun, AkbRecord akbRecord, LogRecord lr) {
        UUID rootCauseType = akbRecord.getRootCauseId();
        if (rootCauseType != null) {
            testRun.setRootCauseId(rootCauseType);
            this.testRunRepository.save(testRun);
        }
        this.addLogRecordAkb(lr.getUuid(), akbRecord.getUuid());
    }

    public List<ErrorMappingItem> getErrorMapping(ExecutionRequestService executionRequestService, String source, UUID parentUuid) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)source) ? 1 : 0) != 0, (Object)"LogRecord source is not specified. Use TestRun or ExecutionRequest");
        Preconditions.checkArgument((boolean)Objects.nonNull(parentUuid), (Object)"ParentUuid of LogRecords can't be empty");
        List<LogRecord> logRecords = this.getLogRecords(executionRequestService, source, parentUuid);
        return logRecords.stream().map(ErrorMappingItem::new).collect(Collectors.toList());
    }

    private List<LogRecord> getLogRecords(ExecutionRequestService executionRequestService, String source, UUID parentId) {
        LinkedList logRecords = Lists.newLinkedList();
        switch (source.toLowerCase()) {
            case "testrun": {
                logRecords.addAll(this.findLogRecordsWithSpecificFieldsByTestRunIdOrderByStartDateAsc(parentId));
                break;
            }
            case "executionrequest": {
                List<TestRun> runs = executionRequestService.getAllTestRuns(parentId);
                runs.stream().map(testRun -> this.findLogRecordsWithSpecificFieldsByTestRunIdOrderByStartDateAsc(testRun.getUuid())).collect(Collectors.toList()).forEach(logRecords::addAll);
                break;
            }
            default: {
                ExceptionUtils.throwWithLog((Logger)log, (AtpException)new RamIllegalLogRecordsFetchSourceException());
            }
        }
        return logRecords;
    }

    public UUID getProjectIdByParentId(UUID parentId, String source) {
        switch (source.toLowerCase()) {
            case "testrun": {
                return this.testRunRepository.findProjectIdByTestRunId(parentId);
            }
            case "executionrequest": {
                return this.executionRequestRepository.findProjectIdByUuid(parentId).getProjectId();
            }
        }
        throw new IllegalArgumentException("Invalid LogRecord source is specified. Use 'TestRun' or 'ExecutionRequest'");
    }

    public StepPath getLogRecordPath(UUID uuid) {
        PathsGenerator pathsGenerator = new PathsGenerator(this);
        return pathsGenerator.generatePathToFoundLogRecord(uuid);
    }

    public LogRecord addLogRecordAkbRecords(UUID logRecordUuid, List<UUID> akbRecordsUuid) {
        Preconditions.checkNotNull((Object)logRecordUuid, (Object)"LogRecordUuid cannot be null");
        Preconditions.checkNotNull(akbRecordsUuid, (Object)"AKB Records cannot be null");
        LogRecord logRecord = this.repository.findByUuid(logRecordUuid);
        List newAkbRecords = akbRecordsUuid.stream().map(this.akbRecordsRepository::findByUuid).collect(Collectors.toList());
        log.debug("Akb Records: {} was added for Log Record: {}", (Object)akbRecordsUuid.toString(), (Object)logRecordUuid);
        return this.save(logRecord);
    }

    public List<LogRecord> findByTestRunIdAndParentUuid(UUID testRunId, UUID parentId, LogRecordFilteringRequest filteringRequest) {
        if (filteringRequest != null) {
            List<String> statuses = filteringRequest.getStatuses();
            List<String> types = filteringRequest.getTypes();
            boolean showNotAnalyzedItemsOnly = filteringRequest.isShowNotAnalyzedItemsOnly();
            if (!CollectionUtils.isEmpty(statuses) || !CollectionUtils.isEmpty(types)) {
                return this.customLogRecordRepository.getTopLogRecordsByFilterLookup(testRunId, statuses, types, showNotAnalyzedItemsOnly);
            }
        }
        return this.repository.findLogRecordsForTreeByTestRunIdAndParentRecordIdOrderByCreatedDateStampAsc(testRunId, parentId).stream().filter(logRecord -> this.filterLogRecordByRequest((LogRecord)logRecord, filteringRequest)).collect(Collectors.toList());
    }

    public List<LogRecord> findTopLogRecordsOnTestRun(UUID testRunId) {
        return this.repository.findLogRecordsByTestRunIdAndParentRecordIdOrderByCreatedDateStampAsc(testRunId, null);
    }

    private boolean filterLogRecordByRequest(LogRecord logRecord, LogRecordFilteringRequest filteringRequest) {
        if (filteringRequest == null) {
            return true;
        }
        return !(filteringRequest.getStatuses() != null && !filteringRequest.getStatuses().stream().anyMatch(status -> status.compareToIgnoreCase(logRecord.getTestingStatus().name()) == 0) || filteringRequest.getTypes() != null && !filteringRequest.getTypes().stream().anyMatch(type -> type.compareToIgnoreCase(logRecord.getType().name()) == 0) || filteringRequest.isShowNotAnalyzedItemsOnly() && logRecord.getRootCause() != null);
    }

    public List<LogRecord> findAllByTestRunIdOrderByStartDateAsc(UUID testRunUuid, LogRecordFilteringRequest filteringRequest) {
        List<LogRecord> records = this.repository.findAllByTestRunIdOrderByStartDateAsc(testRunUuid);
        return records.stream().filter(logRecord -> this.filterLogRecordByRequest((LogRecord)logRecord, filteringRequest)).collect(Collectors.toList());
    }

    public List<LogRecord> findLogRecordsWithPreviewByTestRunIdOrderByStartDateAsc(UUID testRunUuid, LogRecordFilteringRequest filteringRequest) {
        Stream<LogRecord> records = this.repository.findLogRecordsWithPreviewByTestRunIdOrderByStartDateAsc(testRunUuid);
        return records.filter(logRecord -> this.filterLogRecordByRequest((LogRecord)logRecord, filteringRequest)).collect(Collectors.toList());
    }

    public List<LogRecord> findLogRecordsWithSpecificFieldsByTestRunIdOrderByStartDateAsc(UUID testRunId) {
        return this.repository.findLogRecordsWithSpecificFieldsByTestRunIdOrderByStartDateAsc(testRunId);
    }

    public List<LogRecord> findLogRecordNamesByTestRunId(UUID testRunUuid) {
        return this.repository.findAllNameByTestRunId(testRunUuid);
    }

    public long getChildrenCount(LogRecord lr) {
        return this.repository.countAllByParentRecordIdIs(lr.getUuid());
    }

    public UUID getProjectIdByLogRecordId(UUID id) {
        return this.customLogRecordRepository.getProjectIdByLogRecordId(id);
    }

    @Deprecated
    public LogRecord findOrCreate(LogRecord request) {
        log.debug("Start of search (or creating - if the Log Record was not found) by request:\n{}", (Object)request);
        LogRecord logRecord = this.findByRequestOrCreate(request);
        TestRun testRun = this.findByRequest(request);
        if (ExecutionStatuses.TERMINATED.equals((Object)testRun.getExecutionStatus())) {
            log.warn("TestRun [{}] is already terminated", (Object)testRun.getUuid());
        } else {
            testRun.setExecutionStatus(ExecutionStatuses.IN_PROGRESS);
            this.testRunRepository.save(testRun);
            ExecutionRequest executionRequest = this.executionRequestRepository.findByUuid(testRun.getExecutionRequestId());
            executionRequest.setExecutionStatus(ExecutionStatuses.IN_PROGRESS);
            this.executionRequestRepository.save(executionRequest);
            log.trace("Set In Progress status for TR {} and ER {}.", (Object)testRun.getUuid(), (Object)testRun.getExecutionRequestId());
        }
        return logRecord;
    }

    @Nonnull
    @Deprecated
    public TestRun findByRequest(LogRecord request) {
        LogRecord logRecord = this.findById(request.getUuid());
        if (Objects.isNull(logRecord) || Objects.isNull(logRecord.getTestRunId())) {
            return this.testRunRepository.findByUuid(logRecord.getTestRunId());
        }
        return this.testRunRepository.findByUuid(logRecord.getTestRunId());
    }

    public List<LogRecord> getAllLogRecordsUuidByTestRunId(UUID testRunId) {
        return this.repository.findAllUuidByTestRunId(testRunId);
    }

    public List<LogRecord> getAllSectionNotCompoundLogRecordsByTestRunId(UUID testRunId) {
        return this.repository.findAllByTestRunIdAndIsSectionAndIsCompaund(testRunId, true, false);
    }

    public List<LogRecord> getAllNotSectionLogRecordsByTestRunId(UUID testRunId) {
        return this.repository.findAllByTestRunIdAndIsSection(testRunId, false);
    }

    public List<LogRecord> getAllFailedLogRecordsByTestRunId(UUID testRunId) {
        return this.repository.findAllByTestRunIdAndTestingStatus(testRunId, TestingStatuses.FAILED);
    }

    public List<LogRecord> getUuidAndMessageFailedLogRecordsByTestRunId(UUID testRunId) {
        return this.repository.findUuidAndMessageByTestRunIdAndTestingStatus(testRunId, TestingStatuses.FAILED);
    }

    public List<LogRecord> getAllTestingStatusLogRecordsByTestRunId(UUID testRunId) {
        return this.repository.findAllTestingStatusByTestRunId(testRunId);
    }

    public List<LogRecord> getAllFailedLogRecordsByTestRunIds(Collection<UUID> testRunsIds) {
        return this.repository.findAllByTestRunIdInAndTestingStatus(testRunsIds, TestingStatuses.FAILED).collect(Collectors.toList());
    }

    public List<LogRecord> getAllNotStartedLogRecordsByTestRunId(UUID testRunId) {
        return this.repository.findAllByTestRunIdAndTestingStatus(testRunId, TestingStatuses.NOT_STARTED);
    }

    public List<LogRecord> geChildLogRecordsOrParent(UUID id) {
        List<LogRecord> result = this.getOrderedChildrenLogRecordsForParentLogRecord(id);
        if (CollectionUtils.isEmpty(result)) {
            LogRecord parent = this.findById(id);
            if (parent == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(parent);
        }
        return result;
    }

    public List<LogRecord> getAllMatchesLogRecordsByTestRunId(UUID testRunId, String searchValue) {
        return this.repository.findAllByTestRunIdAndNameContains(testRunId, searchValue);
    }

    public Stream<LogRecord> getAllMatchesLogRecordsByTestRunIdCaseInsensitive(UUID testRunId, String searchValue) {
        return this.repository.findAllByTestRunIdAndNameRegex(testRunId, "(?i)\\Q" + searchValue + "\\E");
    }

    public LogRecordResponse getLogRecordByIdWithChildren(UUID uuid) {
        LogRecordShort parent = this.logRecordMapper.entityToDto(this.findById(uuid));
        List children = this.repository.findAllByParentRecordIdIsOrderByCreatedDateStampAsc(uuid).map(this.logRecordMapper::entityToDto).collect(Collectors.toList());
        return new LogRecordResponse(parent, children);
    }

    public LocationInEditorResponse getLocationInEditor(UUID id) {
        LogRecord logRecord;
        LinkedList<Integer> lines = new LinkedList<Integer>();
        LogRecord topLog = logRecord = this.repository.findByUuid(id);
        HashMap<UUID, String> hashSums = new HashMap<UUID, String>();
        while (logRecord != null) {
            MetaInfo metaFoCurrent = logRecord.getMetaInfo();
            if (metaFoCurrent != null) {
                Integer lineForCurrent = metaFoCurrent.getLine();
                if (lineForCurrent != null) {
                    lines.add(0, lineForCurrent);
                }
                UUID currentScenarioId = metaFoCurrent.getScenarioId();
                String currentHashSum = metaFoCurrent.getScenarioHashSum();
                if (currentScenarioId != null && StringUtils.isNotEmpty((String)currentHashSum)) {
                    hashSums.put(currentScenarioId, currentHashSum);
                }
            }
            topLog = logRecord;
            logRecord = this.repository.findByUuid(logRecord.getParentRecordId());
        }
        UUID testRunId = topLog.getTestRunId();
        TestRun testRun = this.testRunRepository.findByUuid(testRunId);
        UUID testCaseId = testRun.getTestCaseId();
        UUID scenarioId = this.catalogueService.getScenarioIdByTestCaseId(testCaseId);
        MetaInfo meta = testRun.getMetaInfo();
        if (meta != null && StringUtils.isNotEmpty((String)meta.getScenarioHashSum())) {
            hashSums.put(scenarioId, meta.getScenarioHashSum());
        }
        boolean isOutOfDate = !this.catalogueService.checkHashSumForScenario(hashSums).isValid();
        String line = StringUtils.join(lines, (String)"_");
        return new LocationInEditorResponse(scenarioId, line, Boolean.valueOf(isOutOfDate));
    }

    public LogRecordContentResponse getLogRecordContent(UUID id) {
        List children = this.repository.findAllByParentRecordIdIsOrderByCreatedDateStampAsc(id).map(child -> (Content)this.modelMapper.map(child, Content.class)).collect(Collectors.toList());
        return new LogRecordContentResponse(children);
    }

    public List<BvLogRecord> getAllTestRunBvLogRecordsWithValidationSteps(UUID testRunId) {
        return this.repository.findAllByTestRunIdAndType(testRunId, TypeAction.BV).stream().filter(logRecord -> Objects.nonNull(logRecord.getValidationTable()) && Objects.nonNull(logRecord.getValidationTable().getSteps()) && !logRecord.getValidationTable().getSteps().isEmpty()).map(logRecord -> (BvLogRecord)logRecord).collect(Collectors.toList());
    }

    public List<LogRecord> getAllByTestingStatusAndTestRunId(TestingStatuses testingStatuses, UUID testRunId) {
        return this.repository.findAllByTestingStatusAndTestRunId(testingStatuses, testRunId);
    }

    public List<LogRecord> findLogRecordsWithValidationParamsByTestRunIds(Collection<UUID> testRunIds) {
        return this.customLogRecordRepository.findLogRecordsByTestRunIdsAndValidationWithHint(testRunIds);
    }

    public List<LogRecord> findFailedLogRecordsWithMetaInfoByTestRunIds(Collection<UUID> testRunIds) {
        return this.repository.findLogRecordsWithMetaInfoByTestRunIdInAndTestingStatus(testRunIds, TestingStatuses.FAILED);
    }

    public Stream<LogRecord> findLogRecordsWithValidationParamsAndFailureByTestRunIds(Collection<UUID> testRunIds) {
        return this.repository.findLogRecordsWithValidationParamsAndFailureByTestRunIds(testRunIds);
    }

    public List<LogRecord> getLogRecordChildrenByName(UUID id, String searchValue) {
        return this.repository.findAllByParentRecordIdAndNameContains(id, searchValue);
    }

    public LogRecordScreenshotResponse getAllLogRecordScreenshotPreviews(UUID logRecordId) {
        log.info("Get log record '{}' children screenshow previews", (Object)logRecordId);
        LogRecord rootLogRecord = (LogRecord)this.get(logRecordId);
        LogRecordScreenshotResponse response = new LogRecordScreenshotResponse();
        List childrenPreviews = this.getAllHierarchicalChildrenLogRecords(logRecordId).stream().filter(logRecord -> TypeAction.UI.equals((Object)logRecord.getType()) && !Strings.isNullOrEmpty((String)logRecord.getPreview())).map(logRecord -> new LogRecordPreviewResponse(rootLogRecord.getTestRunId(), logRecord.getUuid(), logRecord.getPreview(), logRecord.getTestingStatus())).collect(Collectors.toList());
        log.debug("Found children log records with id's: {}", StreamUtils.extractIds(childrenPreviews, LogRecordPreviewResponse::getLogRecordId));
        response.setChildrenPreviews(childrenPreviews);
        if (childrenPreviews.isEmpty()) {
            this.setScreenshotContentToResponse(logRecordId, (ScreenshotResponse)response);
        }
        return response;
    }

    public void updateExecutionStatus(UUID logRecordId, UpdateLogRecordExecutionStatusRequest request) {
        log.info("Update execution status for log record '{}' with request data: {}", (Object)logRecordId, (Object)request);
        LogRecord logRecord = (LogRecord)this.get(logRecordId);
        if (!Strings.isNullOrEmpty((String)request.getName())) {
            logRecord.setName(request.getName());
        }
        logRecord.setExecutionStatus(request.getExecutionStatus());
        if (Objects.nonNull(request.getStartDate())) {
            logRecord.setStartDate(request.getStartDate());
        }
        logRecord.setEndDate(request.getEndDate());
        logRecord.setDuration(request.getDuration());
        log.debug("Update log record '{}' with data: {}", (Object)logRecordId, (Object)logRecord);
        this.repository.save(logRecord);
    }

    private void updateContextVariables(UUID logRecordId, UpdateLogRecordContextVariablesRequest request, LogRecordContextVariableCommonRepository repository) {
        log.info("Update context variables for log record '{}'", (Object)logRecordId);
        Object context = repository.getById(logRecordId);
        if (context == null) {
            context = new LogRecordContextVariable();
        }
        context.setContextVariables(request.getContextVariables());
        log.debug("Update log record '{}' with data: {}", (Object)logRecordId, context);
        repository.save(context);
    }

    public void updateContextVariables(UUID logRecordId, UpdateLogRecordContextVariablesRequest request) {
        this.updateContextVariables(logRecordId, request, this.logRecordContextRepository);
    }

    public void updateStepContextVariables(UUID logRecordId, UpdateLogRecordContextVariablesRequest request) {
        this.updateContextVariables(logRecordId, request, this.logRecordStepContextRepository);
    }

    public void updateMessageParameters(UUID logRecordId, UpdateLogRecordMessageParametersRequest request) {
        log.info("Update message parameters for log record '{}'", (Object)logRecordId);
        LogRecordMessageParameters context = this.logRecordMessageParametersRepository.getById(logRecordId);
        if (context == null) {
            context = new LogRecordMessageParameters();
        }
        context.setMessageParameters(request.getMessageParameters());
        context.setCreatedDate(request.getCreatedDate());
        log.debug("Update log record '{}' with data: {}", (Object)logRecordId, (Object)context);
        this.logRecordMessageParametersRepository.save(context);
    }

    public List<LogRecord> getAllHierarchicalChildrenLogRecords(UUID parentLogRecordId) {
        log.info("Get all hierarchical children log records for parent: {}", (Object)parentLogRecordId);
        ArrayList<LogRecord> logRecords = new ArrayList<LogRecord>();
        List<LogRecord> topLevelChildren = this.getLogRecordChildren(parentLogRecordId).collect(Collectors.toList());
        log.debug("Top level children: {}", StreamUtils.extractIds(topLevelChildren));
        if (!CollectionUtils.isEmpty(topLevelChildren)) {
            topLevelChildren.forEach(childLogRecord -> this.getAllHierarchicalUILogRecords((List<LogRecord>)logRecords, (LogRecord)childLogRecord));
        }
        log.debug("Result: {}", StreamUtils.extractIds(logRecords));
        return logRecords;
    }

    public void getAllHierarchicalUILogRecords(List<LogRecord> list, LogRecord logRecord) {
        if (TypeAction.UI.equals((Object)logRecord.getType()) && logRecord.getPreview() != null) {
            log.debug("Add log record: {}", (Object)logRecord.getUuid());
            list.add(logRecord);
        }
        List<LogRecord> children = this.getLogRecordChildren(logRecord.getUuid()).collect(Collectors.toList());
        log.debug("Children: {}", StreamUtils.extractIds(children));
        if (!CollectionUtils.isEmpty(children)) {
            children.forEach(childLogRecord -> this.getAllHierarchicalUILogRecords(list, (LogRecord)childLogRecord));
        }
    }

    List<LogRecord> findAllByLastUpdatedAfterAndTestRunIdIn(Date lastLoaded, List<UUID> testRunIds) {
        log.info("Find all log records with last update date after '{}' and with test run id in: {}", (Object)lastLoaded, testRunIds);
        List<LogRecord> result = this.repository.findAllByLastUpdatedAfterAndTestRunIdIn(lastLoaded, testRunIds);
        log.debug("Founded log records: {}", StreamUtils.extractIds(result));
        return result;
    }

    public LogRecord revertTestingStatusForLogRecord(UUID logRecordId) {
        LogRecord logRecord = this.findById(logRecordId);
        TestingStatuses testingStatus = logRecord.getTestingStatus();
        TestingStatuses newTestingStatus = null;
        if (testingStatus != null) {
            newTestingStatus = invertStatusMap.get(testingStatus);
        }
        log.info("current status = {}, new status = {} for LR [{}]", new Object[]{testingStatus, newTestingStatus, logRecordId});
        if (newTestingStatus != null) {
            LogRecord parentLog;
            logRecord.setTestingStatusHard(newTestingStatus);
            logRecord = this.save(logRecord);
            log.debug("logRecord = {}", (Object)logRecord);
            if (logRecord.getParentRecordId() != null && (parentLog = this.findById(logRecord.getParentRecordId())) instanceof CompoundLogRecord) {
                this.forceUpdateCompoundTestingStatusByChild(parentLog);
            }
        }
        return logRecord;
    }

    private void forceUpdateCompoundTestingStatusByChild(LogRecord parentLog) {
        LogRecord parentLog0;
        log.debug("start forceUpdateCompoundTestingStatusByChild(parentLog: {})", (Object)parentLog.getUuid());
        List child = parentLog.getChildren();
        TestingStatuses finalTestingStatus = TestingStatuses.UNKNOWN;
        for (LogRecord.Child logRecord : child) {
            finalTestingStatus = TestingStatuses.compareAndGetPriority((TestingStatuses)logRecord.getTestingStatus(), (TestingStatuses)finalTestingStatus);
        }
        log.debug("forceUpdateCompoundTestingStatusByChild: finalTestingStatus = {} for log record {}", (Object)finalTestingStatus, (Object)parentLog.getUuid());
        parentLog.setTestingStatusHard(finalTestingStatus);
        this.save(parentLog);
        log.debug("forceUpdateCompoundTestingStatusByChild: parentLog.getParentRecordId() = {} for log record {}", (Object)parentLog.getParentRecordId(), (Object)parentLog.getUuid());
        if (parentLog.getParentRecordId() != null && (parentLog0 = this.findById(parentLog.getParentRecordId())) instanceof CompoundLogRecord) {
            this.forceUpdateCompoundTestingStatusByChild(parentLog0);
        }
    }

    public LogRecord findLogRecordForTreeByUuid(UUID logRecordId) {
        return this.repository.findLogRecordForTreeByUuid(logRecordId);
    }

    public LogRecordQuantityResponse getQuantityLogRecordsWhichMatchToPatterns(LogRecordQuantityMatchPatternRequest request) {
        long countBeforeUpdateRule;
        UUID failPatternId = request.getFailPatternId();
        UUID executionRequestId = request.getExecutionRequestId();
        log.info("Start getting quantity log records which match to patterns. [executionRequestId = {}, FailPatternId = {}, NewPattern = {}]", new Object[]{executionRequestId, failPatternId, request.getNewPattern()});
        Pattern pattern = Pattern.compile(request.getNewPattern());
        List logRecords = this.testRunRepository.findAllByExecutionRequestId(executionRequestId).stream().flatMap(testRun -> this.getAllFailedLogRecordsByTestRunId(testRun.getUuid()).stream()).collect(Collectors.toList());
        long countAfterUpdateRule = logRecords.stream().filter(logRecord -> !StringUtils.isEmpty((String)logRecord.getMessage()) && pattern.matcher(logRecord.getMessage()).find()).count();
        if (Objects.isNull(failPatternId)) {
            countBeforeUpdateRule = countAfterUpdateRule;
        } else {
            List<Issue> failurePatternBeforeIssues = this.issueRepository.findByFailPatternIdAndExecutionRequestId(failPatternId, executionRequestId);
            countBeforeUpdateRule = failurePatternBeforeIssues.stream().filter(issue -> !CollectionUtils.isEmpty((Collection)issue.getLogRecordIds())).mapToInt(issue -> issue.getLogRecordIds().size()).sum();
        }
        log.debug("Finish getting quantity log records which match to patterns. [countBeforeUpdateRule = {}, countAfterUpdateRule = {}]", (Object)countBeforeUpdateRule, (Object)countAfterUpdateRule);
        return new LogRecordQuantityResponse(Long.valueOf(countBeforeUpdateRule), Long.valueOf(countAfterUpdateRule));
    }

    public List<LogRecord> findLogRecordsWithValidationParamsAndStatusByTrId(UUID testRunId) {
        return this.repository.findLogRecordsWithValidationParamsByTestRunId(testRunId);
    }

    public List<MessageParameter> getLogRecordMessageParameters(UUID id) {
        LogRecordMessageParameters logRecordMessageParameters = this.logRecordMessageParametersRepository.getById(id);
        if (logRecordMessageParameters != null && !logRecordMessageParameters.getMessageParameters().isEmpty()) {
            return logRecordMessageParameters.getMessageParameters();
        }
        return ((LogRecord)this.get(id)).getMessageParameters();
    }

    private List<String> searchContextVariableParameters(UUID logRecordId, String name, LogRecordContextVariableCommonRepository repository) {
        log.info("Search context variable parameters for log record '{}' by name: {}", (Object)logRecordId, (Object)name);
        Object context = repository.getById(logRecordId);
        if (context == null) {
            return Collections.emptyList();
        }
        List contextVariables = context.getContextVariables();
        if (CollectionUtils.isEmpty((Collection)contextVariables)) {
            return Collections.emptyList();
        }
        List<String> foundParameters = contextVariables.stream().filter(contextVariable -> Objects.nonNull(contextVariable.getName()) && StringUtils.containsIgnoreCase((String)contextVariable.getName(), (String)name)).map(ContextVariable::getName).sorted().collect(Collectors.toList());
        log.debug("Found parameters: {}", foundParameters);
        return foundParameters;
    }

    public List<String> searchContextVariableParameters(UUID logRecordId, String name) {
        return this.searchContextVariableParameters(logRecordId, name, this.logRecordContextRepository);
    }

    public List<String> searchStepContextVariableParameters(UUID logRecordId, String name) {
        return this.searchContextVariableParameters(logRecordId, name, this.logRecordContextRepository);
    }

    public LogRecordWithChildrenResponse getLogRecordWithChildrenByTrIdAndStatus(UUID testRunId, TestingStatuses testingStatuses) {
        return this.customLogRecordRepository.getLogRecordParentAndChildrenByTestingStatusAndTestRunId(testRunId, testingStatuses);
    }

    public Long countLrsByTestRunsId(Set<UUID> testRunsId) {
        return this.repository.countAllByTestRunIdIn(testRunsId);
    }

    public List<SubstepScreenshotResponse> getSubstepScreenshots(List<UUID> logRecordIds) {
        ArrayList<SubstepScreenshotResponse> substepScreenshotResponses = new ArrayList<SubstepScreenshotResponse>();
        logRecordIds.forEach(uuid -> {
            SubstepScreenshotResponse response = new SubstepScreenshotResponse();
            response.setId((UUID)uuid);
            this.setScreenshotContentToResponse((UUID)uuid, response);
            substepScreenshotResponses.add(response);
        });
        return substepScreenshotResponses;
    }

    public List<LogRecordWithParentListResponse> findLogRecordsWithParentsByPreviewExists(UUID testRunId) {
        return this.customLogRecordRepository.findLogRecordsWithParentsByPreviewExists(testRunId);
    }

    private void setScreenshotContentToResponse(UUID logRecordId, ScreenshotResponse response) {
        SourceShot screenShot = this.gridFsService.getScreenShot(logRecordId);
        if (screenShot != null && StringUtils.isNotEmpty((String)screenShot.getContent())) {
            String content = screenShot.getContent().replaceAll(BASE_64_PREFIX, "");
            response.setScreenshot(content);
            response.setScreenshotSource(screenShot.getSnapshotSource());
        }
    }

    public List<LogRecord> getAllLogRecordsByTestRunIds(List<UUID> testRunIds) {
        return this.repository.findAllByTestRunIdIn(testRunIds);
    }

    public void updateSsmMetricReportsData(UUID logRecordId, SsmMetricReports data) {
        UUID problemContextReportId;
        UUID microservicesReportId;
        log.info("Updating log record SSM metric reports data for ER with id '{}'", (Object)logRecordId);
        log.info("Updates: {}", (Object)data);
        LogRecord logRecord = (LogRecord)this.get(logRecordId);
        log.debug("Found log record with id '{}'", (Object)logRecord.getUuid());
        SsmMetricReports ssmMetricReports = logRecord.getSsmMetricReports();
        log.debug("SSM metric reports data: {}", (Object)ssmMetricReports);
        if (Objects.isNull(ssmMetricReports)) {
            ssmMetricReports = new SsmMetricReports();
        }
        if (Objects.nonNull(microservicesReportId = data.getMicroservicesReportId())) {
            ssmMetricReports.setMicroservicesReportId(microservicesReportId);
        }
        if (Objects.nonNull(problemContextReportId = data.getProblemContextReportId())) {
            ssmMetricReports.setProblemContextReportId(problemContextReportId);
        }
        logRecord.setSsmMetricReports(ssmMetricReports);
        log.debug("Updated SSM metric reports data: {}", (Object)ssmMetricReports);
        this.save(logRecord);
        log.info("Log record has been successfully updated");
    }

    public Long countAllFailedLrByTestRunIds(Collection<UUID> testRunsIds) {
        return this.repository.countAllByTestRunIdInAndTestingStatus(testRunsIds, TestingStatuses.FAILED);
    }

    public Long countAllPassedLrByTestRunIds(Collection<UUID> testRunsIds) {
        return this.repository.countAllByTestRunIdInAndTestingStatus(testRunsIds, TestingStatuses.PASSED);
    }

    public Stream<LogRecord> getAllFailedLogRecordsByTestRunIdsStream(Collection<UUID> testRunsIds, Collection<UUID> logRecordsIdForExclude) {
        return this.repository.findAllByUuidNotInAndTestRunIdInAndTestingStatus(logRecordsIdForExclude, testRunsIds, TestingStatuses.FAILED);
    }

    public LogRecordService(Mapper<LogRecord, LogRecordShort> logRecordMapper, LogRecordRepository repository, LogRecordContextVariableRepository logRecordContextRepository, LogRecordStepContextVariableRepository logRecordStepContextRepository, LogRecordMessageParametersRepository logRecordMessageParametersRepository, TestRunRepository testRunRepository, GridFsService gridFsService, AkbRecordsRepository akbRecordsRepository, ExecutionRequestRepository executionRequestRepository, ModelMapper modelMapper, CustomLogRecordRepository customLogRecordRepository, IssueRepository issueRepository, CatalogueService catalogueService, LogRecordContextVariableService contextVariableService, BrowserConsoleLogService browserConsoleLogService) {
        this.logRecordMapper = logRecordMapper;
        this.repository = repository;
        this.logRecordContextRepository = logRecordContextRepository;
        this.logRecordStepContextRepository = logRecordStepContextRepository;
        this.logRecordMessageParametersRepository = logRecordMessageParametersRepository;
        this.testRunRepository = testRunRepository;
        this.gridFsService = gridFsService;
        this.akbRecordsRepository = akbRecordsRepository;
        this.executionRequestRepository = executionRequestRepository;
        this.modelMapper = modelMapper;
        this.customLogRecordRepository = customLogRecordRepository;
        this.issueRepository = issueRepository;
        this.catalogueService = catalogueService;
        this.contextVariableService = contextVariableService;
        this.browserConsoleLogService = browserConsoleLogService;
    }
}

