/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ram.models.ManualRootCause;
import org.qubership.atp.ram.models.RootCause;
import org.qubership.atp.ram.repositories.ManualRootCauseRepository;
import org.qubership.atp.ram.services.CrudService;
import org.qubership.atp.ram.services.RootCauseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Service;

@Service
public class ManualRootCauseService
extends CrudService<ManualRootCause> {
    private static final Logger log = LoggerFactory.getLogger(ManualRootCauseService.class);
    private final ManualRootCauseRepository repository;
    private final RootCauseService rootCauseService;

    @Override
    protected MongoRepository<ManualRootCause, UUID> repository() {
        return this.repository;
    }

    public List<ManualRootCause> getManualRootCauseByProjectUuid(UUID projectUuid, boolean withRootCauseName) {
        List<ManualRootCause> allManualRootCauses = this.repository.findAllByProjectId(projectUuid);
        if (withRootCauseName) {
            List<RootCause> allRootCauses = this.rootCauseService.getAllRootCauses();
            return allManualRootCauses.stream().map(akbRecord -> this.replaceRootCauseIdWithName((ManualRootCause)akbRecord, allRootCauses)).collect(Collectors.toList());
        }
        return allManualRootCauses;
    }

    private ManualRootCause replaceRootCauseIdWithName(ManualRootCause manualRootCause, List<RootCause> allRootCauses) {
        for (RootCause cause : allRootCauses) {
            if (!cause.getUuid().equals(manualRootCause.getRootCauseId())) continue;
            manualRootCause.setRootCauseId(cause.getUuid());
            return manualRootCause;
        }
        manualRootCause.setRootCauseId(null);
        return manualRootCause;
    }

    public ManualRootCause findByUuid(UUID uuid) {
        return this.repository.findByUuid(uuid);
    }

    public void deleteByUuid(UUID uuid) {
        this.repository.deleteByUuid(uuid);
    }

    public UUID getProjectIdByManualRootCauseId(UUID uuid) {
        ManualRootCause rootCause = this.repository.findProjectByUuid(uuid);
        return rootCause.getProjectId();
    }

    public ManualRootCauseService(ManualRootCauseRepository repository, RootCauseService rootCauseService) {
        this.repository = repository;
        this.rootCauseService = rootCauseService;
    }
}

