/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.qubership.atp.auth.springbootstarter.utils.ExceptionUtils;
import org.qubership.atp.ram.exceptions.reporttemplates.RamReportTemplateAlreadyExistsException;
import org.qubership.atp.ram.exceptions.reporttemplates.RamReportTemplateWidgetContentNotFoundException;
import org.qubership.atp.ram.models.ReportTemplate;
import org.qubership.atp.ram.models.WidgetType;
import org.qubership.atp.ram.repositories.ReportTemplatesRepository;
import org.qubership.atp.ram.services.CrudService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Service;
import org.springframework.util.FileCopyUtils;

@Service
public class ReportTemplatesService
extends CrudService<ReportTemplate> {
    private static final Logger log = LoggerFactory.getLogger(ReportTemplatesService.class);
    public static final String SYSTEM_DEFAULT_TEMPLATE_UUID = "97b9d3b2-dc83-4a9d-9b75-f8a1307f89f7";
    private final ReportTemplatesRepository repository;

    @Override
    protected MongoRepository<ReportTemplate, UUID> repository() {
        return this.repository;
    }

    public List<ReportTemplate> getTemplatesByProjectId(UUID projectUuid) {
        return this.repository.findAllByProjectId(projectUuid);
    }

    public void deleteByUuid(UUID uuid) {
        this.repository.deleteByUuid(uuid);
    }

    public ReportTemplate getDefaultTemplate() {
        ReportTemplate defaultTemplate = this.repository.findByUuid(UUID.fromString(SYSTEM_DEFAULT_TEMPLATE_UUID));
        defaultTemplate.setUuid(null);
        return defaultTemplate;
    }

    public ReportTemplate getActiveTemplateByProjectId(UUID projectId) {
        List<ReportTemplate> templates = this.repository.findAllByProjectId(projectId);
        return templates.stream().filter(ReportTemplate::isActive).findFirst().orElseGet(this::getDefaultTemplate);
    }

    @Override
    public ReportTemplate save(ReportTemplate reportTemplate) {
        String templateName = reportTemplate.getName();
        UUID projectId = reportTemplate.getProjectId();
        boolean isReportTemplateNameExists = false;
        if (reportTemplate.getUuid() == null) {
            isReportTemplateNameExists = this.repository.existsByNameAndProjectId(templateName, projectId);
        }
        if (isReportTemplateNameExists) {
            log.error("Report template with provided name '{}' already exists in the project '{}'", (Object)templateName, (Object)projectId);
            ExceptionUtils.throwWithLog((Logger)log, (AtpException)new RamReportTemplateAlreadyExistsException(templateName));
        }
        if (reportTemplate.isActive()) {
            this.disableActiveTemplatesForProject(reportTemplate);
        }
        return super.save(reportTemplate);
    }

    public ReportTemplate update(UUID projectId, ReportTemplate reportTemplate) {
        log.info("Update report template for project '{}' with new content '{}'", (Object)projectId, (Object)reportTemplate);
        if (reportTemplate.isActive()) {
            this.disableActiveTemplatesForProject(reportTemplate);
        }
        return super.save(reportTemplate);
    }

    private void disableActiveTemplatesForProject(ReportTemplate reportTemplate) {
        List<ReportTemplate> templates = this.repository.findAllByProjectId(reportTemplate.getProjectId());
        List disabledTemplates = templates.stream().filter(template -> template.isActive() && !template.equals((Object)reportTemplate)).peek(template -> template.setActive(false)).collect(Collectors.toList());
        if (log.isDebugEnabled()) {
            log.debug("Disabling active templates" + StringUtils.join(templates, (String)",") + " for project = " + reportTemplate.getProjectId());
        }
        this.saveAll(disabledTemplates);
    }

    public String getReportTemplateWidgetTemplate(WidgetType widget) throws IOException {
        log.info("Load report template '{}' widget content", (Object)widget);
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader();
        String templateFilePath = widget.getTemplateFilePath();
        Resource resource = resourceLoader.getResource(templateFilePath);
        if (!resource.exists()) {
            ExceptionUtils.throwWithLog((Logger)log, (AtpException)new RamReportTemplateWidgetContentNotFoundException(widget));
        }
        InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
        String content = FileCopyUtils.copyToString((Reader)reader);
        ((Reader)reader).close();
        log.debug("Found template content: {}", (Object)content);
        return content;
    }

    public ReportTemplatesService(ReportTemplatesRepository repository) {
        this.repository = repository;
    }
}

