/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpIllegalNullableArgumentException;
import org.qubership.atp.ram.models.ScriptConsoleLog;
import org.qubership.atp.ram.repositories.ScriptReportRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ScriptReportService {
    private static final Logger log = LoggerFactory.getLogger(ScriptReportService.class);
    private final ScriptReportRepository repository;

    public String getPreScript(UUID logRecordId) {
        if (Objects.isNull(logRecordId)) {
            log.error("Found illegal nullable log record id");
            throw new AtpIllegalNullableArgumentException("log record id", "method parameter");
        }
        return this.repository.findPreScriptByLogRecordId(logRecordId).getPreScript();
    }

    public String getPostScript(UUID logRecordId) {
        if (Objects.isNull(logRecordId)) {
            log.error("Found illegal nullable log record id");
            throw new AtpIllegalNullableArgumentException("log record id", "method parameter");
        }
        return this.repository.findPostScriptByLogRecordId(logRecordId).getPostScript();
    }

    public List<ScriptConsoleLog> getScriptConsoleLogs(UUID logRecordId) {
        if (Objects.isNull(logRecordId)) {
            log.error("Found illegal nullable log record id");
            throw new AtpIllegalNullableArgumentException("log record id", "method parameter");
        }
        return this.repository.findScriptConsoleLogsByLogRecordId(logRecordId).getScriptConsoleLogs();
    }

    public ScriptReportService(ScriptReportRepository repository) {
        this.repository = repository;
    }
}

