/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.dto.response.TestCaseLabelResponse;
import org.qubership.atp.ram.models.TestCase;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.services.CatalogueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TestCaseService {
    private static final Logger log = LoggerFactory.getLogger(TestCaseService.class);
    private final CatalogueService catalogueService;

    public void updateCaseStatuses(List<TestRun> testRuns) {
        try {
            this.catalogueService.updateCaseStatuses(testRuns);
        }
        catch (Exception e) {
            log.error("Unable update statuses of TC-s", (Throwable)e);
        }
    }

    public List<TestCaseLabelResponse> getTestCaseLabelsByIds(List<TestRun> testRuns) {
        return this.catalogueService.getTestCaseLabelsByIds(testRuns);
    }

    public TestCase getTestCaseById(UUID testCaseId) {
        return this.catalogueService.getTestCaseById(testCaseId);
    }

    public TestCaseService(CatalogueService catalogueService) {
        this.catalogueService = catalogueService;
    }
}

