/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.ram.enums.EngineCategory;
import org.qubership.atp.ram.models.ToolConfigInfo;
import org.qubership.atp.ram.repositories.ToolConfigInfoRepository;
import org.qubership.atp.ram.services.CrudService;
import org.qubership.atp.ram.utils.JsonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Service;

@Service
public class ToolConfigInfoService
extends CrudService<ToolConfigInfo> {
    private static final Logger log = LoggerFactory.getLogger(ToolConfigInfoService.class);
    private static final String CONFIG_INFO_ID_KEY = "configInfoId";
    private final ToolConfigInfoRepository repository;

    @Override
    protected MongoRepository<ToolConfigInfo, UUID> repository() {
        return this.repository;
    }

    public ToolConfigInfo getByUuid(UUID uuid) {
        return this.repository.findByUuid(uuid);
    }

    @Override
    public List<ToolConfigInfo> getAll() {
        return this.repository.findAll();
    }

    @Override
    public ToolConfigInfo save(ToolConfigInfo configFiles) {
        return (ToolConfigInfo)this.repository.save(configFiles);
    }

    public Set<UUID> saveConfigs(JsonObject request) {
        HashSet fileIds = new HashSet();
        if (request.has(CONFIG_INFO_ID_KEY)) {
            JsonArray arrayFiles = request.getAsJsonArray(CONFIG_INFO_ID_KEY);
            HashSet<UUID> files = new HashSet<UUID>();
            for (int i = 0; i < arrayFiles.size(); ++i) {
                JsonObject configFile = arrayFiles.get(i).getAsJsonObject();
                ToolConfigInfo file = new ToolConfigInfo();
                file.setName(JsonHelper.getStringValue(configFile, "name"));
                file.setData(JsonHelper.getStringValue(configFile, "data"));
                String categoryString = JsonHelper.getStringValue(configFile, "category");
                EngineCategory category = EngineCategory.fromString((String)categoryString);
                if (category == null) {
                    log.error("Engine Category {} not found.", (Object)categoryString);
                } else {
                    file.setCategory(category);
                }
                files.add(this.save(file).getUuid());
            }
            log.debug("Config files saved successfully. Config files: {}", fileIds);
            return files;
        }
        log.error("The request must contain the parameter: \"configFiles\". Request: {}", (Object)request);
        return Collections.emptySet();
    }

    public ToolConfigInfoService(ToolConfigInfoRepository repository) {
        this.repository = repository;
    }
}

