/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services.sorting;

import java.util.List;
import java.util.stream.Collectors;
import org.qubership.atp.ram.dto.request.SortingParams;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class ExecutionRequestSortingService {
    public Sort buildSort(List<SortingParams> sortingParamsList) {
        if (sortingParamsList != null) {
            List orders = sortingParamsList.stream().map(this::getSortingOrder).collect(Collectors.toList());
            return Sort.by(orders);
        }
        return Sort.unsorted();
    }

    private Sort.Order getSortingOrder(SortingParams sortingParams) {
        SortingParams.Direction sortType = sortingParams.getSortType();
        String columnType = sortingParams.getColumn();
        switch (sortType) {
            case ASC: {
                return Sort.Order.asc((String)columnType);
            }
        }
        return Sort.Order.desc((String)columnType);
    }
}

