/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.utils;

import org.apache.tika.Tika;
import org.qubership.atp.ram.enums.FileContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FileContentTypeDetector {
    private static final Logger log = LoggerFactory.getLogger(FileContentTypeDetector.class);
    private static final String MEDIA_TYPE_TEXT_MATLAB = "text/x-matlab";

    public static FileContentType detect(byte[] fileFromDataset) {
        String fileType;
        Tika defaultTika = new Tika();
        try {
            fileType = defaultTika.detect(fileFromDataset);
        }
        catch (Exception ioEx) {
            log.error("Unable to detect type of file", (Throwable)ioEx);
            fileType = null;
        }
        return fileType != null ? FileContentTypeDetector.getFileContentType(fileType) : null;
    }

    private static FileContentType getFileContentType(String contentType) {
        switch (contentType) {
            case "application/xml": 
            case "text/xml": {
                return FileContentType.XML;
            }
            case "application/json": {
                return FileContentType.JSON;
            }
            case "text/html": {
                return FileContentType.HTML;
            }
            case "text/x-matlab": 
            case "text/plain": {
                return FileContentType.TEXT;
            }
        }
        return FileContentType.BIN;
    }
}

