/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.utils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.models.RamObject;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.services.LogRecordService;
import org.qubership.atp.ram.utils.StepPath;

public class PathsGenerator {
    private List<UUID> pathToStep;
    private LogRecordService logRecordService;

    public PathsGenerator(LogRecordService logRecordService) {
        this.logRecordService = logRecordService;
    }

    public StepPath generatePathToFoundTestRuns(List<TestRun> testRuns) {
        List<UUID> foundTestRunsUuid = testRuns.stream().map(RamObject::getUuid).collect(Collectors.toList());
        StepPath stepPath = new StepPath();
        stepPath.setUuidSteps(foundTestRunsUuid);
        return stepPath;
    }

    public List<StepPath> generatePathToFoundLogRecords(List<LogRecord> logRecords) {
        LinkedList<StepPath> result = new LinkedList<StepPath>();
        logRecords.forEach(logRecord -> {
            this.pathToStep = new LinkedList<UUID>();
            this.pathToStep.add(logRecord.getUuid());
            this.generateRecursivePath((LogRecord)logRecord);
            if (!this.pathToStep.isEmpty()) {
                StepPath stepPath = new StepPath();
                Collections.reverse(this.pathToStep);
                stepPath.setUuidSteps(this.pathToStep);
                result.add(stepPath);
            }
        });
        return result;
    }

    private void generateRecursivePath(LogRecord logRecord) {
        UUID parentUuid = logRecord.getParentRecordId();
        while (Objects.nonNull(parentUuid)) {
            this.pathToStep.add(parentUuid);
            parentUuid = this.logRecordService.findById(parentUuid).getParentRecordId();
        }
        this.pathToStep.add(logRecord.getTestRunId());
    }

    public StepPath generatePathToFoundLogRecord(UUID uuid) {
        this.pathToStep = new LinkedList<UUID>();
        LogRecord logRecord = this.logRecordService.findById(uuid);
        this.generateRecursivePath(logRecord);
        StepPath stepPath = new StepPath();
        Collections.reverse(this.pathToStep);
        stepPath.setUuidSteps(this.pathToStep);
        return stepPath;
    }
}

