/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.Flags;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.exceptions.testruns.RamTestRunIllegalNullableExecutionStatusException;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.models.Scope;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.services.CatalogueService;
import org.qubership.atp.ram.services.TestRunService;
import org.qubership.atp.ram.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RateCalculator {
    private static final Logger log = LoggerFactory.getLogger(RateCalculator.class);
    private final TestRunService testRunService;
    private final CatalogueService catalogueService;

    public void calculateRates(ExecutionRequest executionRequest, List<TestRun> allTestRuns) {
        if (allTestRuns.isEmpty()) {
            log.debug("ER hasn't test runs, uuid = {}", (Object)executionRequest.getUuid());
            return;
        }
        this.calculateTrRates(allTestRuns);
        this.calculateErRates(executionRequest, allTestRuns);
    }

    private void calculateTrRates(List<TestRun> allTestRuns) {
        log.debug("Calculate TR-s rates");
        allTestRuns.forEach(testRun -> {
            try {
                List<LogRecord> logRecords = this.testRunService.getAllTestingStatusLogRecordsByTestRunId(testRun.getUuid());
                int passed = 0;
                int warning = 0;
                int failed = 0;
                int others = 0;
                int logRecordsCount = logRecords.size();
                block8: for (LogRecord logRecord : logRecords) {
                    switch (logRecord.getTestingStatus()) {
                        case PASSED: {
                            ++passed;
                            continue block8;
                        }
                        case WARNING: {
                            ++warning;
                            continue block8;
                        }
                        case FAILED: {
                            ++failed;
                            continue block8;
                        }
                        case SKIPPED: {
                            continue block8;
                        }
                    }
                    ++others;
                    log.debug("Log record {} has other status {}", (Object)logRecord.getUuid(), (Object)logRecord.getTestingStatus());
                }
                int actualRunLogRecords = logRecordsCount - others;
                testRun.setWarningRate((int)(Math.rint((double)warning * 1000.0 / (double)actualRunLogRecords) / 10.0));
                testRun.setFailedRate((int)(Math.rint((double)failed * 1000.0 / (double)actualRunLogRecords) / 10.0));
                testRun.setPassedRate((int)(Math.rint((double)passed * 1000.0 / (double)actualRunLogRecords) / 10.0));
            }
            catch (Exception e) {
                log.error("Error in calculating rates for Test Run {}.", (Object)testRun.getUuid(), (Object)e);
            }
        });
        this.testRunService.saveAll(allTestRuns);
    }

    public boolean isTestRunIgnoredByFlag(TestRun testRun, Set<UUID> flagIds, List<UUID> prerequisitesCases, List<UUID> validationCases) {
        UUID testCaseId = testRun.getTestCaseId();
        if (flagIds == null) {
            return false;
        }
        if (flagIds.contains(Flags.IGNORE_PREREQUISITE_IN_PASS_RATE.getId()) && prerequisitesCases != null && prerequisitesCases.contains(testCaseId)) {
            return true;
        }
        return flagIds.contains(Flags.IGNORE_VALIDATION_IN_PASS_RATE.getId()) && validationCases != null && validationCases.contains(testCaseId);
    }

    public void calculateErRates(ExecutionRequest executionRequest, List<TestRun> allTestRuns) {
        int passed = 0;
        int warning = 0;
        int failed = 0;
        int others = 0;
        int skippedCount = 0;
        int notCounted = 0;
        Scope testScope = this.catalogueService.getTestScope(executionRequest.getTestScopeId());
        Set flagIds = executionRequest.getFlagIds();
        List prerequisitesCases = testScope != null ? testScope.getPrerequisitesCases() : null;
        List validationCases = testScope != null ? testScope.getValidationCases() : null;
        List finishedTestRuns = allTestRuns.stream().filter(testRun -> !ExecutionStatuses.IN_PROGRESS.equals((Object)testRun.getExecutionStatus())).collect(Collectors.toList());
        block6: for (TestRun testRun2 : finishedTestRuns) {
            if (this.isTestRunIgnoredByFlag(testRun2, flagIds, prerequisitesCases, validationCases)) {
                ++notCounted;
                continue;
            }
            switch (testRun2.getTestingStatus()) {
                case PASSED: {
                    ++passed;
                    continue block6;
                }
                case WARNING: {
                    ++warning;
                    continue block6;
                }
                case FAILED: {
                    ++failed;
                    continue block6;
                }
                case SKIPPED: {
                    ++skippedCount;
                    continue block6;
                }
            }
            ++others;
        }
        int trsCount = allTestRuns.size();
        int actualRunTrs = trsCount - skippedCount - notCounted;
        executionRequest.setCountOfTestRuns(actualRunTrs);
        executionRequest.setWarningRate(RateCalculator.calculateRateInt(warning, actualRunTrs));
        executionRequest.setFailedRate(RateCalculator.calculateRateInt(failed, actualRunTrs));
        executionRequest.setPassedRate(RateCalculator.calculateRateInt(passed, actualRunTrs));
        log.debug("Rate for ER {} Passed: {} Warning: {} Failed: {} Other: {}.", new Object[]{executionRequest.getUuid(), passed, warning, failed, others});
    }

    public static float calculateRateFloat(int part, int total) {
        if (total == 0) {
            return total;
        }
        DecimalFormat decimalFormat = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.US));
        decimalFormat.setRoundingMode(RoundingMode.DOWN);
        String value = decimalFormat.format((double)part * 100.0 / (double)total);
        return new BigDecimal(value).setScale(1, RoundingMode.HALF_DOWN).floatValue();
    }

    public static int calculateRateInt(int part, int total) {
        return (int)RateCalculator.calculateRateFloat(part, total);
    }

    public Map<TestingStatuses, TestingStatusesStat> calculateTestRunsTestingStatusStats(ExecutionRequest executionRequest, List<TestRun> testRuns) {
        Scope testScope = this.catalogueService.getTestScope(executionRequest.getTestScopeId());
        Set flagIds = executionRequest.getFlagIds();
        List prerequisitesCases = testScope != null ? testScope.getPrerequisitesCases() : null;
        List validationCases = testScope != null ? testScope.getValidationCases() : null;
        Map<TestingStatuses, TestingStatusesStat> statusMap = Arrays.stream(TestingStatuses.values()).collect(Collectors.toMap(Function.identity(), TestingStatusesStat::new));
        List testRunsWithNullExecutionStatus = testRuns.stream().filter(testRun -> Objects.isNull(testRun.getExecutionStatus())).collect(Collectors.toList());
        if (!testRunsWithNullExecutionStatus.isEmpty()) {
            log.error("Can't calculate ER rates, found test run with null execution status: {}", StreamUtils.extractIds(testRunsWithNullExecutionStatus));
            throw new RamTestRunIllegalNullableExecutionStatusException();
        }
        int notCountedTestRuns = 0;
        for (TestRun testRun2 : testRuns) {
            if (this.isTestRunIgnoredByFlag(testRun2, flagIds, prerequisitesCases, validationCases)) {
                ++notCountedTestRuns;
                continue;
            }
            TestingStatuses testingStatus = testRun2.getTestingStatus();
            TestingStatusesStat stat2 = statusMap.get(testingStatus);
            stat2.incrCount();
        }
        TestingStatusesStat skippedStatusStat = statusMap.get(TestingStatuses.SKIPPED);
        int skippedCount = Objects.isNull(skippedStatusStat) ? 0 : skippedStatusStat.getCount();
        int actualTotalTestRuns = testRuns.size() - skippedCount - notCountedTestRuns;
        statusMap.values().stream().filter(stat -> TestingStatuses.SKIPPED != stat.getStatus()).forEach(stat -> stat.setRate(RateCalculator.calculateRateFloat(stat.getCount(), actualTotalTestRuns)));
        return statusMap;
    }

    public RateCalculator(TestRunService testRunService, CatalogueService catalogueService) {
        this.testRunService = testRunService;
        this.catalogueService = catalogueService;
    }

    public static class TestingStatusesStat {
        private TestingStatuses status;
        private int count;
        private float rate;

        public TestingStatusesStat(TestingStatuses status) {
            this.status = status;
        }

        public void incrCount() {
            this.count = ++this.count;
        }

        public TestingStatuses getStatus() {
            return this.status;
        }

        public int getCount() {
            return this.count;
        }

        public float getRate() {
            return this.rate;
        }

        public void setStatus(TestingStatuses status) {
            this.status = status;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public void setRate(float rate) {
            this.rate = rate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TestingStatusesStat)) {
                return false;
            }
            TestingStatusesStat other = (TestingStatusesStat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCount() != other.getCount()) {
                return false;
            }
            if (Float.compare(this.getRate(), other.getRate()) != 0) {
                return false;
            }
            TestingStatuses this$status = this.getStatus();
            TestingStatuses other$status = other.getStatus();
            return !(this$status == null ? other$status != null : !this$status.equals(other$status));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TestingStatusesStat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCount();
            result = result * 59 + Float.floatToIntBits(this.getRate());
            TestingStatuses $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            return result;
        }

        public String toString() {
            return "RateCalculator.TestingStatusesStat(status=" + this.getStatus() + ", count=" + this.getCount() + ", rate=" + this.getRate() + ")";
        }
    }
}

