/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.utils;

import org.springframework.security.core.context.SecurityContextHolder;

public final class SecurityUtils {
    public static final String ADMIN_ROLE = "ATP_ADMIN";
    private static final String ROLE_PREFIX = "ROLE_";

    public static boolean isCurrentUserAdmin() {
        return SecurityUtils.hasRole(ADMIN_ROLE);
    }

    private static boolean hasRole(String roleName) {
        return SecurityContextHolder.getContext().getAuthentication().getAuthorities().stream().anyMatch(grantedAuthority -> grantedAuthority.getAuthority().equals(ROLE_PREFIX + roleName));
    }

    private SecurityUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

