package org.qubership.atp.orchestrator.clients.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.qubership.atp.orchestrator.clients.dto.EnrichedScopeDto;
import org.qubership.atp.orchestrator.clients.dto.ExecutionRequestInfoDto;
import org.qubership.atp.orchestrator.clients.dto.TestingStrategyDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ExecutionOrderDto
 */

@JsonTypeName("ExecutionOrder")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-27T09:48:28.443530359Z[Etc/UTC]")
public class ExecutionOrderDto {

  @JsonProperty("autoSyncCasesWithJira")
  private Boolean autoSyncCasesWithJira;

  @JsonProperty("autoSyncRunsWithJira")
  private Boolean autoSyncRunsWithJira;

  @JsonProperty("contextVariables")
  @Valid
  private Map<String, Object> contextVariables = null;

  @JsonProperty("dataSetId")
  private UUID dataSetId;

  @JsonProperty("dataSetStorageId")
  private UUID dataSetStorageId;

  @JsonProperty("emailSubject")
  private String emailSubject;

  @JsonProperty("emailTemplateId")
  private UUID emailTemplateId;

  @JsonProperty("environmentId")
  @Valid
  private List<UUID> environmentId = null;

  @JsonProperty("executionRequests")
  @Valid
  private List<ExecutionRequestInfoDto> executionRequests = null;

  @JsonProperty("executor")
  private String executor;

  @JsonProperty("executorId")
  private UUID executorId;

  @JsonProperty("id")
  private UUID id;

  @JsonProperty("labelTemplateId")
  private UUID labelTemplateId;

  @JsonProperty("logCollectorTemplateId")
  private UUID logCollectorTemplateId;

  @JsonProperty("missionControlToolUrl")
  private String missionControlToolUrl;

  @JsonProperty("monitoringToolUrl")
  private String monitoringToolUrl;

  @JsonProperty("name")
  private String name;

  @JsonProperty("projectId")
  private UUID projectId;

  @JsonProperty("projectName")
  private String projectName;

  @JsonProperty("recipients")
  @Valid
  private List<String> recipients = null;

  @JsonProperty("isMandatoryCheck")
  private Boolean isMandatoryCheck;

  @JsonProperty("isSsmCheck")
  private Boolean isSsmCheck;

  @JsonProperty("isIgnoreFailedChecks")
  private Boolean isIgnoreFailedChecks;

  @JsonProperty("scope")
  private EnrichedScopeDto scope;

  @JsonProperty("taToolGroupId")
  @Valid
  private List<UUID> taToolGroupId = null;

  @JsonProperty("testPlanId")
  private UUID testPlanId;

  @JsonProperty("testPlanName")
  private String testPlanName;

  @JsonProperty("testingStrategy")
  private TestingStrategyDto testingStrategy;

  @JsonProperty("threadCount")
  private Integer threadCount;

  @JsonProperty("tshooterUrl")
  private String tshooterUrl;

  @JsonProperty("widgetConfigTemplateId")
  private UUID widgetConfigTemplateId;

  @JsonProperty("virtual")
  private Boolean virtual;

  public ExecutionOrderDto autoSyncCasesWithJira(Boolean autoSyncCasesWithJira) {
    this.autoSyncCasesWithJira = autoSyncCasesWithJira;
    return this;
  }

  /**
   * Get autoSyncCasesWithJira
   * @return autoSyncCasesWithJira
  */
  
  @Schema(name = "autoSyncCasesWithJira", required = false)
  public Boolean getAutoSyncCasesWithJira() {
    return autoSyncCasesWithJira;
  }

  public void setAutoSyncCasesWithJira(Boolean autoSyncCasesWithJira) {
    this.autoSyncCasesWithJira = autoSyncCasesWithJira;
  }

  public ExecutionOrderDto autoSyncRunsWithJira(Boolean autoSyncRunsWithJira) {
    this.autoSyncRunsWithJira = autoSyncRunsWithJira;
    return this;
  }

  /**
   * Get autoSyncRunsWithJira
   * @return autoSyncRunsWithJira
  */
  
  @Schema(name = "autoSyncRunsWithJira", required = false)
  public Boolean getAutoSyncRunsWithJira() {
    return autoSyncRunsWithJira;
  }

  public void setAutoSyncRunsWithJira(Boolean autoSyncRunsWithJira) {
    this.autoSyncRunsWithJira = autoSyncRunsWithJira;
  }

  public ExecutionOrderDto contextVariables(Map<String, Object> contextVariables) {
    this.contextVariables = contextVariables;
    return this;
  }

  public ExecutionOrderDto putContextVariablesItem(String key, Object contextVariablesItem) {
    if (this.contextVariables == null) {
      this.contextVariables = new HashMap<>();
    }
    this.contextVariables.put(key, contextVariablesItem);
    return this;
  }

  /**
   * Get contextVariables
   * @return contextVariables
  */
  
  @Schema(name = "contextVariables", required = false)
  public Map<String, Object> getContextVariables() {
    return contextVariables;
  }

  public void setContextVariables(Map<String, Object> contextVariables) {
    this.contextVariables = contextVariables;
  }

  public ExecutionOrderDto dataSetId(UUID dataSetId) {
    this.dataSetId = dataSetId;
    return this;
  }

  /**
   * Get dataSetId
   * @return dataSetId
  */
  @Valid 
  @Schema(name = "dataSetId", required = false)
  public UUID getDataSetId() {
    return dataSetId;
  }

  public void setDataSetId(UUID dataSetId) {
    this.dataSetId = dataSetId;
  }

  public ExecutionOrderDto dataSetStorageId(UUID dataSetStorageId) {
    this.dataSetStorageId = dataSetStorageId;
    return this;
  }

  /**
   * Get dataSetStorageId
   * @return dataSetStorageId
  */
  @Valid 
  @Schema(name = "dataSetStorageId", required = false)
  public UUID getDataSetStorageId() {
    return dataSetStorageId;
  }

  public void setDataSetStorageId(UUID dataSetStorageId) {
    this.dataSetStorageId = dataSetStorageId;
  }

  public ExecutionOrderDto emailSubject(String emailSubject) {
    this.emailSubject = emailSubject;
    return this;
  }

  /**
   * Get emailSubject
   * @return emailSubject
  */
  
  @Schema(name = "emailSubject", required = false)
  public String getEmailSubject() {
    return emailSubject;
  }

  public void setEmailSubject(String emailSubject) {
    this.emailSubject = emailSubject;
  }

  public ExecutionOrderDto emailTemplateId(UUID emailTemplateId) {
    this.emailTemplateId = emailTemplateId;
    return this;
  }

  /**
   * Get emailTemplateId
   * @return emailTemplateId
  */
  @Valid 
  @Schema(name = "emailTemplateId", required = false)
  public UUID getEmailTemplateId() {
    return emailTemplateId;
  }

  public void setEmailTemplateId(UUID emailTemplateId) {
    this.emailTemplateId = emailTemplateId;
  }

  public ExecutionOrderDto environmentId(List<UUID> environmentId) {
    this.environmentId = environmentId;
    return this;
  }

  public ExecutionOrderDto addEnvironmentIdItem(UUID environmentIdItem) {
    if (this.environmentId == null) {
      this.environmentId = new ArrayList<>();
    }
    this.environmentId.add(environmentIdItem);
    return this;
  }

  /**
   * Get environmentId
   * @return environmentId
  */
  @Valid 
  @Schema(name = "environmentId", required = false)
  public List<UUID> getEnvironmentId() {
    return environmentId;
  }

  public void setEnvironmentId(List<UUID> environmentId) {
    this.environmentId = environmentId;
  }

  public ExecutionOrderDto executionRequests(List<ExecutionRequestInfoDto> executionRequests) {
    this.executionRequests = executionRequests;
    return this;
  }

  public ExecutionOrderDto addExecutionRequestsItem(ExecutionRequestInfoDto executionRequestsItem) {
    if (this.executionRequests == null) {
      this.executionRequests = new ArrayList<>();
    }
    this.executionRequests.add(executionRequestsItem);
    return this;
  }

  /**
   * Get executionRequests
   * @return executionRequests
  */
  @Valid 
  @Schema(name = "executionRequests", required = false)
  public List<ExecutionRequestInfoDto> getExecutionRequests() {
    return executionRequests;
  }

  public void setExecutionRequests(List<ExecutionRequestInfoDto> executionRequests) {
    this.executionRequests = executionRequests;
  }

  public ExecutionOrderDto executor(String executor) {
    this.executor = executor;
    return this;
  }

  /**
   * Get executor
   * @return executor
  */
  
  @Schema(name = "executor", required = false)
  public String getExecutor() {
    return executor;
  }

  public void setExecutor(String executor) {
    this.executor = executor;
  }

  public ExecutionOrderDto executorId(UUID executorId) {
    this.executorId = executorId;
    return this;
  }

  /**
   * Get executorId
   * @return executorId
  */
  @Valid 
  @Schema(name = "executorId", required = false)
  public UUID getExecutorId() {
    return executorId;
  }

  public void setExecutorId(UUID executorId) {
    this.executorId = executorId;
  }

  public ExecutionOrderDto id(UUID id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
  */
  @Valid 
  @Schema(name = "id", required = false)
  public UUID getId() {
    return id;
  }

  public void setId(UUID id) {
    this.id = id;
  }

  public ExecutionOrderDto labelTemplateId(UUID labelTemplateId) {
    this.labelTemplateId = labelTemplateId;
    return this;
  }

  /**
   * Get labelTemplateId
   * @return labelTemplateId
  */
  @Valid 
  @Schema(name = "labelTemplateId", required = false)
  public UUID getLabelTemplateId() {
    return labelTemplateId;
  }

  public void setLabelTemplateId(UUID labelTemplateId) {
    this.labelTemplateId = labelTemplateId;
  }

  public ExecutionOrderDto logCollectorTemplateId(UUID logCollectorTemplateId) {
    this.logCollectorTemplateId = logCollectorTemplateId;
    return this;
  }

  /**
   * Get logCollectorTemplateId
   * @return logCollectorTemplateId
  */
  @Valid 
  @Schema(name = "logCollectorTemplateId", required = false)
  public UUID getLogCollectorTemplateId() {
    return logCollectorTemplateId;
  }

  public void setLogCollectorTemplateId(UUID logCollectorTemplateId) {
    this.logCollectorTemplateId = logCollectorTemplateId;
  }

  public ExecutionOrderDto missionControlToolUrl(String missionControlToolUrl) {
    this.missionControlToolUrl = missionControlToolUrl;
    return this;
  }

  /**
   * Get missionControlToolUrl
   * @return missionControlToolUrl
  */
  
  @Schema(name = "missionControlToolUrl", required = false)
  public String getMissionControlToolUrl() {
    return missionControlToolUrl;
  }

  public void setMissionControlToolUrl(String missionControlToolUrl) {
    this.missionControlToolUrl = missionControlToolUrl;
  }

  public ExecutionOrderDto monitoringToolUrl(String monitoringToolUrl) {
    this.monitoringToolUrl = monitoringToolUrl;
    return this;
  }

  /**
   * Get monitoringToolUrl
   * @return monitoringToolUrl
  */
  
  @Schema(name = "monitoringToolUrl", required = false)
  public String getMonitoringToolUrl() {
    return monitoringToolUrl;
  }

  public void setMonitoringToolUrl(String monitoringToolUrl) {
    this.monitoringToolUrl = monitoringToolUrl;
  }

  public ExecutionOrderDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  @NotNull 
  @Schema(name = "name", required = true)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ExecutionOrderDto projectId(UUID projectId) {
    this.projectId = projectId;
    return this;
  }

  /**
   * Get projectId
   * @return projectId
  */
  @NotNull @Valid 
  @Schema(name = "projectId", required = true)
  public UUID getProjectId() {
    return projectId;
  }

  public void setProjectId(UUID projectId) {
    this.projectId = projectId;
  }

  public ExecutionOrderDto projectName(String projectName) {
    this.projectName = projectName;
    return this;
  }

  /**
   * Get projectName
   * @return projectName
  */
  @NotNull 
  @Schema(name = "projectName", required = true)
  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public ExecutionOrderDto recipients(List<String> recipients) {
    this.recipients = recipients;
    return this;
  }

  public ExecutionOrderDto addRecipientsItem(String recipientsItem) {
    if (this.recipients == null) {
      this.recipients = new ArrayList<>();
    }
    this.recipients.add(recipientsItem);
    return this;
  }

  /**
   * Get recipients
   * @return recipients
  */
  
  @Schema(name = "recipients", required = false)
  public List<String> getRecipients() {
    return recipients;
  }

  public void setRecipients(List<String> recipients) {
    this.recipients = recipients;
  }

  public ExecutionOrderDto isMandatoryCheck(Boolean isMandatoryCheck) {
    this.isMandatoryCheck = isMandatoryCheck;
    return this;
  }

  /**
   * Get isMandatoryCheck
   * @return isMandatoryCheck
  */
  
  @Schema(name = "isMandatoryCheck", required = false)
  public Boolean getIsMandatoryCheck() {
    return isMandatoryCheck;
  }

  public void setIsMandatoryCheck(Boolean isMandatoryCheck) {
    this.isMandatoryCheck = isMandatoryCheck;
  }

  public ExecutionOrderDto isSsmCheck(Boolean isSsmCheck) {
    this.isSsmCheck = isSsmCheck;
    return this;
  }

  /**
   * Get isSsmCheck
   * @return isSsmCheck
  */
  
  @Schema(name = "isSsmCheck", required = false)
  public Boolean getIsSsmCheck() {
    return isSsmCheck;
  }

  public void setIsSsmCheck(Boolean isSsmCheck) {
    this.isSsmCheck = isSsmCheck;
  }

  public ExecutionOrderDto isIgnoreFailedChecks(Boolean isIgnoreFailedChecks) {
    this.isIgnoreFailedChecks = isIgnoreFailedChecks;
    return this;
  }

  /**
   * Get isIgnoreFailedChecks
   * @return isIgnoreFailedChecks
  */
  
  @Schema(name = "isIgnoreFailedChecks", required = false)
  public Boolean getIsIgnoreFailedChecks() {
    return isIgnoreFailedChecks;
  }

  public void setIsIgnoreFailedChecks(Boolean isIgnoreFailedChecks) {
    this.isIgnoreFailedChecks = isIgnoreFailedChecks;
  }

  public ExecutionOrderDto scope(EnrichedScopeDto scope) {
    this.scope = scope;
    return this;
  }

  /**
   * Get scope
   * @return scope
  */
  @NotNull @Valid 
  @Schema(name = "scope", required = true)
  public EnrichedScopeDto getScope() {
    return scope;
  }

  public void setScope(EnrichedScopeDto scope) {
    this.scope = scope;
  }

  public ExecutionOrderDto taToolGroupId(List<UUID> taToolGroupId) {
    this.taToolGroupId = taToolGroupId;
    return this;
  }

  public ExecutionOrderDto addTaToolGroupIdItem(UUID taToolGroupIdItem) {
    if (this.taToolGroupId == null) {
      this.taToolGroupId = new ArrayList<>();
    }
    this.taToolGroupId.add(taToolGroupIdItem);
    return this;
  }

  /**
   * Get taToolGroupId
   * @return taToolGroupId
  */
  @Valid 
  @Schema(name = "taToolGroupId", required = false)
  public List<UUID> getTaToolGroupId() {
    return taToolGroupId;
  }

  public void setTaToolGroupId(List<UUID> taToolGroupId) {
    this.taToolGroupId = taToolGroupId;
  }

  public ExecutionOrderDto testPlanId(UUID testPlanId) {
    this.testPlanId = testPlanId;
    return this;
  }

  /**
   * Get testPlanId
   * @return testPlanId
  */
  @NotNull @Valid 
  @Schema(name = "testPlanId", required = true)
  public UUID getTestPlanId() {
    return testPlanId;
  }

  public void setTestPlanId(UUID testPlanId) {
    this.testPlanId = testPlanId;
  }

  public ExecutionOrderDto testPlanName(String testPlanName) {
    this.testPlanName = testPlanName;
    return this;
  }

  /**
   * Get testPlanName
   * @return testPlanName
  */
  @NotNull 
  @Schema(name = "testPlanName", required = true)
  public String getTestPlanName() {
    return testPlanName;
  }

  public void setTestPlanName(String testPlanName) {
    this.testPlanName = testPlanName;
  }

  public ExecutionOrderDto testingStrategy(TestingStrategyDto testingStrategy) {
    this.testingStrategy = testingStrategy;
    return this;
  }

  /**
   * Get testingStrategy
   * @return testingStrategy
  */
  @Valid 
  @Schema(name = "testingStrategy", required = false)
  public TestingStrategyDto getTestingStrategy() {
    return testingStrategy;
  }

  public void setTestingStrategy(TestingStrategyDto testingStrategy) {
    this.testingStrategy = testingStrategy;
  }

  public ExecutionOrderDto threadCount(Integer threadCount) {
    this.threadCount = threadCount;
    return this;
  }

  /**
   * Get threadCount
   * @return threadCount
  */
  
  @Schema(name = "threadCount", required = false)
  public Integer getThreadCount() {
    return threadCount;
  }

  public void setThreadCount(Integer threadCount) {
    this.threadCount = threadCount;
  }

  public ExecutionOrderDto tshooterUrl(String tshooterUrl) {
    this.tshooterUrl = tshooterUrl;
    return this;
  }

  /**
   * Get tshooterUrl
   * @return tshooterUrl
  */
  
  @Schema(name = "tshooterUrl", required = false)
  public String getTshooterUrl() {
    return tshooterUrl;
  }

  public void setTshooterUrl(String tshooterUrl) {
    this.tshooterUrl = tshooterUrl;
  }

  public ExecutionOrderDto widgetConfigTemplateId(UUID widgetConfigTemplateId) {
    this.widgetConfigTemplateId = widgetConfigTemplateId;
    return this;
  }

  /**
   * Get widgetConfigTemplateId
   * @return widgetConfigTemplateId
  */
  @Valid 
  @Schema(name = "widgetConfigTemplateId", required = false)
  public UUID getWidgetConfigTemplateId() {
    return widgetConfigTemplateId;
  }

  public void setWidgetConfigTemplateId(UUID widgetConfigTemplateId) {
    this.widgetConfigTemplateId = widgetConfigTemplateId;
  }

  public ExecutionOrderDto virtual(Boolean virtual) {
    this.virtual = virtual;
    return this;
  }

  /**
   * Get virtual
   * @return virtual
  */
  
  @Schema(name = "virtual", required = false)
  public Boolean getVirtual() {
    return virtual;
  }

  public void setVirtual(Boolean virtual) {
    this.virtual = virtual;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExecutionOrderDto executionOrder = (ExecutionOrderDto) o;
    return Objects.equals(this.autoSyncCasesWithJira, executionOrder.autoSyncCasesWithJira) &&
        Objects.equals(this.autoSyncRunsWithJira, executionOrder.autoSyncRunsWithJira) &&
        Objects.equals(this.contextVariables, executionOrder.contextVariables) &&
        Objects.equals(this.dataSetId, executionOrder.dataSetId) &&
        Objects.equals(this.dataSetStorageId, executionOrder.dataSetStorageId) &&
        Objects.equals(this.emailSubject, executionOrder.emailSubject) &&
        Objects.equals(this.emailTemplateId, executionOrder.emailTemplateId) &&
        Objects.equals(this.environmentId, executionOrder.environmentId) &&
        Objects.equals(this.executionRequests, executionOrder.executionRequests) &&
        Objects.equals(this.executor, executionOrder.executor) &&
        Objects.equals(this.executorId, executionOrder.executorId) &&
        Objects.equals(this.id, executionOrder.id) &&
        Objects.equals(this.labelTemplateId, executionOrder.labelTemplateId) &&
        Objects.equals(this.logCollectorTemplateId, executionOrder.logCollectorTemplateId) &&
        Objects.equals(this.missionControlToolUrl, executionOrder.missionControlToolUrl) &&
        Objects.equals(this.monitoringToolUrl, executionOrder.monitoringToolUrl) &&
        Objects.equals(this.name, executionOrder.name) &&
        Objects.equals(this.projectId, executionOrder.projectId) &&
        Objects.equals(this.projectName, executionOrder.projectName) &&
        Objects.equals(this.recipients, executionOrder.recipients) &&
        Objects.equals(this.isMandatoryCheck, executionOrder.isMandatoryCheck) &&
        Objects.equals(this.isSsmCheck, executionOrder.isSsmCheck) &&
        Objects.equals(this.isIgnoreFailedChecks, executionOrder.isIgnoreFailedChecks) &&
        Objects.equals(this.scope, executionOrder.scope) &&
        Objects.equals(this.taToolGroupId, executionOrder.taToolGroupId) &&
        Objects.equals(this.testPlanId, executionOrder.testPlanId) &&
        Objects.equals(this.testPlanName, executionOrder.testPlanName) &&
        Objects.equals(this.testingStrategy, executionOrder.testingStrategy) &&
        Objects.equals(this.threadCount, executionOrder.threadCount) &&
        Objects.equals(this.tshooterUrl, executionOrder.tshooterUrl) &&
        Objects.equals(this.widgetConfigTemplateId, executionOrder.widgetConfigTemplateId) &&
        Objects.equals(this.virtual, executionOrder.virtual);
  }

  @Override
  public int hashCode() {
    return Objects.hash(autoSyncCasesWithJira, autoSyncRunsWithJira, contextVariables, dataSetId, dataSetStorageId, emailSubject, emailTemplateId, environmentId, executionRequests, executor, executorId, id, labelTemplateId, logCollectorTemplateId, missionControlToolUrl, monitoringToolUrl, name, projectId, projectName, recipients, isMandatoryCheck, isSsmCheck, isIgnoreFailedChecks, scope, taToolGroupId, testPlanId, testPlanName, testingStrategy, threadCount, tshooterUrl, widgetConfigTemplateId, virtual);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExecutionOrderDto {\n");
    sb.append("    autoSyncCasesWithJira: ").append(toIndentedString(autoSyncCasesWithJira)).append("\n");
    sb.append("    autoSyncRunsWithJira: ").append(toIndentedString(autoSyncRunsWithJira)).append("\n");
    sb.append("    contextVariables: ").append(toIndentedString(contextVariables)).append("\n");
    sb.append("    dataSetId: ").append(toIndentedString(dataSetId)).append("\n");
    sb.append("    dataSetStorageId: ").append(toIndentedString(dataSetStorageId)).append("\n");
    sb.append("    emailSubject: ").append(toIndentedString(emailSubject)).append("\n");
    sb.append("    emailTemplateId: ").append(toIndentedString(emailTemplateId)).append("\n");
    sb.append("    environmentId: ").append(toIndentedString(environmentId)).append("\n");
    sb.append("    executionRequests: ").append(toIndentedString(executionRequests)).append("\n");
    sb.append("    executor: ").append(toIndentedString(executor)).append("\n");
    sb.append("    executorId: ").append(toIndentedString(executorId)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    labelTemplateId: ").append(toIndentedString(labelTemplateId)).append("\n");
    sb.append("    logCollectorTemplateId: ").append(toIndentedString(logCollectorTemplateId)).append("\n");
    sb.append("    missionControlToolUrl: ").append(toIndentedString(missionControlToolUrl)).append("\n");
    sb.append("    monitoringToolUrl: ").append(toIndentedString(monitoringToolUrl)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    projectId: ").append(toIndentedString(projectId)).append("\n");
    sb.append("    projectName: ").append(toIndentedString(projectName)).append("\n");
    sb.append("    recipients: ").append(toIndentedString(recipients)).append("\n");
    sb.append("    isMandatoryCheck: ").append(toIndentedString(isMandatoryCheck)).append("\n");
    sb.append("    isSsmCheck: ").append(toIndentedString(isSsmCheck)).append("\n");
    sb.append("    isIgnoreFailedChecks: ").append(toIndentedString(isIgnoreFailedChecks)).append("\n");
    sb.append("    scope: ").append(toIndentedString(scope)).append("\n");
    sb.append("    taToolGroupId: ").append(toIndentedString(taToolGroupId)).append("\n");
    sb.append("    testPlanId: ").append(toIndentedString(testPlanId)).append("\n");
    sb.append("    testPlanName: ").append(toIndentedString(testPlanName)).append("\n");
    sb.append("    testingStrategy: ").append(toIndentedString(testingStrategy)).append("\n");
    sb.append("    threadCount: ").append(toIndentedString(threadCount)).append("\n");
    sb.append("    tshooterUrl: ").append(toIndentedString(tshooterUrl)).append("\n");
    sb.append("    widgetConfigTemplateId: ").append(toIndentedString(widgetConfigTemplateId)).append("\n");
    sb.append("    virtual: ").append(toIndentedString(virtual)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

