package org.qubership.atp.orchestrator.clients.dto;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestCaseContextDto
 */

@JsonTypeName("TestCaseContext")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-27T09:48:28.443530359Z[Etc/UTC]")
public class TestCaseContextDto {

  @JsonProperty("datasetListId")
  private UUID datasetListId;

  @JsonProperty("fullContext")
  @Valid
  private Map<String, Object> fullContext = null;

  @JsonProperty("iterationContext")
  @Valid
  private List<Map<String, Object>> iterationContext = null;

  public TestCaseContextDto datasetListId(UUID datasetListId) {
    this.datasetListId = datasetListId;
    return this;
  }

  /**
   * Get datasetListId
   * @return datasetListId
  */
  @Valid 
  @Schema(name = "datasetListId", required = false)
  public UUID getDatasetListId() {
    return datasetListId;
  }

  public void setDatasetListId(UUID datasetListId) {
    this.datasetListId = datasetListId;
  }

  public TestCaseContextDto fullContext(Map<String, Object> fullContext) {
    this.fullContext = fullContext;
    return this;
  }

  public TestCaseContextDto putFullContextItem(String key, Object fullContextItem) {
    if (this.fullContext == null) {
      this.fullContext = new HashMap<>();
    }
    this.fullContext.put(key, fullContextItem);
    return this;
  }

  /**
   * Get fullContext
   * @return fullContext
  */
  
  @Schema(name = "fullContext", required = false)
  public Map<String, Object> getFullContext() {
    return fullContext;
  }

  public void setFullContext(Map<String, Object> fullContext) {
    this.fullContext = fullContext;
  }

  public TestCaseContextDto iterationContext(List<Map<String, Object>> iterationContext) {
    this.iterationContext = iterationContext;
    return this;
  }

  public TestCaseContextDto addIterationContextItem(Map<String, Object> iterationContextItem) {
    if (this.iterationContext == null) {
      this.iterationContext = new ArrayList<>();
    }
    this.iterationContext.add(iterationContextItem);
    return this;
  }

  /**
   * Get iterationContext
   * @return iterationContext
  */
  @Valid 
  @Schema(name = "iterationContext", required = false)
  public List<Map<String, Object>> getIterationContext() {
    return iterationContext;
  }

  public void setIterationContext(List<Map<String, Object>> iterationContext) {
    this.iterationContext = iterationContext;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestCaseContextDto testCaseContext = (TestCaseContextDto) o;
    return Objects.equals(this.datasetListId, testCaseContext.datasetListId) &&
        Objects.equals(this.fullContext, testCaseContext.fullContext) &&
        Objects.equals(this.iterationContext, testCaseContext.iterationContext);
  }

  @Override
  public int hashCode() {
    return Objects.hash(datasetListId, fullContext, iterationContext);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestCaseContextDto {\n");
    sb.append("    datasetListId: ").append(toIndentedString(datasetListId)).append("\n");
    sb.append("    fullContext: ").append(toIndentedString(fullContext)).append("\n");
    sb.append("    iterationContext: ").append(toIndentedString(iterationContext)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

