/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.2.1).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package org.qubership.atp.ram.clients.api;

import org.qubership.atp.ram.clients.api.dto.catalogue.LabelDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.LabelFilteringRequestBodyDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.LabelUsageResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.LabelWithRefsResponseDto;
import java.util.Set;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseShortResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanAndCaseIdsRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanIdRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanShortResponseDto;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.multipart.MultipartFile;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-27T09:48:27.784453653Z[Etc/UTC]")
@Validated
@Tag(name = "LabelController", description = "Label Controller")
public interface LabelControllerApi {

    /**
     * POST /catalog/api/v1/labels : create
     *
     * @param labelDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "create",
        summary = "create",
        tags = { "label-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = LabelDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/labels",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<LabelDto> create(
        @Parameter(name = "LabelDto", description = "") @Valid @RequestBody(required = false) LabelDto labelDto
    );


    /**
     * DELETE /catalog/api/v1/labels/{uuid} : delete
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or No Content (status code 204)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     */
    @Operation(
        operationId = "delete",
        summary = "delete",
        tags = { "label-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "204", description = "No Content"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/catalog/api/v1/labels/{uuid}"
    )
    ResponseEntity<Void> delete(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * POST /catalog/api/v1/labels/{uuid}/findTestCaseUsages : findTestCaseUsages
     *
     * @param uuid uuid (required)
     * @param testPlanIdRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "findTestCaseUsages",
        summary = "findTestCaseUsages",
        tags = { "label-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestCaseShortResponseDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/labels/{uuid}/findTestCaseUsages",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<TestCaseShortResponseDto>> findTestCaseUsages(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid,
        @Parameter(name = "TestPlanIdRequestDto", description = "") @Valid @RequestBody(required = false) TestPlanIdRequestDto testPlanIdRequestDto
    );


    /**
     * POST /catalog/api/v1/labels/{uuid}/findTestPlanUsages : findTestPlanUsages
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "findTestPlanUsages",
        summary = "findTestPlanUsages",
        tags = { "label-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = TestPlanShortResponseDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/labels/{uuid}/findTestPlanUsages",
        produces = { "application/json" }
    )
    ResponseEntity<List<TestPlanShortResponseDto>> findTestPlanUsages(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * POST /catalog/api/v1/labels/{uuid}/findUsageCounts : findUsageCounts
     *
     * @param uuid uuid (required)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "findUsageCounts",
        summary = "findUsageCounts",
        tags = { "label-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = LabelUsageResponseDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/labels/{uuid}/findUsageCounts",
        produces = { "application/json" }
    )
    ResponseEntity<List<LabelUsageResponseDto>> findUsageCounts(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid
    );


    /**
     * GET /catalog/api/v1/labels : getAll
     *
     * @param projectId projectId (required)
     * @param testPlanId testPlanId (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getAll",
        summary = "getAll",
        tags = { "label-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = LabelDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/labels",
        produces = { "application/json" }
    )
    ResponseEntity<List<LabelDto>> getAll(
        @NotNull @Parameter(name = "projectId", description = "projectId", required = true) @Valid @RequestParam(value = "projectId", required = true) UUID projectId,
        @Parameter(name = "testPlanId", description = "testPlanId") @Valid @RequestParam(value = "testPlanId", required = false) UUID testPlanId
    );


    /**
     * GET /catalog/api/v1/labels/search : getLabelsByIds
     *
     * @param labelIds labelIds (required)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "getLabelsByIds",
        summary = "getLabelsByIds",
        tags = { "label-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = LabelDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/catalog/api/v1/labels/search",
        produces = { "application/json" }
    )
    ResponseEntity<List<LabelDto>> getLabelsByIds(
        @NotNull @Parameter(name = "labelIds", description = "labelIds", required = true) @Valid @RequestParam(value = "labelIds", required = true) Set<UUID> labelIds
    );


    /**
     * POST /catalog/api/v1/labels/search : search
     *
     * @param projectId projectId (required)
     * @param refs refs (optional)
     * @param page page number (optional)
     * @param size size number (optional)
     * @param labelFilteringRequestBodyDto  (optional)
     * @return OK (status code 200)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "search",
        summary = "search",
        tags = { "label-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = LabelWithRefsResponseDto.class))
            }),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/labels/search",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<List<LabelWithRefsResponseDto>> search(
        @NotNull @Parameter(name = "projectId", description = "projectId", required = true) @Valid @RequestParam(value = "projectId", required = true) UUID projectId,
        @Parameter(name = "refs", description = "refs") @Valid @RequestParam(value = "refs", required = false) List<String> refs,
        @Parameter(name = "page", description = "page number") @Valid @RequestParam(value = "page", required = false) Integer page,
        @Parameter(name = "size", description = "size number") @Valid @RequestParam(value = "size", required = false) Integer size,
        @Parameter(name = "LabelFilteringRequestBodyDto", description = "") @Valid @RequestBody(required = false) LabelFilteringRequestBodyDto labelFilteringRequestBodyDto
    );


    /**
     * POST /catalog/api/v1/labels/{uuid}/unassign : unassign
     *
     * @param uuid uuid (required)
     * @param testPlanAndCaseIdsRequestDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "unassign",
        summary = "unassign",
        tags = { "label-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK"),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/catalog/api/v1/labels/{uuid}/unassign",
        consumes = { "application/json" }
    )
    ResponseEntity<Void> unassign(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid,
        @Parameter(name = "TestPlanAndCaseIdsRequestDto", description = "") @Valid @RequestBody(required = false) TestPlanAndCaseIdsRequestDto testPlanAndCaseIdsRequestDto
    );


    /**
     * PUT /catalog/api/v1/labels/{uuid} : update
     *
     * @param uuid uuid (required)
     * @param labelDto  (optional)
     * @return OK (status code 200)
     *         or Created (status code 201)
     *         or Unauthorized (status code 401)
     *         or Forbidden (status code 403)
     *         or Not Found (status code 404)
     */
    @Operation(
        operationId = "update",
        summary = "update",
        tags = { "label-controller" },
        responses = {
            @ApiResponse(responseCode = "200", description = "OK", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = LabelDto.class))
            }),
            @ApiResponse(responseCode = "201", description = "Created"),
            @ApiResponse(responseCode = "401", description = "Unauthorized"),
            @ApiResponse(responseCode = "403", description = "Forbidden"),
            @ApiResponse(responseCode = "404", description = "Not Found")
        }
    )
    @RequestMapping(
        method = RequestMethod.PUT,
        value = "/catalog/api/v1/labels/{uuid}",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    ResponseEntity<LabelDto> update(
        @Parameter(name = "uuid", description = "uuid", required = true) @PathVariable("uuid") UUID uuid,
        @Parameter(name = "LabelDto", description = "") @Valid @RequestBody(required = false) LabelDto labelDto
    );

}
