package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraComponentDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * BugTrackingSystemSynchronizationDtoDto
 */

@JsonTypeName("BugTrackingSystemSynchronizationDto")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-27T09:48:26.621823710Z[Etc/UTC]")
public class BugTrackingSystemSynchronizationDtoDto {

  @JsonProperty("authorizationKey")
  private String authorizationKey;

  @JsonProperty("components")
  @Valid
  private List<JiraComponentDto> components = null;

  /**
   * Gets or Sets defaultTestCaseMapping
   */
  public enum DefaultTestCaseMappingEnum {
    E2E("E2E"),
    
    TEST_CASE("TEST_CASE");

    private String value;

    DefaultTestCaseMappingEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DefaultTestCaseMappingEnum fromValue(String value) {
      for (DefaultTestCaseMappingEnum b : DefaultTestCaseMappingEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("defaultTestCaseMapping")
  private DefaultTestCaseMappingEnum defaultTestCaseMapping;

  @JsonProperty("projectKey")
  private String projectKey;

  @JsonProperty("projectName")
  private String projectName;

  /**
   * Gets or Sets synchronizationType
   */
  public enum SynchronizationTypeEnum {
    AUTOMATIC("AUTOMATIC"),
    
    MANUAL("MANUAL");

    private String value;

    SynchronizationTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SynchronizationTypeEnum fromValue(String value) {
      for (SynchronizationTypeEnum b : SynchronizationTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("synchronizationType")
  private SynchronizationTypeEnum synchronizationType;

  /**
   * Gets or Sets systemType
   */
  public enum SystemTypeEnum {
    JIRA("JIRA");

    private String value;

    SystemTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static SystemTypeEnum fromValue(String value) {
      for (SystemTypeEnum b : SystemTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("systemType")
  private SystemTypeEnum systemType;

  @JsonProperty("systemUrl")
  private String systemUrl;

  public BugTrackingSystemSynchronizationDtoDto authorizationKey(String authorizationKey) {
    this.authorizationKey = authorizationKey;
    return this;
  }

  /**
   * Get authorizationKey
   * @return authorizationKey
  */
  
  @Schema(name = "authorizationKey", required = false)
  public String getAuthorizationKey() {
    return authorizationKey;
  }

  public void setAuthorizationKey(String authorizationKey) {
    this.authorizationKey = authorizationKey;
  }

  public BugTrackingSystemSynchronizationDtoDto components(List<JiraComponentDto> components) {
    this.components = components;
    return this;
  }

  public BugTrackingSystemSynchronizationDtoDto addComponentsItem(JiraComponentDto componentsItem) {
    if (this.components == null) {
      this.components = new ArrayList<>();
    }
    this.components.add(componentsItem);
    return this;
  }

  /**
   * Get components
   * @return components
  */
  @Valid 
  @Schema(name = "components", required = false)
  public List<JiraComponentDto> getComponents() {
    return components;
  }

  public void setComponents(List<JiraComponentDto> components) {
    this.components = components;
  }

  public BugTrackingSystemSynchronizationDtoDto defaultTestCaseMapping(DefaultTestCaseMappingEnum defaultTestCaseMapping) {
    this.defaultTestCaseMapping = defaultTestCaseMapping;
    return this;
  }

  /**
   * Get defaultTestCaseMapping
   * @return defaultTestCaseMapping
  */
  
  @Schema(name = "defaultTestCaseMapping", required = false)
  public DefaultTestCaseMappingEnum getDefaultTestCaseMapping() {
    return defaultTestCaseMapping;
  }

  public void setDefaultTestCaseMapping(DefaultTestCaseMappingEnum defaultTestCaseMapping) {
    this.defaultTestCaseMapping = defaultTestCaseMapping;
  }

  public BugTrackingSystemSynchronizationDtoDto projectKey(String projectKey) {
    this.projectKey = projectKey;
    return this;
  }

  /**
   * Get projectKey
   * @return projectKey
  */
  
  @Schema(name = "projectKey", required = false)
  public String getProjectKey() {
    return projectKey;
  }

  public void setProjectKey(String projectKey) {
    this.projectKey = projectKey;
  }

  public BugTrackingSystemSynchronizationDtoDto projectName(String projectName) {
    this.projectName = projectName;
    return this;
  }

  /**
   * Get projectName
   * @return projectName
  */
  
  @Schema(name = "projectName", required = false)
  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public BugTrackingSystemSynchronizationDtoDto synchronizationType(SynchronizationTypeEnum synchronizationType) {
    this.synchronizationType = synchronizationType;
    return this;
  }

  /**
   * Get synchronizationType
   * @return synchronizationType
  */
  
  @Schema(name = "synchronizationType", required = false)
  public SynchronizationTypeEnum getSynchronizationType() {
    return synchronizationType;
  }

  public void setSynchronizationType(SynchronizationTypeEnum synchronizationType) {
    this.synchronizationType = synchronizationType;
  }

  public BugTrackingSystemSynchronizationDtoDto systemType(SystemTypeEnum systemType) {
    this.systemType = systemType;
    return this;
  }

  /**
   * Get systemType
   * @return systemType
  */
  
  @Schema(name = "systemType", required = false)
  public SystemTypeEnum getSystemType() {
    return systemType;
  }

  public void setSystemType(SystemTypeEnum systemType) {
    this.systemType = systemType;
  }

  public BugTrackingSystemSynchronizationDtoDto systemUrl(String systemUrl) {
    this.systemUrl = systemUrl;
    return this;
  }

  /**
   * Get systemUrl
   * @return systemUrl
  */
  
  @Schema(name = "systemUrl", required = false)
  public String getSystemUrl() {
    return systemUrl;
  }

  public void setSystemUrl(String systemUrl) {
    this.systemUrl = systemUrl;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BugTrackingSystemSynchronizationDtoDto bugTrackingSystemSynchronizationDto = (BugTrackingSystemSynchronizationDtoDto) o;
    return Objects.equals(this.authorizationKey, bugTrackingSystemSynchronizationDto.authorizationKey) &&
        Objects.equals(this.components, bugTrackingSystemSynchronizationDto.components) &&
        Objects.equals(this.defaultTestCaseMapping, bugTrackingSystemSynchronizationDto.defaultTestCaseMapping) &&
        Objects.equals(this.projectKey, bugTrackingSystemSynchronizationDto.projectKey) &&
        Objects.equals(this.projectName, bugTrackingSystemSynchronizationDto.projectName) &&
        Objects.equals(this.synchronizationType, bugTrackingSystemSynchronizationDto.synchronizationType) &&
        Objects.equals(this.systemType, bugTrackingSystemSynchronizationDto.systemType) &&
        Objects.equals(this.systemUrl, bugTrackingSystemSynchronizationDto.systemUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authorizationKey, components, defaultTestCaseMapping, projectKey, projectName, synchronizationType, systemType, systemUrl);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BugTrackingSystemSynchronizationDtoDto {\n");
    sb.append("    authorizationKey: ").append(toIndentedString(authorizationKey)).append("\n");
    sb.append("    components: ").append(toIndentedString(components)).append("\n");
    sb.append("    defaultTestCaseMapping: ").append(toIndentedString(defaultTestCaseMapping)).append("\n");
    sb.append("    projectKey: ").append(toIndentedString(projectKey)).append("\n");
    sb.append("    projectName: ").append(toIndentedString(projectName)).append("\n");
    sb.append("    synchronizationType: ").append(toIndentedString(synchronizationType)).append("\n");
    sb.append("    systemType: ").append(toIndentedString(systemType)).append("\n");
    sb.append("    systemUrl: ").append(toIndentedString(systemUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

