package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompoundCompareDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * CompareTestPlanQaDslResponseDto
 */

@JsonTypeName("CompareTestPlanQaDslResponse")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-27T09:48:26.621823710Z[Etc/UTC]")
public class CompareTestPlanQaDslResponseDto {

  @JsonProperty("leftTestPlanId")
  private UUID leftTestPlanId;

  @JsonProperty("leftTestPlanName")
  private String leftTestPlanName;

  @JsonProperty("leftQaDslName")
  private String leftQaDslName;

  @JsonProperty("leftQaDslId")
  private UUID leftQaDslId;

  @JsonProperty("rightTestPlanId")
  private UUID rightTestPlanId;

  @JsonProperty("rightTestPlanName")
  private String rightTestPlanName;

  @JsonProperty("rightQaDslName")
  private String rightQaDslName;

  @JsonProperty("rightQaDslId")
  private UUID rightQaDslId;

  @JsonProperty("compounds")
  @Valid
  private List<CompoundCompareDto> compounds = null;

  @JsonProperty("total")
  private BigDecimal total;

  public CompareTestPlanQaDslResponseDto leftTestPlanId(UUID leftTestPlanId) {
    this.leftTestPlanId = leftTestPlanId;
    return this;
  }

  /**
   * Get leftTestPlanId
   * @return leftTestPlanId
  */
  @Valid 
  @Schema(name = "leftTestPlanId", required = false)
  public UUID getLeftTestPlanId() {
    return leftTestPlanId;
  }

  public void setLeftTestPlanId(UUID leftTestPlanId) {
    this.leftTestPlanId = leftTestPlanId;
  }

  public CompareTestPlanQaDslResponseDto leftTestPlanName(String leftTestPlanName) {
    this.leftTestPlanName = leftTestPlanName;
    return this;
  }

  /**
   * Get leftTestPlanName
   * @return leftTestPlanName
  */
  
  @Schema(name = "leftTestPlanName", required = false)
  public String getLeftTestPlanName() {
    return leftTestPlanName;
  }

  public void setLeftTestPlanName(String leftTestPlanName) {
    this.leftTestPlanName = leftTestPlanName;
  }

  public CompareTestPlanQaDslResponseDto leftQaDslName(String leftQaDslName) {
    this.leftQaDslName = leftQaDslName;
    return this;
  }

  /**
   * Get leftQaDslName
   * @return leftQaDslName
  */
  
  @Schema(name = "leftQaDslName", required = false)
  public String getLeftQaDslName() {
    return leftQaDslName;
  }

  public void setLeftQaDslName(String leftQaDslName) {
    this.leftQaDslName = leftQaDslName;
  }

  public CompareTestPlanQaDslResponseDto leftQaDslId(UUID leftQaDslId) {
    this.leftQaDslId = leftQaDslId;
    return this;
  }

  /**
   * Get leftQaDslId
   * @return leftQaDslId
  */
  @Valid 
  @Schema(name = "leftQaDslId", required = false)
  public UUID getLeftQaDslId() {
    return leftQaDslId;
  }

  public void setLeftQaDslId(UUID leftQaDslId) {
    this.leftQaDslId = leftQaDslId;
  }

  public CompareTestPlanQaDslResponseDto rightTestPlanId(UUID rightTestPlanId) {
    this.rightTestPlanId = rightTestPlanId;
    return this;
  }

  /**
   * Get rightTestPlanId
   * @return rightTestPlanId
  */
  @Valid 
  @Schema(name = "rightTestPlanId", required = false)
  public UUID getRightTestPlanId() {
    return rightTestPlanId;
  }

  public void setRightTestPlanId(UUID rightTestPlanId) {
    this.rightTestPlanId = rightTestPlanId;
  }

  public CompareTestPlanQaDslResponseDto rightTestPlanName(String rightTestPlanName) {
    this.rightTestPlanName = rightTestPlanName;
    return this;
  }

  /**
   * Get rightTestPlanName
   * @return rightTestPlanName
  */
  
  @Schema(name = "rightTestPlanName", required = false)
  public String getRightTestPlanName() {
    return rightTestPlanName;
  }

  public void setRightTestPlanName(String rightTestPlanName) {
    this.rightTestPlanName = rightTestPlanName;
  }

  public CompareTestPlanQaDslResponseDto rightQaDslName(String rightQaDslName) {
    this.rightQaDslName = rightQaDslName;
    return this;
  }

  /**
   * Get rightQaDslName
   * @return rightQaDslName
  */
  
  @Schema(name = "rightQaDslName", required = false)
  public String getRightQaDslName() {
    return rightQaDslName;
  }

  public void setRightQaDslName(String rightQaDslName) {
    this.rightQaDslName = rightQaDslName;
  }

  public CompareTestPlanQaDslResponseDto rightQaDslId(UUID rightQaDslId) {
    this.rightQaDslId = rightQaDslId;
    return this;
  }

  /**
   * Get rightQaDslId
   * @return rightQaDslId
  */
  @Valid 
  @Schema(name = "rightQaDslId", required = false)
  public UUID getRightQaDslId() {
    return rightQaDslId;
  }

  public void setRightQaDslId(UUID rightQaDslId) {
    this.rightQaDslId = rightQaDslId;
  }

  public CompareTestPlanQaDslResponseDto compounds(List<CompoundCompareDto> compounds) {
    this.compounds = compounds;
    return this;
  }

  public CompareTestPlanQaDslResponseDto addCompoundsItem(CompoundCompareDto compoundsItem) {
    if (this.compounds == null) {
      this.compounds = new ArrayList<>();
    }
    this.compounds.add(compoundsItem);
    return this;
  }

  /**
   * Get compounds
   * @return compounds
  */
  @Valid 
  @Schema(name = "compounds", required = false)
  public List<CompoundCompareDto> getCompounds() {
    return compounds;
  }

  public void setCompounds(List<CompoundCompareDto> compounds) {
    this.compounds = compounds;
  }

  public CompareTestPlanQaDslResponseDto total(BigDecimal total) {
    this.total = total;
    return this;
  }

  /**
   * Get total
   * @return total
  */
  @Valid 
  @Schema(name = "total", required = false)
  public BigDecimal getTotal() {
    return total;
  }

  public void setTotal(BigDecimal total) {
    this.total = total;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompareTestPlanQaDslResponseDto compareTestPlanQaDslResponse = (CompareTestPlanQaDslResponseDto) o;
    return Objects.equals(this.leftTestPlanId, compareTestPlanQaDslResponse.leftTestPlanId) &&
        Objects.equals(this.leftTestPlanName, compareTestPlanQaDslResponse.leftTestPlanName) &&
        Objects.equals(this.leftQaDslName, compareTestPlanQaDslResponse.leftQaDslName) &&
        Objects.equals(this.leftQaDslId, compareTestPlanQaDslResponse.leftQaDslId) &&
        Objects.equals(this.rightTestPlanId, compareTestPlanQaDslResponse.rightTestPlanId) &&
        Objects.equals(this.rightTestPlanName, compareTestPlanQaDslResponse.rightTestPlanName) &&
        Objects.equals(this.rightQaDslName, compareTestPlanQaDslResponse.rightQaDslName) &&
        Objects.equals(this.rightQaDslId, compareTestPlanQaDslResponse.rightQaDslId) &&
        Objects.equals(this.compounds, compareTestPlanQaDslResponse.compounds) &&
        Objects.equals(this.total, compareTestPlanQaDslResponse.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(leftTestPlanId, leftTestPlanName, leftQaDslName, leftQaDslId, rightTestPlanId, rightTestPlanName, rightQaDslName, rightQaDslId, compounds, total);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompareTestPlanQaDslResponseDto {\n");
    sb.append("    leftTestPlanId: ").append(toIndentedString(leftTestPlanId)).append("\n");
    sb.append("    leftTestPlanName: ").append(toIndentedString(leftTestPlanName)).append("\n");
    sb.append("    leftQaDslName: ").append(toIndentedString(leftQaDslName)).append("\n");
    sb.append("    leftQaDslId: ").append(toIndentedString(leftQaDslId)).append("\n");
    sb.append("    rightTestPlanId: ").append(toIndentedString(rightTestPlanId)).append("\n");
    sb.append("    rightTestPlanName: ").append(toIndentedString(rightTestPlanName)).append("\n");
    sb.append("    rightQaDslName: ").append(toIndentedString(rightQaDslName)).append("\n");
    sb.append("    rightQaDslId: ").append(toIndentedString(rightQaDslId)).append("\n");
    sb.append("    compounds: ").append(toIndentedString(compounds)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

