package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.AttributeTypeDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.DetailedComparisonStatusDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * ComparedAttributeDto
 */

@JsonTypeName("ComparedAttribute")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-27T09:48:25.973833073Z[Etc/UTC]")
public class ComparedAttributeDto {

  @JsonProperty("leftAttributeId")
  private UUID leftAttributeId;

  @JsonProperty("leftAttributeValue")
  private Object leftAttributeValue;

  @JsonProperty("leftAttributeType")
  private AttributeTypeDto leftAttributeType;

  @JsonProperty("rightAttributeId")
  private UUID rightAttributeId;

  @JsonProperty("rightAttributeValue")
  private Object rightAttributeValue;

  @JsonProperty("rightAttributeType")
  private AttributeTypeDto rightAttributeType;

  @JsonProperty("attributeName")
  private String attributeName;

  @JsonProperty("status")
  private DetailedComparisonStatusDto status;

  public ComparedAttributeDto leftAttributeId(UUID leftAttributeId) {
    this.leftAttributeId = leftAttributeId;
    return this;
  }

  /**
   * Get leftAttributeId
   * @return leftAttributeId
  */
  @Valid 
  @Schema(name = "leftAttributeId", required = false)
  public UUID getLeftAttributeId() {
    return leftAttributeId;
  }

  public void setLeftAttributeId(UUID leftAttributeId) {
    this.leftAttributeId = leftAttributeId;
  }

  public ComparedAttributeDto leftAttributeValue(Object leftAttributeValue) {
    this.leftAttributeValue = leftAttributeValue;
    return this;
  }

  /**
   * Get leftAttributeValue
   * @return leftAttributeValue
  */
  
  @Schema(name = "leftAttributeValue", required = false)
  public Object getLeftAttributeValue() {
    return leftAttributeValue;
  }

  public void setLeftAttributeValue(Object leftAttributeValue) {
    this.leftAttributeValue = leftAttributeValue;
  }

  public ComparedAttributeDto leftAttributeType(AttributeTypeDto leftAttributeType) {
    this.leftAttributeType = leftAttributeType;
    return this;
  }

  /**
   * Get leftAttributeType
   * @return leftAttributeType
  */
  @Valid 
  @Schema(name = "leftAttributeType", required = false)
  public AttributeTypeDto getLeftAttributeType() {
    return leftAttributeType;
  }

  public void setLeftAttributeType(AttributeTypeDto leftAttributeType) {
    this.leftAttributeType = leftAttributeType;
  }

  public ComparedAttributeDto rightAttributeId(UUID rightAttributeId) {
    this.rightAttributeId = rightAttributeId;
    return this;
  }

  /**
   * Get rightAttributeId
   * @return rightAttributeId
  */
  @Valid 
  @Schema(name = "rightAttributeId", required = false)
  public UUID getRightAttributeId() {
    return rightAttributeId;
  }

  public void setRightAttributeId(UUID rightAttributeId) {
    this.rightAttributeId = rightAttributeId;
  }

  public ComparedAttributeDto rightAttributeValue(Object rightAttributeValue) {
    this.rightAttributeValue = rightAttributeValue;
    return this;
  }

  /**
   * Get rightAttributeValue
   * @return rightAttributeValue
  */
  
  @Schema(name = "rightAttributeValue", required = false)
  public Object getRightAttributeValue() {
    return rightAttributeValue;
  }

  public void setRightAttributeValue(Object rightAttributeValue) {
    this.rightAttributeValue = rightAttributeValue;
  }

  public ComparedAttributeDto rightAttributeType(AttributeTypeDto rightAttributeType) {
    this.rightAttributeType = rightAttributeType;
    return this;
  }

  /**
   * Get rightAttributeType
   * @return rightAttributeType
  */
  @Valid 
  @Schema(name = "rightAttributeType", required = false)
  public AttributeTypeDto getRightAttributeType() {
    return rightAttributeType;
  }

  public void setRightAttributeType(AttributeTypeDto rightAttributeType) {
    this.rightAttributeType = rightAttributeType;
  }

  public ComparedAttributeDto attributeName(String attributeName) {
    this.attributeName = attributeName;
    return this;
  }

  /**
   * Get attributeName
   * @return attributeName
  */
  
  @Schema(name = "attributeName", required = false)
  public String getAttributeName() {
    return attributeName;
  }

  public void setAttributeName(String attributeName) {
    this.attributeName = attributeName;
  }

  public ComparedAttributeDto status(DetailedComparisonStatusDto status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
  */
  @Valid 
  @Schema(name = "status", required = false)
  public DetailedComparisonStatusDto getStatus() {
    return status;
  }

  public void setStatus(DetailedComparisonStatusDto status) {
    this.status = status;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ComparedAttributeDto comparedAttribute = (ComparedAttributeDto) o;
    return Objects.equals(this.leftAttributeId, comparedAttribute.leftAttributeId) &&
        Objects.equals(this.leftAttributeValue, comparedAttribute.leftAttributeValue) &&
        Objects.equals(this.leftAttributeType, comparedAttribute.leftAttributeType) &&
        Objects.equals(this.rightAttributeId, comparedAttribute.rightAttributeId) &&
        Objects.equals(this.rightAttributeValue, comparedAttribute.rightAttributeValue) &&
        Objects.equals(this.rightAttributeType, comparedAttribute.rightAttributeType) &&
        Objects.equals(this.attributeName, comparedAttribute.attributeName) &&
        Objects.equals(this.status, comparedAttribute.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(leftAttributeId, leftAttributeValue, leftAttributeType, rightAttributeId, rightAttributeValue, rightAttributeType, attributeName, status);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ComparedAttributeDto {\n");
    sb.append("    leftAttributeId: ").append(toIndentedString(leftAttributeId)).append("\n");
    sb.append("    leftAttributeValue: ").append(toIndentedString(leftAttributeValue)).append("\n");
    sb.append("    leftAttributeType: ").append(toIndentedString(leftAttributeType)).append("\n");
    sb.append("    rightAttributeId: ").append(toIndentedString(rightAttributeId)).append("\n");
    sb.append("    rightAttributeValue: ").append(toIndentedString(rightAttributeValue)).append("\n");
    sb.append("    rightAttributeType: ").append(toIndentedString(rightAttributeType)).append("\n");
    sb.append("    attributeName: ").append(toIndentedString(attributeName)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

