package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.AbstractEntityResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.JiraComponentDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.LabelDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScenarioDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScopeDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.UserInfoResDto;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestCase0Dto
 */

@JsonTypeName("TestCase0")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-27T09:48:26.621823710Z[Etc/UTC]")
public class TestCase0Dto {

  @JsonProperty("assignee")
  private UserInfoResDto assignee;

  @JsonProperty("components")
  @Valid
  private List<JiraComponentDto> components = null;

  @JsonProperty("createDate")
  private Long createDate;

  @JsonProperty("createdBy")
  private UserInfoResDto createdBy;

  @JsonProperty("dataset")
  private AbstractEntityResponseDto dataset;

  @JsonProperty("datasetStorage")
  private AbstractEntityResponseDto datasetStorage;

  @JsonProperty("description")
  private String description;

  @JsonProperty("groupId")
  private UUID groupId;

  @JsonProperty("jiraTicket")
  private String jiraTicket;

  @JsonProperty("jiraTicketUrl")
  private String jiraTicketUrl;

  @JsonProperty("labels")
  @Valid
  private List<LabelDto> labels = null;

  @JsonProperty("lastModifiedBy")
  private UserInfoResDto lastModifiedBy;

  @JsonProperty("lastRun")
  private UUID lastRun;

  @JsonProperty("lastRunStatus")
  private String lastRunStatus;

  @JsonProperty("modifiedWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime modifiedWhen;

  @JsonProperty("name")
  private String name;

  /**
   * Gets or Sets priority
   */
  public enum PriorityEnum {
    BLOCKER("BLOCKER"),
    
    CRITICAL("CRITICAL"),
    
    LOW("LOW"),
    
    MAJOR("MAJOR"),
    
    NORMAL("NORMAL");

    private String value;

    PriorityEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PriorityEnum fromValue(String value) {
      for (PriorityEnum b : PriorityEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("priority")
  private PriorityEnum priority;

  /**
   * Gets or Sets status
   */
  public enum StatusEnum {
    BLOCKED("BLOCKED"),
    
    CANCELLED("CANCELLED"),
    
    FAILED("FAILED"),
    
    IN_PROGRESS("IN_PROGRESS"),
    
    NOT_DELIVERED("NOT_DELIVERED"),
    
    OPEN("OPEN"),
    
    PASSED("PASSED"),
    
    PASSED_WITH_MINOR_DEFECTS("PASSED_WITH_MINOR_DEFECTS");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("status")
  private StatusEnum status;

  @JsonProperty("testScenario")
  private TestScenarioDto testScenario;

  @JsonProperty("testScopes")
  @Valid
  private List<TestScopeDto> testScopes = null;

  @JsonProperty("uuid")
  private UUID uuid;

  public TestCase0Dto assignee(UserInfoResDto assignee) {
    this.assignee = assignee;
    return this;
  }

  /**
   * Get assignee
   * @return assignee
  */
  @Valid 
  @Schema(name = "assignee", required = false)
  public UserInfoResDto getAssignee() {
    return assignee;
  }

  public void setAssignee(UserInfoResDto assignee) {
    this.assignee = assignee;
  }

  public TestCase0Dto components(List<JiraComponentDto> components) {
    this.components = components;
    return this;
  }

  public TestCase0Dto addComponentsItem(JiraComponentDto componentsItem) {
    if (this.components == null) {
      this.components = new ArrayList<>();
    }
    this.components.add(componentsItem);
    return this;
  }

  /**
   * Get components
   * @return components
  */
  @Valid 
  @Schema(name = "components", required = false)
  public List<JiraComponentDto> getComponents() {
    return components;
  }

  public void setComponents(List<JiraComponentDto> components) {
    this.components = components;
  }

  public TestCase0Dto createDate(Long createDate) {
    this.createDate = createDate;
    return this;
  }

  /**
   * Get createDate
   * @return createDate
  */
  
  @Schema(name = "createDate", required = false)
  public Long getCreateDate() {
    return createDate;
  }

  public void setCreateDate(Long createDate) {
    this.createDate = createDate;
  }

  public TestCase0Dto createdBy(UserInfoResDto createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
  */
  @Valid 
  @Schema(name = "createdBy", required = false)
  public UserInfoResDto getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(UserInfoResDto createdBy) {
    this.createdBy = createdBy;
  }

  public TestCase0Dto dataset(AbstractEntityResponseDto dataset) {
    this.dataset = dataset;
    return this;
  }

  /**
   * Get dataset
   * @return dataset
  */
  @Valid 
  @Schema(name = "dataset", required = false)
  public AbstractEntityResponseDto getDataset() {
    return dataset;
  }

  public void setDataset(AbstractEntityResponseDto dataset) {
    this.dataset = dataset;
  }

  public TestCase0Dto datasetStorage(AbstractEntityResponseDto datasetStorage) {
    this.datasetStorage = datasetStorage;
    return this;
  }

  /**
   * Get datasetStorage
   * @return datasetStorage
  */
  @Valid 
  @Schema(name = "datasetStorage", required = false)
  public AbstractEntityResponseDto getDatasetStorage() {
    return datasetStorage;
  }

  public void setDatasetStorage(AbstractEntityResponseDto datasetStorage) {
    this.datasetStorage = datasetStorage;
  }

  public TestCase0Dto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public TestCase0Dto groupId(UUID groupId) {
    this.groupId = groupId;
    return this;
  }

  /**
   * Get groupId
   * @return groupId
  */
  @Valid 
  @Schema(name = "groupId", required = false)
  public UUID getGroupId() {
    return groupId;
  }

  public void setGroupId(UUID groupId) {
    this.groupId = groupId;
  }

  public TestCase0Dto jiraTicket(String jiraTicket) {
    this.jiraTicket = jiraTicket;
    return this;
  }

  /**
   * Get jiraTicket
   * @return jiraTicket
  */
  
  @Schema(name = "jiraTicket", required = false)
  public String getJiraTicket() {
    return jiraTicket;
  }

  public void setJiraTicket(String jiraTicket) {
    this.jiraTicket = jiraTicket;
  }

  public TestCase0Dto jiraTicketUrl(String jiraTicketUrl) {
    this.jiraTicketUrl = jiraTicketUrl;
    return this;
  }

  /**
   * Get jiraTicketUrl
   * @return jiraTicketUrl
  */
  
  @Schema(name = "jiraTicketUrl", required = false)
  public String getJiraTicketUrl() {
    return jiraTicketUrl;
  }

  public void setJiraTicketUrl(String jiraTicketUrl) {
    this.jiraTicketUrl = jiraTicketUrl;
  }

  public TestCase0Dto labels(List<LabelDto> labels) {
    this.labels = labels;
    return this;
  }

  public TestCase0Dto addLabelsItem(LabelDto labelsItem) {
    if (this.labels == null) {
      this.labels = new ArrayList<>();
    }
    this.labels.add(labelsItem);
    return this;
  }

  /**
   * Get labels
   * @return labels
  */
  @Valid 
  @Schema(name = "labels", required = false)
  public List<LabelDto> getLabels() {
    return labels;
  }

  public void setLabels(List<LabelDto> labels) {
    this.labels = labels;
  }

  public TestCase0Dto lastModifiedBy(UserInfoResDto lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
    return this;
  }

  /**
   * Get lastModifiedBy
   * @return lastModifiedBy
  */
  @Valid 
  @Schema(name = "lastModifiedBy", required = false)
  public UserInfoResDto getLastModifiedBy() {
    return lastModifiedBy;
  }

  public void setLastModifiedBy(UserInfoResDto lastModifiedBy) {
    this.lastModifiedBy = lastModifiedBy;
  }

  public TestCase0Dto lastRun(UUID lastRun) {
    this.lastRun = lastRun;
    return this;
  }

  /**
   * Get lastRun
   * @return lastRun
  */
  @Valid 
  @Schema(name = "lastRun", required = false)
  public UUID getLastRun() {
    return lastRun;
  }

  public void setLastRun(UUID lastRun) {
    this.lastRun = lastRun;
  }

  public TestCase0Dto lastRunStatus(String lastRunStatus) {
    this.lastRunStatus = lastRunStatus;
    return this;
  }

  /**
   * Get lastRunStatus
   * @return lastRunStatus
  */
  
  @Schema(name = "lastRunStatus", required = false)
  public String getLastRunStatus() {
    return lastRunStatus;
  }

  public void setLastRunStatus(String lastRunStatus) {
    this.lastRunStatus = lastRunStatus;
  }

  public TestCase0Dto modifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  @Valid 
  @Schema(name = "modifiedWhen", required = false)
  public OffsetDateTime getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public TestCase0Dto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public TestCase0Dto priority(PriorityEnum priority) {
    this.priority = priority;
    return this;
  }

  /**
   * Get priority
   * @return priority
  */
  
  @Schema(name = "priority", required = false)
  public PriorityEnum getPriority() {
    return priority;
  }

  public void setPriority(PriorityEnum priority) {
    this.priority = priority;
  }

  public TestCase0Dto status(StatusEnum status) {
    this.status = status;
    return this;
  }

  /**
   * Get status
   * @return status
  */
  
  @Schema(name = "status", required = false)
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public TestCase0Dto testScenario(TestScenarioDto testScenario) {
    this.testScenario = testScenario;
    return this;
  }

  /**
   * Get testScenario
   * @return testScenario
  */
  @Valid 
  @Schema(name = "testScenario", required = false)
  public TestScenarioDto getTestScenario() {
    return testScenario;
  }

  public void setTestScenario(TestScenarioDto testScenario) {
    this.testScenario = testScenario;
  }

  public TestCase0Dto testScopes(List<TestScopeDto> testScopes) {
    this.testScopes = testScopes;
    return this;
  }

  public TestCase0Dto addTestScopesItem(TestScopeDto testScopesItem) {
    if (this.testScopes == null) {
      this.testScopes = new ArrayList<>();
    }
    this.testScopes.add(testScopesItem);
    return this;
  }

  /**
   * Get testScopes
   * @return testScopes
  */
  @Valid 
  @Schema(name = "testScopes", required = false)
  public List<TestScopeDto> getTestScopes() {
    return testScopes;
  }

  public void setTestScopes(List<TestScopeDto> testScopes) {
    this.testScopes = testScopes;
  }

  public TestCase0Dto uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * Get uuid
   * @return uuid
  */
  @Valid 
  @Schema(name = "uuid", required = false)
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestCase0Dto testCase0 = (TestCase0Dto) o;
    return Objects.equals(this.assignee, testCase0.assignee) &&
        Objects.equals(this.components, testCase0.components) &&
        Objects.equals(this.createDate, testCase0.createDate) &&
        Objects.equals(this.createdBy, testCase0.createdBy) &&
        Objects.equals(this.dataset, testCase0.dataset) &&
        Objects.equals(this.datasetStorage, testCase0.datasetStorage) &&
        Objects.equals(this.description, testCase0.description) &&
        Objects.equals(this.groupId, testCase0.groupId) &&
        Objects.equals(this.jiraTicket, testCase0.jiraTicket) &&
        Objects.equals(this.jiraTicketUrl, testCase0.jiraTicketUrl) &&
        Objects.equals(this.labels, testCase0.labels) &&
        Objects.equals(this.lastModifiedBy, testCase0.lastModifiedBy) &&
        Objects.equals(this.lastRun, testCase0.lastRun) &&
        Objects.equals(this.lastRunStatus, testCase0.lastRunStatus) &&
        Objects.equals(this.modifiedWhen, testCase0.modifiedWhen) &&
        Objects.equals(this.name, testCase0.name) &&
        Objects.equals(this.priority, testCase0.priority) &&
        Objects.equals(this.status, testCase0.status) &&
        Objects.equals(this.testScenario, testCase0.testScenario) &&
        Objects.equals(this.testScopes, testCase0.testScopes) &&
        Objects.equals(this.uuid, testCase0.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(assignee, components, createDate, createdBy, dataset, datasetStorage, description, groupId, jiraTicket, jiraTicketUrl, labels, lastModifiedBy, lastRun, lastRunStatus, modifiedWhen, name, priority, status, testScenario, testScopes, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestCase0Dto {\n");
    sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
    sb.append("    components: ").append(toIndentedString(components)).append("\n");
    sb.append("    createDate: ").append(toIndentedString(createDate)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    dataset: ").append(toIndentedString(dataset)).append("\n");
    sb.append("    datasetStorage: ").append(toIndentedString(datasetStorage)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    jiraTicket: ").append(toIndentedString(jiraTicket)).append("\n");
    sb.append("    jiraTicketUrl: ").append(toIndentedString(jiraTicketUrl)).append("\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("    lastModifiedBy: ").append(toIndentedString(lastModifiedBy)).append("\n");
    sb.append("    lastRun: ").append(toIndentedString(lastRun)).append("\n");
    sb.append("    lastRunStatus: ").append(toIndentedString(lastRunStatus)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    testScenario: ").append(toIndentedString(testScenario)).append("\n");
    sb.append("    testScopes: ").append(toIndentedString(testScopes)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

