package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.MetaInfoDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.UserInfoDto;
import org.springframework.format.annotation.DateTimeFormat;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestScenarioDto
 */

@JsonTypeName("TestScenario")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-27T09:48:27.365198101Z[Etc/UTC]")
public class TestScenarioDto {

  @JsonProperty("alsoCompound")
  private Boolean alsoCompound;

  @JsonProperty("createdBy")
  private UserInfoDto createdBy;

  @JsonProperty("createdWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime createdWhen;

  @JsonProperty("description")
  private String description;

  @JsonProperty("groupUuid")
  private UUID groupUuid;

  @JsonProperty("lastEdit")
  private Long lastEdit;

  @JsonProperty("metainfo")
  @Valid
  private List<MetaInfoDto> metainfo = null;

  @JsonProperty("modifiedBy")
  private UserInfoDto modifiedBy;

  @JsonProperty("modifiedWhen")
  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime modifiedWhen;

  @JsonProperty("name")
  private String name;

  @JsonProperty("projectUuid")
  private UUID projectUuid;

  @JsonProperty("testPlanUuid")
  private UUID testPlanUuid;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    COMPOUND("COMPOUND"),
    
    TESTSCENARIO("TESTSCENARIO");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  @JsonProperty("type")
  private TypeEnum type;

  @JsonProperty("uuid")
  private UUID uuid;

  public TestScenarioDto alsoCompound(Boolean alsoCompound) {
    this.alsoCompound = alsoCompound;
    return this;
  }

  /**
   * Get alsoCompound
   * @return alsoCompound
  */
  
  @Schema(name = "alsoCompound", required = false)
  public Boolean getAlsoCompound() {
    return alsoCompound;
  }

  public void setAlsoCompound(Boolean alsoCompound) {
    this.alsoCompound = alsoCompound;
  }

  public TestScenarioDto createdBy(UserInfoDto createdBy) {
    this.createdBy = createdBy;
    return this;
  }

  /**
   * Get createdBy
   * @return createdBy
  */
  @Valid 
  @Schema(name = "createdBy", required = false)
  public UserInfoDto getCreatedBy() {
    return createdBy;
  }

  public void setCreatedBy(UserInfoDto createdBy) {
    this.createdBy = createdBy;
  }

  public TestScenarioDto createdWhen(OffsetDateTime createdWhen) {
    this.createdWhen = createdWhen;
    return this;
  }

  /**
   * Get createdWhen
   * @return createdWhen
  */
  @Valid 
  @Schema(name = "createdWhen", required = false)
  public OffsetDateTime getCreatedWhen() {
    return createdWhen;
  }

  public void setCreatedWhen(OffsetDateTime createdWhen) {
    this.createdWhen = createdWhen;
  }

  public TestScenarioDto description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
  */
  
  @Schema(name = "description", required = false)
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public TestScenarioDto groupUuid(UUID groupUuid) {
    this.groupUuid = groupUuid;
    return this;
  }

  /**
   * Get groupUuid
   * @return groupUuid
  */
  @Valid 
  @Schema(name = "groupUuid", required = false)
  public UUID getGroupUuid() {
    return groupUuid;
  }

  public void setGroupUuid(UUID groupUuid) {
    this.groupUuid = groupUuid;
  }

  public TestScenarioDto lastEdit(Long lastEdit) {
    this.lastEdit = lastEdit;
    return this;
  }

  /**
   * Get lastEdit
   * @return lastEdit
  */
  
  @Schema(name = "lastEdit", required = false)
  public Long getLastEdit() {
    return lastEdit;
  }

  public void setLastEdit(Long lastEdit) {
    this.lastEdit = lastEdit;
  }

  public TestScenarioDto metainfo(List<MetaInfoDto> metainfo) {
    this.metainfo = metainfo;
    return this;
  }

  public TestScenarioDto addMetainfoItem(MetaInfoDto metainfoItem) {
    if (this.metainfo == null) {
      this.metainfo = new ArrayList<>();
    }
    this.metainfo.add(metainfoItem);
    return this;
  }

  /**
   * Get metainfo
   * @return metainfo
  */
  @Valid 
  @Schema(name = "metainfo", required = false)
  public List<MetaInfoDto> getMetainfo() {
    return metainfo;
  }

  public void setMetainfo(List<MetaInfoDto> metainfo) {
    this.metainfo = metainfo;
  }

  public TestScenarioDto modifiedBy(UserInfoDto modifiedBy) {
    this.modifiedBy = modifiedBy;
    return this;
  }

  /**
   * Get modifiedBy
   * @return modifiedBy
  */
  @Valid 
  @Schema(name = "modifiedBy", required = false)
  public UserInfoDto getModifiedBy() {
    return modifiedBy;
  }

  public void setModifiedBy(UserInfoDto modifiedBy) {
    this.modifiedBy = modifiedBy;
  }

  public TestScenarioDto modifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
    return this;
  }

  /**
   * Get modifiedWhen
   * @return modifiedWhen
  */
  @Valid 
  @Schema(name = "modifiedWhen", required = false)
  public OffsetDateTime getModifiedWhen() {
    return modifiedWhen;
  }

  public void setModifiedWhen(OffsetDateTime modifiedWhen) {
    this.modifiedWhen = modifiedWhen;
  }

  public TestScenarioDto name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
  */
  
  @Schema(name = "name", required = false)
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public TestScenarioDto projectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
    return this;
  }

  /**
   * Get projectUuid
   * @return projectUuid
  */
  @Valid 
  @Schema(name = "projectUuid", required = false)
  public UUID getProjectUuid() {
    return projectUuid;
  }

  public void setProjectUuid(UUID projectUuid) {
    this.projectUuid = projectUuid;
  }

  public TestScenarioDto testPlanUuid(UUID testPlanUuid) {
    this.testPlanUuid = testPlanUuid;
    return this;
  }

  /**
   * Get testPlanUuid
   * @return testPlanUuid
  */
  @Valid 
  @Schema(name = "testPlanUuid", required = false)
  public UUID getTestPlanUuid() {
    return testPlanUuid;
  }

  public void setTestPlanUuid(UUID testPlanUuid) {
    this.testPlanUuid = testPlanUuid;
  }

  public TestScenarioDto type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
  */
  
  @Schema(name = "type", required = false)
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public TestScenarioDto uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * Get uuid
   * @return uuid
  */
  @Valid 
  @Schema(name = "uuid", required = false)
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestScenarioDto testScenario = (TestScenarioDto) o;
    return Objects.equals(this.alsoCompound, testScenario.alsoCompound) &&
        Objects.equals(this.createdBy, testScenario.createdBy) &&
        Objects.equals(this.createdWhen, testScenario.createdWhen) &&
        Objects.equals(this.description, testScenario.description) &&
        Objects.equals(this.groupUuid, testScenario.groupUuid) &&
        Objects.equals(this.lastEdit, testScenario.lastEdit) &&
        Objects.equals(this.metainfo, testScenario.metainfo) &&
        Objects.equals(this.modifiedBy, testScenario.modifiedBy) &&
        Objects.equals(this.modifiedWhen, testScenario.modifiedWhen) &&
        Objects.equals(this.name, testScenario.name) &&
        Objects.equals(this.projectUuid, testScenario.projectUuid) &&
        Objects.equals(this.testPlanUuid, testScenario.testPlanUuid) &&
        Objects.equals(this.type, testScenario.type) &&
        Objects.equals(this.uuid, testScenario.uuid);
  }

  @Override
  public int hashCode() {
    return Objects.hash(alsoCompound, createdBy, createdWhen, description, groupUuid, lastEdit, metainfo, modifiedBy, modifiedWhen, name, projectUuid, testPlanUuid, type, uuid);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestScenarioDto {\n");
    sb.append("    alsoCompound: ").append(toIndentedString(alsoCompound)).append("\n");
    sb.append("    createdBy: ").append(toIndentedString(createdBy)).append("\n");
    sb.append("    createdWhen: ").append(toIndentedString(createdWhen)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    groupUuid: ").append(toIndentedString(groupUuid)).append("\n");
    sb.append("    lastEdit: ").append(toIndentedString(lastEdit)).append("\n");
    sb.append("    metainfo: ").append(toIndentedString(metainfo)).append("\n");
    sb.append("    modifiedBy: ").append(toIndentedString(modifiedBy)).append("\n");
    sb.append("    modifiedWhen: ").append(toIndentedString(modifiedWhen)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    projectUuid: ").append(toIndentedString(projectUuid)).append("\n");
    sb.append("    testPlanUuid: ").append(toIndentedString(testPlanUuid)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

