package org.qubership.atp.ram.clients.api.dto.catalogue;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompoundCopyItemDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.ItemDto;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * TestScopesCopyRequestDto
 */

@JsonTypeName("TestScopesCopyRequest")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2025-06-27T09:48:27.057735483Z[Etc/UTC]")
public class TestScopesCopyRequestDto {

  @JsonProperty("sourceTestPlanId")
  private UUID sourceTestPlanId;

  @JsonProperty("targetTestPlanId")
  private UUID targetTestPlanId;

  @JsonProperty("items")
  @Valid
  private Set<ItemDto> items = null;

  @JsonProperty("compounds")
  @Valid
  private List<CompoundCopyItemDto> compounds = null;

  @JsonProperty("copyCompounds")
  private Boolean copyCompounds;

  @JsonProperty("copyDatasets")
  private Boolean copyDatasets;

  @JsonProperty("setPostfix")
  private Boolean setPostfix;

  @JsonProperty("postfix")
  private String postfix;

  public TestScopesCopyRequestDto sourceTestPlanId(UUID sourceTestPlanId) {
    this.sourceTestPlanId = sourceTestPlanId;
    return this;
  }

  /**
   * Get sourceTestPlanId
   * @return sourceTestPlanId
  */
  @NotNull @Valid 
  @Schema(name = "sourceTestPlanId", required = true)
  public UUID getSourceTestPlanId() {
    return sourceTestPlanId;
  }

  public void setSourceTestPlanId(UUID sourceTestPlanId) {
    this.sourceTestPlanId = sourceTestPlanId;
  }

  public TestScopesCopyRequestDto targetTestPlanId(UUID targetTestPlanId) {
    this.targetTestPlanId = targetTestPlanId;
    return this;
  }

  /**
   * Get targetTestPlanId
   * @return targetTestPlanId
  */
  @NotNull @Valid 
  @Schema(name = "targetTestPlanId", required = true)
  public UUID getTargetTestPlanId() {
    return targetTestPlanId;
  }

  public void setTargetTestPlanId(UUID targetTestPlanId) {
    this.targetTestPlanId = targetTestPlanId;
  }

  public TestScopesCopyRequestDto items(Set<ItemDto> items) {
    this.items = items;
    return this;
  }

  public TestScopesCopyRequestDto addItemsItem(ItemDto itemsItem) {
    if (this.items == null) {
      this.items = new LinkedHashSet<>();
    }
    this.items.add(itemsItem);
    return this;
  }

  /**
   * Get items
   * @return items
  */
  @Valid 
  @Schema(name = "items", required = false)
  public Set<ItemDto> getItems() {
    return items;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  public void setItems(Set<ItemDto> items) {
    this.items = items;
  }

  public TestScopesCopyRequestDto compounds(List<CompoundCopyItemDto> compounds) {
    this.compounds = compounds;
    return this;
  }

  public TestScopesCopyRequestDto addCompoundsItem(CompoundCopyItemDto compoundsItem) {
    if (this.compounds == null) {
      this.compounds = new ArrayList<>();
    }
    this.compounds.add(compoundsItem);
    return this;
  }

  /**
   * Get compounds
   * @return compounds
  */
  @Valid 
  @Schema(name = "compounds", required = false)
  public List<CompoundCopyItemDto> getCompounds() {
    return compounds;
  }

  public void setCompounds(List<CompoundCopyItemDto> compounds) {
    this.compounds = compounds;
  }

  public TestScopesCopyRequestDto copyCompounds(Boolean copyCompounds) {
    this.copyCompounds = copyCompounds;
    return this;
  }

  /**
   * Get copyCompounds
   * @return copyCompounds
  */
  
  @Schema(name = "copyCompounds", required = false)
  public Boolean getCopyCompounds() {
    return copyCompounds;
  }

  public void setCopyCompounds(Boolean copyCompounds) {
    this.copyCompounds = copyCompounds;
  }

  public TestScopesCopyRequestDto copyDatasets(Boolean copyDatasets) {
    this.copyDatasets = copyDatasets;
    return this;
  }

  /**
   * Get copyDatasets
   * @return copyDatasets
  */
  
  @Schema(name = "copyDatasets", required = false)
  public Boolean getCopyDatasets() {
    return copyDatasets;
  }

  public void setCopyDatasets(Boolean copyDatasets) {
    this.copyDatasets = copyDatasets;
  }

  public TestScopesCopyRequestDto setPostfix(Boolean setPostfix) {
    this.setPostfix = setPostfix;
    return this;
  }

  /**
   * Get setPostfix
   * @return setPostfix
  */
  
  @Schema(name = "setPostfix", required = false)
  public Boolean getSetPostfix() {
    return setPostfix;
  }

  public void setSetPostfix(Boolean setPostfix) {
    this.setPostfix = setPostfix;
  }

  public TestScopesCopyRequestDto postfix(String postfix) {
    this.postfix = postfix;
    return this;
  }

  /**
   * Get postfix
   * @return postfix
  */
  
  @Schema(name = "postfix", required = false)
  public String getPostfix() {
    return postfix;
  }

  public void setPostfix(String postfix) {
    this.postfix = postfix;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TestScopesCopyRequestDto testScopesCopyRequest = (TestScopesCopyRequestDto) o;
    return Objects.equals(this.sourceTestPlanId, testScopesCopyRequest.sourceTestPlanId) &&
        Objects.equals(this.targetTestPlanId, testScopesCopyRequest.targetTestPlanId) &&
        Objects.equals(this.items, testScopesCopyRequest.items) &&
        Objects.equals(this.compounds, testScopesCopyRequest.compounds) &&
        Objects.equals(this.copyCompounds, testScopesCopyRequest.copyCompounds) &&
        Objects.equals(this.copyDatasets, testScopesCopyRequest.copyDatasets) &&
        Objects.equals(this.setPostfix, testScopesCopyRequest.setPostfix) &&
        Objects.equals(this.postfix, testScopesCopyRequest.postfix);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceTestPlanId, targetTestPlanId, items, compounds, copyCompounds, copyDatasets, setPostfix, postfix);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TestScopesCopyRequestDto {\n");
    sb.append("    sourceTestPlanId: ").append(toIndentedString(sourceTestPlanId)).append("\n");
    sb.append("    targetTestPlanId: ").append(toIndentedString(targetTestPlanId)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("    compounds: ").append(toIndentedString(compounds)).append("\n");
    sb.append("    copyCompounds: ").append(toIndentedString(copyCompounds)).append("\n");
    sb.append("    copyDatasets: ").append(toIndentedString(copyDatasets)).append("\n");
    sb.append("    setPostfix: ").append(toIndentedString(setPostfix)).append("\n");
    sb.append("    postfix: ").append(toIndentedString(postfix)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

