/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.dataset.clients.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import org.qubership.atp.dataset.clients.dto.AbstractParameterDto;
import org.qubership.atp.dataset.clients.dto.DataSetGroupDto;

@JsonTypeName(value="DataSetTree")
public class DataSetTreeDto {
    @JsonProperty(value="groups")
    @Valid
    private Map<String, DataSetGroupDto> groups = null;
    @JsonProperty(value="parameters")
    @Valid
    private Map<String, AbstractParameterDto> parameters = null;

    public DataSetTreeDto groups(Map<String, DataSetGroupDto> groups) {
        this.groups = groups;
        return this;
    }

    public DataSetTreeDto putGroupsItem(String key, DataSetGroupDto groupsItem) {
        if (this.groups == null) {
            this.groups = new HashMap<String, DataSetGroupDto>();
        }
        this.groups.put(key, groupsItem);
        return this;
    }

    @Valid
    @Schema(name="groups", required=false)
    public Map<String, DataSetGroupDto> getGroups() {
        return this.groups;
    }

    public void setGroups(Map<String, DataSetGroupDto> groups) {
        this.groups = groups;
    }

    public DataSetTreeDto parameters(Map<String, AbstractParameterDto> parameters) {
        this.parameters = parameters;
        return this;
    }

    public DataSetTreeDto putParametersItem(String key, AbstractParameterDto parametersItem) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, AbstractParameterDto>();
        }
        this.parameters.put(key, parametersItem);
        return this;
    }

    @Valid
    @Schema(name="parameters", required=false)
    public Map<String, AbstractParameterDto> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, AbstractParameterDto> parameters) {
        this.parameters = parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSetTreeDto dataSetTree = (DataSetTreeDto)o;
        return Objects.equals(this.groups, dataSetTree.groups) && Objects.equals(this.parameters, dataSetTree.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.groups, this.parameters);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataSetTreeDto {\n");
        sb.append("    groups: ").append(this.toIndentedString(this.groups)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

