/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.clients.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.ram.clients.api.dto.catalogue.AbstractTestScenarioDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CloneTestPlanRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompareTestPlanQaDslResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompareTestPlansRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompareTestPlansResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompoundDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.DslDependencyNodeDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.LabelDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.LogCollectorConditionDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.QaDslLibraryDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseGroupDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanDslMappingsRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanDslMappingsResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanDtoDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanEntitiesResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestPlanResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScenarioDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScopeDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScopeFullInfoDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Validated
@Tag(name="TestPlanController", description="Test Plan Controller")
public interface TestPlanControllerApi {
    @Operation(operationId="bulkUpdate", summary="bulkUpdate", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestPlanResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/catalog/api/v1/testplans/bulk"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<TestPlanResponseDto>> bulkUpdate(@Parameter(name="TestPlanDto", description="") @Valid @RequestBody(required=false) List<TestPlanDto> var1);

    @Operation(operationId="cloneTestPlan", summary="cloneTestPlan", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testplans/clone"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UUID> cloneTestPlan(@Parameter(name="CloneTestPlanRequestDto", description="") @Valid @RequestBody(required=false) CloneTestPlanRequestDto var1);

    @Operation(operationId="compareTestPlanQaDsl", summary="compareTestPlanQaDsl", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CompareTestPlanQaDslResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testplans/qadsllibraries/compare"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<CompareTestPlanQaDslResponseDto> compareTestPlanQaDsl(@Parameter(name="CompareTestPlansRequestDto", description="") @Valid @RequestBody(required=false) CompareTestPlansRequestDto var1);

    @Operation(operationId="compareTestPlans", summary="compareTestPlans", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CompareTestPlansResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testplans/compare"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<CompareTestPlansResponseDto> compareTestPlans(@Parameter(name="CompareTestPlansRequestDto", description="") @Valid @RequestBody(required=false) CompareTestPlansRequestDto var1);

    @Operation(operationId="create", summary="create", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestPlanResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testplans"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<TestPlanResponseDto> create(@Parameter(name="TestPlanDto", description="") @Valid @RequestBody(required=false) TestPlanDto var1);

    @Operation(operationId="delete", summary="delete", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/catalog/api/v1/testplans/{uuid}"})
    public ResponseEntity<Void> delete(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getAll", summary="getAll", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestPlanResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testplans"}, produces={"application/json"})
    public ResponseEntity<List<TestPlanResponseDto>> getAll();

    @Operation(operationId="getAllCompoundsAndScenarioCompounds", summary="getAllCompoundsAndScenarioCompounds", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=AbstractTestScenarioDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testplans/{uuid}/compounds/compound_from_ts"}, produces={"application/json"})
    public ResponseEntity<List<AbstractTestScenarioDto>> getAllCompoundsAndScenarioCompounds(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getAllCompoundsByTestPlan", summary="getAllCompoundsByTestPlan", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CompoundDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testplans/{uuid}/compounds"}, produces={"application/json"})
    public ResponseEntity<List<CompoundDto>> getAllCompoundsByTestPlan(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getAllCompoundsMadeFromTestScenario", summary="getAllCompoundsMadeFromTestScenario", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScenarioDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testplans/{uuid}/compound_from_ts"}, produces={"application/json"})
    public ResponseEntity<List<TestScenarioDto>> getAllCompoundsMadeFromTestScenario(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getAllNameByTestPlanId", summary="getAllNameByTestPlanId", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseGroupDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testplans/{uuid}/testcasegroups/short"}, produces={"application/json"})
    public ResponseEntity<List<TestCaseGroupDto>> getAllNameByTestPlanId(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getDslDependencies", summary="getDslDependencies", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=DslDependencyNodeDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testplans/{uuid}/dslDependencies"}, produces={"application/json"})
    public ResponseEntity<List<DslDependencyNodeDto>> getDslDependencies(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getDslMappings", summary="getDslMappings", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestPlanDslMappingsResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testplans/{testPlanId}/dslMappings"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<TestPlanDslMappingsResponseDto> getDslMappings(@Parameter(name="testPlanId", description="", required=true) @PathVariable(value="testPlanId") UUID var1, @Parameter(name="TestPlanDslMappingsRequestDto", description="") @Valid @RequestBody(required=false) TestPlanDslMappingsRequestDto var2);

    @Operation(operationId="getEntitiesForCopyByTestPlan", summary="getEntitiesForCopyByTestPlan", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestPlanEntitiesResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testplans/{uuid}/enriched"}, produces={"application/json"})
    public ResponseEntity<TestPlanEntitiesResponseDto> getEntitiesForCopyByTestPlan(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getLabelsByTestPlanId", summary="getLabelsByTestPlanId", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LabelDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testplans/{uuid}/labels"}, produces={"application/json"})
    public ResponseEntity<List<LabelDto>> getLabelsByTestPlanId(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getLogCollectorConditionByTestPlan", summary="getLogCollectorConditionByTestPlan", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=LogCollectorConditionDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testplans/{uuid}/logcollectorconditions"}, produces={"application/json"})
    public ResponseEntity<List<LogCollectorConditionDto>> getLogCollectorConditionByTestPlan(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getTestCaseGroupedByTestPlanId", summary="getTestCaseGroupedByTestPlanId", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseGroupDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testplans/{uuid}/testcasegroups"}, produces={"application/json"})
    public ResponseEntity<List<TestCaseGroupDto>> getTestCaseGroupedByTestPlanId(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getTestCasesByTestPlanId", summary="getTestCasesByTestPlanId", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testplans/{uuid}/testcases"}, produces={"application/json"})
    public ResponseEntity<List<TestCaseDto>> getTestCasesByTestPlanId(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getTestPlanByUuid", summary="getTestPlanByUuid", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestPlanDtoDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testplans/{uuid}"}, produces={"application/json"})
    public ResponseEntity<TestPlanDtoDto> getTestPlanByUuid(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getTestPlanQaDslLibrary", summary="getTestPlanQaDslLibrary", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=QaDslLibraryDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testplans/{uuid}/qadsllibrary"}, produces={"application/json"})
    public ResponseEntity<QaDslLibraryDto> getTestPlanQaDslLibrary(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getTestScopesByTestPlanId", summary="getTestScopesByTestPlanId", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScopeDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testplans/{uuid}/testscopes"}, produces={"application/json"})
    public ResponseEntity<List<TestScopeDto>> getTestScopesByTestPlanId(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getTestScopesFullInfoByTestPlanUuid", summary="getTestScopesFullInfoByTestPlanUuid", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScopeFullInfoDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testplans/{uuid}/testscopes/enriched"}, produces={"application/json"})
    public ResponseEntity<List<TestScopeFullInfoDto>> getTestScopesFullInfoByTestPlanUuid(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="patch", summary="patch", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden")})
    @RequestMapping(method={RequestMethod.PATCH}, value={"/catalog/api/v1/testplans"}, consumes={"application/json"})
    public ResponseEntity<Void> patch(@Parameter(name="TestPlanDto", description="") @Valid @RequestBody(required=false) List<TestPlanDto> var1);

    @Operation(operationId="patchUpdate", summary="patchUpdate", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/catalog/api/v1/testplans/patch"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UUID> patchUpdate(@Parameter(name="TestPlanDto", description="") @Valid @RequestBody(required=false) TestPlanDto var1);

    @Operation(operationId="update", summary="update", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/catalog/api/v1/testplans"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UUID> update(@Parameter(name="TestPlanDto", description="") @Valid @RequestBody(required=false) TestPlanDto var1);

    @Operation(operationId="updateQaDslLibraryField", summary="updateQaDslLibraryField", tags={"test-plan-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/catalog/api/v1/testplans/update-qa-dsl"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UUID> updateQaDslLibraryField(@Parameter(name="TestPlanDto", description="") @Valid @RequestBody(required=false) TestPlanDto var1);
}

