/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.clients.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.qubership.atp.ram.clients.api.dto.catalogue.CheckSumResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CompoundBodyRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.CopyRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.EnrichedTestScenarioDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.MetaInfoForCompareRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.MetaInfoForTestScenarioCompareResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.MetaInfoTreeResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.MoveRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.PageAbstractEntityResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.SaveEntityRequestTestScenarioDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.SaveListOfEntityRequestTestScenarioDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.ScenarioPatchUpdateRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestCaseResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScenarioDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScenarioEditorResponseDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScenariosCompareRequestDto;
import org.qubership.atp.ram.clients.api.dto.catalogue.TestScenariosCompareResponseDto;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Validated
@Tag(name="TestScenarioController", description="Test Scenario Controller")
public interface TestScenarioControllerApi {
    @Operation(operationId="addCompoundsToTestScenario", summary="addCompoundsToTestScenario", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testscenarios/{uuid}/compounds"}, consumes={"application/json"})
    public ResponseEntity<Void> addCompoundsToTestScenario(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1, @Parameter(name="CompoundBodyRequestDto", description="") @Valid @RequestBody(required=false) CompoundBodyRequestDto var2);

    @Operation(operationId="checkHashSum", summary="checkHashSum", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=CheckSumResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testscenarios/checkHashSum"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<CheckSumResponseDto> checkHashSum(@Parameter(name="request_body", description="") @Valid @RequestBody(required=false) Map<String, String> var1);

    @Operation(operationId="compareTestScenarios", summary="compareTestScenarios", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScenariosCompareResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testscenarios/compare"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<TestScenariosCompareResponseDto> compareTestScenarios(@Parameter(name="TestScenariosCompareRequestDto", description="") @Valid @RequestBody(required=false) TestScenariosCompareRequestDto var1);

    @Operation(operationId="copyTestScenarios", summary="copyTestScenarios", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScenarioDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testscenarios/copy"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<List<TestScenarioDto>> copyTestScenarios(@Parameter(name="CopyRequestDto", description="") @Valid @RequestBody(required=false) CopyRequestDto var1);

    @Operation(operationId="create", summary="create", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testscenarios/create"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UUID> create(@Parameter(name="SaveEntityRequestTestScenarioDto", description="") @Valid @RequestBody(required=false) SaveEntityRequestTestScenarioDto var1);

    @Operation(operationId="createBulk", summary="createBulk", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testscenarios/create/bulk"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Set<UUID>> createBulk(@Parameter(name="SaveListOfEntityRequestTestScenarioDto", description="") @Valid @RequestBody(required=false) SaveListOfEntityRequestTestScenarioDto var1);

    @Operation(operationId="createCompoundFromTestScenario", summary="createCompoundFromTestScenario", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScenarioDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testscenarios/{uuid}/create/compound_from_ts"}, produces={"application/json"})
    public ResponseEntity<TestScenarioDto> createCompoundFromTestScenario(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getAll", summary="getAll", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScenarioDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testscenarios"}, produces={"application/json"})
    public ResponseEntity<List<TestScenarioDto>> getAll();

    @Operation(operationId="getAllEnriched", summary="getAllEnriched", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=EnrichedTestScenarioDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testscenarios/enriched"}, produces={"application/json"})
    public ResponseEntity<List<EnrichedTestScenarioDto>> getAllEnriched(@NotNull @Parameter(name="includes", description="includes", required=true) @Valid @RequestParam(value="includes", required=true) String var1);

    @Operation(operationId="getAllNameByProjectId", summary="getAllNameByProjectId", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScenarioDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testscenarios/find-name"}, produces={"application/json"})
    public ResponseEntity<List<TestScenarioDto>> getAllNameByProjectId(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @Parameter(name="testPlanId", description="testPlanId") @Valid @RequestParam(value="testPlanId", required=false) UUID var2);

    @Operation(operationId="getAllNamesByNameWithPagination", summary="getAllNamesByNameWithPagination", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=PageAbstractEntityResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testscenarios/find-name-pagination"}, produces={"application/json"})
    public ResponseEntity<PageAbstractEntityResponseDto> getAllNamesByNameWithPagination(@NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var1, @NotNull @Parameter(name="testPlanId", description="testPlanId", required=true) @Valid @RequestParam(value="testPlanId", required=true) UUID var2, @NotNull @Parameter(name="name", description="name", required=true) @Valid @RequestParam(value="name", required=true) String var3, @Parameter(name="offset", description="") @Valid @RequestParam(value="offset", required=false) Long var4, @Parameter(name="pageNumber", description="") @Valid @RequestParam(value="pageNumber", required=false) Integer var5, @Parameter(name="pageSize", description="") @Valid @RequestParam(value="pageSize", required=false) Integer var6, @Parameter(name="paged", description="") @Valid @RequestParam(value="paged", required=false) Boolean var7, @Parameter(name="sort.sorted", description="") @Valid @RequestParam(value="sort.sorted", required=false) Boolean var8, @Parameter(name="sort.unsorted", description="") @Valid @RequestParam(value="sort.unsorted", required=false) Boolean var9, @Parameter(name="unpaged", description="") @Valid @RequestParam(value="unpaged", required=false) Boolean var10);

    @Operation(operationId="getMetaInfoForScenarioCompare", summary="getMetaInfoForScenarioCompare", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MetaInfoForTestScenarioCompareResponseDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testscenarios/compare/editor"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<MetaInfoForTestScenarioCompareResponseDto> getMetaInfoForScenarioCompare(@Parameter(name="MetaInfoForCompareRequestDto", description="") @Valid @RequestBody(required=false) MetaInfoForCompareRequestDto var1);

    @Operation(operationId="getMetaInfoTreeResponse", summary="getMetaInfoTreeResponse", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=MetaInfoTreeResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testscenarios/{uuid}/metainfo-tree"}, produces={"application/json"})
    public ResponseEntity<MetaInfoTreeResponseDto> getMetaInfoTreeResponse(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getScenarioBodyForEditor", summary="getScenarioBodyForEditor", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScenarioEditorResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testscenarios/{uuid}/editor"}, produces={"application/json"})
    public ResponseEntity<TestScenarioEditorResponseDto> getScenarioBodyForEditor(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getTestCasesLabel", summary="getTestCasesLabel", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestCaseResponseDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testscenarios/{uuid}/testcases"}, produces={"application/json"})
    public ResponseEntity<List<TestCaseResponseDto>> getTestCasesLabel(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1);

    @Operation(operationId="getTestScenarioByUuid", summary="getTestScenarioByUuid", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScenarioDto.class))}), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.GET}, value={"/catalog/api/v1/testscenarios/{uuid}"}, produces={"application/json"})
    public ResponseEntity<TestScenarioDto> getTestScenarioByUuid(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") String var1);

    @Operation(operationId="moveTestScenarios", summary="moveTestScenarios", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.POST}, value={"/catalog/api/v1/testscenarios/move"}, consumes={"application/json"})
    public ResponseEntity<Void> moveTestScenarios(@Parameter(name="MoveRequestDto", description="") @Valid @RequestBody(required=false) MoveRequestDto var1);

    @Operation(operationId="patchUpdate", summary="patchUpdate", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=TestScenarioDto.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/catalog/api/v1/testscenarios/{uuid}/patch"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<TestScenarioDto> patchUpdate(@Parameter(name="uuid", description="uuid", required=true) @PathVariable(value="uuid") UUID var1, @NotNull @Parameter(name="projectId", description="projectId", required=true) @Valid @RequestParam(value="projectId", required=true) UUID var2, @Parameter(name="rename", description="rename") @Valid @RequestParam(value="rename", required=false) Boolean var3, @Parameter(name="ScenarioPatchUpdateRequestDto", description="") @Valid @RequestBody(required=false) ScenarioPatchUpdateRequestDto var4);

    @Operation(operationId="update", summary="update", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/catalog/api/v1/testscenarios/save"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UUID> update(@Parameter(name="TestScenarioDto", description="") @Valid @RequestBody(required=false) TestScenarioDto var1);

    @Operation(operationId="updateFromEditor", summary="updateFromEditor", tags={"test-scenario-controller"}, responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=UUID.class))}), @ApiResponse(responseCode="201", description="Created"), @ApiResponse(responseCode="401", description="Unauthorized"), @ApiResponse(responseCode="403", description="Forbidden"), @ApiResponse(responseCode="404", description="Not Found")})
    @RequestMapping(method={RequestMethod.PUT}, value={"/catalog/api/v1/testscenarios/editor/save"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<UUID> updateFromEditor(@Parameter(name="TestScenarioEditorResponseDto", description="") @Valid @RequestBody(required=false) TestScenarioEditorResponseDto var1);
}

