/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.config;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.modelmapper.ModelMapper;
import org.modelmapper.convention.MatchingStrategies;
import org.qubership.atp.ram.clients.api.dto.catalogue.FieldsDto;
import org.qubership.atp.ram.converter.OffsetDateTime2TimestampConverter;
import org.qubership.atp.ram.converter.Timestamp2OffsetDateTimeConverter;
import org.qubership.atp.ram.deserializers.DateDeserializer;
import org.qubership.atp.ram.deserializers.TimestampDeserializer;
import org.qubership.atp.ram.model.jira.Fields;
import org.qubership.atp.ram.models.usersettings.TableColumnVisibilityUserSetting;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Configuration
public class MvcConfig {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";

    @Bean
    public ObjectMapper objectMapper(Jackson2ObjectMapperBuilder builder) {
        ObjectMapper mapper = builder.createXmlMapper(false).dateFormat((DateFormat)new SimpleDateFormat(DATE_FORMAT)).build();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Timestamp.class, (JsonDeserializer)new TimestampDeserializer());
        module.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializer());
        mapper.registerModule((Module)module);
        return mapper;
    }

    @Bean
    public ModelMapper modelMapper() {
        ModelMapper modelMapper = new ModelMapper();
        modelMapper.getConfiguration().setSkipNullEnabled(true);
        modelMapper.getConfiguration().setAmbiguityIgnored(true);
        modelMapper.getConfiguration().setMatchingStrategy(MatchingStrategies.STANDARD);
        modelMapper.typeMap(Fields.class, FieldsDto.class).addMappings(m -> m.map(Fields::getAtpLink, FieldsDto::setCustomfield17400)).addMappings(m -> m.map(src -> src.getFoundIn().getValue(), (dest, v) -> dest.getCustomfield10014().setValue((String)v)));
        modelMapper.getConfiguration().getConverters().add(new Timestamp2OffsetDateTimeConverter());
        modelMapper.getConfiguration().getConverters().add(new OffsetDateTime2TimestampConverter());
        modelMapper.createTypeMap(TableColumnVisibilityUserSetting.class, TableColumnVisibilityUserSetting.class).addMappings(map -> map.using(mappingContext -> {
            List source = (List)mappingContext.getSource();
            if (source != null) {
                return source.stream().map(String::new).collect(Collectors.toList());
            }
            return new ArrayList();
        }).map(TableColumnVisibilityUserSetting::getVisibleColumns, TableColumnVisibilityUserSetting::setVisibleColumns));
        return modelMapper;
    }
}

