/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.qubership.atp.ram.utils.DateTimeFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateDeserializer
extends JsonDeserializer<Date> {
    private static final Logger log = LoggerFactory.getLogger(DateDeserializer.class);
    private static final DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTime();

    public Date deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        String text = jsonParser.getText().trim();
        try {
            if (DateTimeFormatUtils.isMilliSecondsFormat(text)) {
                long milliSeconds = (long)(Double.parseDouble(text) * 1000.0);
                return new Date(milliSeconds);
            }
            DateTime dateTime = dateTimeFormatter.parseDateTime(text);
            return dateTime.toDate();
        }
        catch (Exception e) {
            log.error("Unable to parse provided string to date: " + text, (Throwable)e);
            return null;
        }
    }
}

