/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.mapper;

import java.util.Objects;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.qubership.atp.ram.mapper.Mapper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractMapper<E, D>
implements Mapper<E, D> {
    @Autowired
    ModelMapper mapper;
    private Class<E> entityClass;
    private Class<D> dtoClass;

    AbstractMapper(Class<E> entityClass, Class<D> dtoClass) {
        this.entityClass = entityClass;
        this.dtoClass = dtoClass;
    }

    @Override
    public D entityToDto(E entity) {
        return (D)(Objects.isNull(entity) ? null : this.mapper.map(entity, this.dtoClass));
    }

    Converter<E, D> mapConverter() {
        return context -> {
            Object entity = context.getSource();
            Object dto = context.getDestination();
            this.mapSpecificFields(entity, dto);
            return context.getDestination();
        };
    }

    void mapSpecificFields(E entity, D dto) {
    }
}

