/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.repositories;

import com.google.common.base.Strings;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.qubership.atp.ram.exceptions.internal.RamReportGridFsFileNotFoundException;
import org.qubership.atp.ram.model.ExtendedFileData;
import org.qubership.atp.ram.model.FileData;
import org.qubership.atp.ram.model.GridFsFileData;
import org.qubership.atp.ram.models.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository(value="ram-gridfs-repository")
public class GridFsRepository {
    private static final Logger log = LoggerFactory.getLogger(GridFsRepository.class);
    private static final String LOG_RECORD_UUID = "logRecordUuid";
    private static final String METADATA_LOG_RECORD_UUID = "metadata.logRecordUuid";
    private static final String METADATA_SOURCE = "metadata.snapshotSource";
    private static final String TYPE = "type";
    private static final String UPLOAD_DATE = "uploadDate";
    private static final String CONTENT_TYPE = "contentType";
    private static final String REPORT_ID = "reportId";
    private static final String HTML = "html";
    private static final String EXECUTION_REQUEST_ID = "executionRequestId";
    private static final String METADATA_REPORT_ID = "metadata.reportId";
    private static final String SNAPSHOT_SOURCE = "snapshotSource";
    private static final String TEST_RUN_ID = "testRunId";
    private static final String TEST_RUN_UUID = "testRunUuid";
    private final GridFSBucket gridFsBucket;
    @Value(value="${gridfs.chunk.size}")
    private Integer chunkSizeBytes;

    @NotNull
    public List<ExtendedFileData> getAllFilesWhereMetadataLogRecordIdInList(List<UUID> logRecordsIds) {
        Document filter = this.getMetadataLogRecordIdsInFilter(logRecordsIds);
        List gridFsFiles = new ArrayList();
        gridFsFiles = (List)this.gridFsBucket.find((Bson)filter).into(gridFsFiles);
        List<ExtendedFileData> result = gridFsFiles.parallelStream().map(file -> {
            log.debug("File was found {}", (Object)file.getFilename());
            UUID logRecordId = (UUID)Objects.requireNonNull(file.getMetadata()).get((Object)LOG_RECORD_UUID, UUID.class);
            return new ExtendedFileData(this.createFileDataFromFileInDb((GridFSFile)file), logRecordId);
        }).collect(Collectors.toList());
        if (result.isEmpty()) {
            log.debug("Cannot find any files");
        }
        return result;
    }

    private FileData createFileDataFromFileInDb(GridFSFile file) {
        ByteArrayOutputStream bos = this.downloadFileFromDbToByteStream(file);
        return this.composeFileDataFromGridFsFileAndItsContent(file, bos);
    }

    private ByteArrayOutputStream downloadFileFromDbToByteStream(GridFSFile file) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.gridFsBucket.downloadToStream(file.getObjectId(), (OutputStream)bos);
        return bos;
    }

    private FileData composeFileDataFromGridFsFileAndItsContent(GridFSFile file, ByteArrayOutputStream bos) {
        FileData fileData = new FileData();
        fileData.setContent(bos.toByteArray());
        this.addMetadataToFileDataIfItExists(file, fileData);
        return fileData;
    }

    private void addMetadataToFileDataIfItExists(GridFSFile file, FileData fileData) {
        Document metadata = file.getMetadata();
        if (Objects.isNull(metadata)) {
            log.debug("Cannot get metadata for file {}", (Object)file);
        } else {
            fileData.setContentType(Optional.ofNullable(metadata.getString((Object)CONTENT_TYPE)).orElse("image/png"));
            fileData.setSource(Strings.nullToEmpty((String)metadata.getString((Object)SNAPSHOT_SOURCE)));
        }
    }

    @Deprecated
    public Optional<FileData> getFileData(UUID logRecordUuid) {
        Document filter = this.getFilter(logRecordUuid);
        return this.getFileDataByFilter(logRecordUuid, filter);
    }

    public Optional<FileData> getFileDataByFileName(UUID logRecordUuid, String filename) {
        Document filter = this.getFilter(logRecordUuid).append(METADATA_SOURCE, (Object)filename);
        return this.getFileDataByFilter(logRecordUuid, filter);
    }

    public void removeAttachment(List<UUID> logRecordsUuidList) {
        logRecordsUuidList.forEach(uuid -> {
            Document filter = new Document().append(METADATA_LOG_RECORD_UUID, uuid);
            GridFSFile res = (GridFSFile)this.gridFsBucket.find((Bson)filter).first();
            if (Objects.nonNull(res)) {
                this.gridFsBucket.delete(res.getObjectId());
            }
        });
    }

    public int getCountScreen(List<LogRecord> logRecords) {
        AtomicInteger countOfScreenshots = new AtomicInteger(0);
        Document filter = new Document();
        logRecords.parallelStream().forEach(logRecord -> {
            filter.append(METADATA_LOG_RECORD_UUID, (Object)logRecord.getUuid());
            GridFSFile res = this.findByFilter(filter);
            if (Objects.nonNull(res)) {
                countOfScreenshots.incrementAndGet();
            }
        });
        return countOfScreenshots.get();
    }

    private Optional<FileData> getFileDataByFilter(UUID logRecordUuid, Document filter) {
        GridFSFile res = (GridFSFile)this.gridFsBucket.find((Bson)filter).first();
        if (Objects.isNull(res)) {
            log.debug("Cannot get file for logRecord {}", (Object)logRecordUuid);
            return Optional.empty();
        }
        FileData fileData = this.createFileDataFromFileInDb(res);
        log.debug("File was found {} for LR {}", (Object)res.getFilename(), (Object)logRecordUuid);
        return Optional.of(fileData);
    }

    private GridFSFile findByFilter(Document filter) {
        return (GridFSFile)this.gridFsBucket.find((Bson)filter).first();
    }

    private Document getFilter(UUID logRecordUuid) {
        return new Document().append(METADATA_LOG_RECORD_UUID, (Object)logRecordUuid);
    }

    private Document getMetadataLogRecordIdsInFilter(List<UUID> logRecordsIds) {
        return new Document().append(METADATA_LOG_RECORD_UUID, (Object)new Document().append("$in", logRecordsIds));
    }

    public String save(String type, String creationTime, String contentType, UUID id, InputStream fileInputStream, String fileName, String snapshotSource) {
        GridFSUploadOptions uploadOptions = new GridFSUploadOptions().chunkSizeBytes(this.chunkSizeBytes).metadata(new Document(TYPE, (Object)type).append(UPLOAD_DATE, (Object)creationTime).append(CONTENT_TYPE, (Object)contentType).append(LOG_RECORD_UUID, (Object)id).append(SNAPSHOT_SOURCE, (Object)snapshotSource));
        return String.valueOf(this.gridFsBucket.uploadFromStream(fileName, fileInputStream, uploadOptions));
    }

    public String save(String type, String creationTime, String contentType, UUID logRecordUuid, UUID testRunId, InputStream fileInputStream, String fileName, String snapshotSource) {
        GridFSUploadOptions uploadOptions = new GridFSUploadOptions().chunkSizeBytes(this.chunkSizeBytes).metadata(new Document(TYPE, (Object)type).append(UPLOAD_DATE, (Object)creationTime).append(CONTENT_TYPE, (Object)contentType).append(LOG_RECORD_UUID, (Object)logRecordUuid).append(TEST_RUN_ID, (Object)testRunId).append(SNAPSHOT_SOURCE, (Object)snapshotSource));
        return String.valueOf(this.gridFsBucket.uploadFromStream(fileName, fileInputStream, uploadOptions));
    }

    public String save(String fileName, String type, String contentType, InputStream fileInputStream, Map<String, Object> metadata) {
        log.debug("Upload file into GridFS with params: fileName='{}', type='{}', contentType='{}', metadata='{}'", new Object[]{fileName, type, contentType, metadata});
        Document document = new Document(TYPE, (Object)type);
        document.append(UPLOAD_DATE, (Object)LocalDateTime.now().toString()).append(CONTENT_TYPE, (Object)contentType);
        metadata.forEach((arg_0, arg_1) -> ((Document)document).append(arg_0, arg_1));
        log.debug("Metadata: {}", metadata);
        GridFSUploadOptions uploadOptions = new GridFSUploadOptions().chunkSizeBytes(this.chunkSizeBytes).metadata(document);
        ObjectId uploadedFileId = this.gridFsBucket.uploadFromStream(fileName, fileInputStream, uploadOptions);
        log.debug("Uploaded file id: {}", (Object)uploadedFileId);
        return String.valueOf(uploadedFileId);
    }

    public GridFsFileData getReportById(UUID reportId) throws FileNotFoundException {
        Document filter = new Document().append(METADATA_REPORT_ID, (Object)reportId);
        GridFSFile reportFile = (GridFSFile)this.gridFsBucket.find((Bson)filter).first();
        if (Objects.isNull(reportFile)) {
            log.error("Failed to find report file in the GridFS by id '{}'", (Object)reportId);
            throw new RamReportGridFsFileNotFoundException();
        }
        ByteArrayOutputStream outputStream = this.downloadFileFromDbToByteStream(reportFile);
        return new GridFsFileData(reportFile.getFilename(), outputStream);
    }

    public void saveMandatoryChecksReport(UUID reportId, UUID executionRequestId, InputStream fileInputStream, String fileName) {
        GridFSUploadOptions uploadOptions = new GridFSUploadOptions().chunkSizeBytes(this.chunkSizeBytes).metadata(new Document(TYPE, (Object)HTML).append(UPLOAD_DATE, (Object)LocalDateTime.now().toString()).append(REPORT_ID, (Object)reportId).append(CONTENT_TYPE, (Object)"text/html").append(EXECUTION_REQUEST_ID, (Object)executionRequestId));
        this.gridFsBucket.uploadFromStream(fileName, fileInputStream, uploadOptions);
    }

    private void deleteByFilter(Document filter) {
        log.debug("deleteByFilter gridFsFiles {}", (Object)filter);
        this.gridFsBucket.find((Bson)filter).forEach(gridFSFile -> {
            try {
                log.debug("delete file gridFSFile.getObjectId()");
                this.gridFsBucket.delete(gridFSFile.getId());
            }
            catch (Exception ex) {
                log.error("Cannot delete file", (Throwable)ex);
            }
        });
    }

    public void deleteByUploadDate(LocalDate checkedDate) {
        log.debug("deleteByUploadDate {}", (Object)checkedDate);
        Document expiredFilesFilter = new Document(UPLOAD_DATE, (Object)new Document("$lte", (Object)checkedDate));
        this.deleteByFilter(expiredFilesFilter);
    }

    public GridFsRepository(GridFSBucket gridFsBucket) {
        this.gridFsBucket = gridFsBucket;
    }
}

