/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.repositories;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.enums.TypeAction;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.models.logrecords.parts.FileType;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface LogRecordRepository
extends MongoRepository<LogRecord, UUID> {
    public LogRecord findByUuid(UUID var1);

    @Query(fields="{'stepContextVariables': 1}")
    public LogRecord findLogRecordWithStepContextByUuid(UUID var1);

    public Stream<LogRecord> findAllByParentRecordIdIsOrderByCreatedDateStampAsc(UUID var1);

    @Query(fields="{'name': 1, 'testingStatus': 1, 'executionStatus': 1, 'parentRecordId': 1, 'message': 1, 'type': 1, 'testRunId':1, 'metaInfo':1}")
    public List<LogRecord> findLogRecordsForTreeByTestRunIdAndParentRecordIdOrderByCreatedDateStampAsc(UUID var1, UUID var2);

    @Query(fields="{'name': 1, 'testingStatus': 1,'isSection': 1,'isCompaund': 1, 'duration': 1, 'executionStatus': 1, 'parentRecordId': 1, 'message': 1, 'type': 1, 'testRunId':1, 'metaInfo':1}")
    public List<LogRecord> findLogRecordsByTestRunIdAndParentRecordIdOrderByCreatedDateStampAsc(UUID var1, UUID var2);

    @Query(fields="{'name': 1, 'testingStatus': 1, 'executionStatus': 1, 'parentRecordId': 1, 'message': 1, 'type': 1, 'testRunId':1, 'metaInfo':1}")
    public LogRecord findLogRecordForTreeByUuid(UUID var1);

    @Query(fields="{'uuid': 1, 'testingStatus': 1, 'type': 1, 'testRunId': 1, 'name': 1, 'message': 1, 'parentRecordId': 1, 'duration': 1, 'isSection': 1, 'isCompaund': 1}")
    public List<LogRecord> findLogRecordsWithSpecificFieldsByTestRunIdOrderByStartDateAsc(UUID var1);

    @Query(fields="{'uuid': 1, 'testingStatus': 1, 'type': 1, 'preview': 1}")
    public Stream<LogRecord> findLogRecordsWithPreviewByTestRunIdOrderByStartDateAsc(UUID var1);

    public List<LogRecord> findAllByTestRunIdOrderByStartDateAsc(UUID var1);

    @Query(fields="{'name': 1}")
    public List<LogRecord> findAllNameByTestRunId(UUID var1);

    @Query(fields="{'uuid': 1}")
    public List<LogRecord> findAllUuidByTestRunId(UUID var1);

    @Query(fields="{'uuid': 1, 'startDate': 1, 'endDate': 1}")
    public LogRecord findFirstByTestRunIdAndExecutionStatusOrderByCreatedDateStampDesc(UUID var1, ExecutionStatuses var2);

    @Query(fields="{'testingStatus': 1}")
    public List<LogRecord> findAllTestingStatusByTestRunId(UUID var1);

    public Long countAllByParentRecordIdIs(UUID var1);

    public List<LogRecord> findAllByTestRunIdAndIsSectionAndIsCompaund(UUID var1, boolean var2, boolean var3);

    public List<LogRecord> findAllByTestRunIdAndIsSection(UUID var1, boolean var2);

    public List<LogRecord> findAllByTestRunIdAndTestingStatus(UUID var1, TestingStatuses var2);

    @Query(fields="{'uuid': 1, 'message': 1, 'testRunId': 1}")
    public List<LogRecord> findUuidAndMessageByTestRunIdAndTestingStatus(UUID var1, TestingStatuses var2);

    public List<LogRecord> findAllByTestRunIdIn(List<UUID> var1);

    public List<LogRecord> findAllByTestRunIdAndNameContains(UUID var1, String var2);

    public Stream<LogRecord> findAllByTestRunIdAndNameRegex(UUID var1, String var2);

    public List<LogRecord> findAllByParentRecordIdOrderByStartDateAsc(UUID var1);

    public List<LogRecord> findAllByTestRunIdAndType(UUID var1, TypeAction var2);

    @Query(fields="{'uuid': 1, 'name':1}")
    public List<LogRecord> findAllByTestingStatusAndTestRunId(TestingStatuses var1, UUID var2);

    public List<LogRecord> findAllByParentRecordIdAndNameContains(UUID var1, String var2);

    @Query(fields="{'uuid': 1, 'testRunId': 1, 'testingStatus': 1, 'executionStatus': 1}")
    public List<LogRecord> findAllByLastUpdatedAfterAndTestRunIdIn(Date var1, List<UUID> var2);

    public List<LogRecord> findAllByTestRunId(UUID var1);

    @Query(fields="{'testRunId': 1, 'validationLabels': 1, 'validationTable': 1, 'testingStatus': 1}")
    public List<LogRecord> findLogRecordsWithValidationParamsByTestRunId(UUID var1);

    @Query(value="{'testRunId': {$in: ?0}, 'metaInfo': {$exists: true}, 'testingStatus': ?1}", fields="{'uuid': 1, 'name': 1, 'testRunId': 1, 'testingStatus': 1, 'parentRecordId': 1}")
    public List<LogRecord> findLogRecordsWithMetaInfoByTestRunIdInAndTestingStatus(Collection<UUID> var1, TestingStatuses var2);

    @Query(value="{'testRunId': {$in: ?0}, $or: [{'validationLabels': {$exists: true, $not: {$size: 0}}},{'validationTable.steps.validationLabels': {$exists: true, $not: {$size: 0}}},{'testingStatus': 'FAILED'}]}", fields="{'uuid': 1, 'name': 1, 'testRunId': 1, 'validationLabels': 1, 'validationTable': 1, 'testingStatus': 1, 'parentRecordId': 1, 'metaInfo': 1}")
    public Stream<LogRecord> findLogRecordsWithValidationParamsAndFailureByTestRunIds(Collection<UUID> var1);

    public void deleteByUuid(UUID var1);

    public void deleteAllByUuidIn(List<UUID> var1);

    @Query(fields="{'fileMetadata': 1, 'uuid': 1, 'testRunId': 1}", value="{testRunId: {$in: ?0}, 'fileMetadata.type': ?1}")
    public List<LogRecord> findLogRecordsForArchivePotFileByTestRunIdIn(List<UUID> var1, FileType var2);

    @Query(fields="{'uuid': 1, 'testRunId': 1}", value="{testRunId: {$in: ?0}, 'fileMetadata.type': ?1}")
    public List<LogRecord> findFileLogRecordsByTestRunIdInAndFileType(List<UUID> var1, FileType var2);

    @Query(fields="{'name': 1, 'testingStatus': 1}")
    public List<LogRecord> findLogRecordsByUuidIn(Set<UUID> var1);

    public Long countAllByTestRunIdIn(Set<UUID> var1);

    public Long countAllByTestRunIdInAndTestingStatus(Collection<UUID> var1, TestingStatuses var2);

    public Stream<LogRecord> findAllByTestRunIdInAndTestingStatus(Collection<UUID> var1, TestingStatuses var2);

    public Stream<LogRecord> findAllByUuidNotInAndTestRunIdInAndTestingStatus(Collection<UUID> var1, Collection<UUID> var2, TestingStatuses var3);
}

