/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.repositories;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.models.EnrichedTestRun;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.models.response.TestRunsRatesResponse;
import org.qubership.atp.ram.repositories.CustomTestRunRepository;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface TestRunRepository
extends CustomTestRunRepository,
MongoRepository<TestRun, UUID> {
    public TestRun findByUuid(UUID var1);

    public TestRun findFirstByTestCaseIdOrderByStartDateDesc(UUID var1);

    public List<TestRun> findAllByTestCaseIdOrderByStartDateDesc(UUID var1);

    @Query(fields="{'uuid': 1, 'finishDate': 1, 'startDate': 1}")
    public List<TestRun> findAllByExecutionStatusOrderByStartDateDesc(ExecutionStatuses var1);

    @Query(fields="{'uuid': 1, 'finishDate': 1, 'startDate': 1}")
    public List<TestRun> findAllByExecutionStatusIn(List<ExecutionStatuses> var1);

    public void deleteByUuid(UUID var1);

    public List<TestRun> findAllByExecutionRequestId(UUID var1);

    @Query(fields="{'uuid': 1, 'rootCauseId': 1}")
    public List<TestRun> findAllTestRunRootCausesByExecutionRequestId(UUID var1);

    @Query(fields="{uuid: 1, testCaseId: 1}")
    public List<TestRun> findTestCaseIdByExecutionRequestId(UUID var1);

    @Query(value="{executionRequestId: ?0, name: {$ne: ?1}}", fields="{'rootCauseId': 1, 'testingStatus': 1}")
    public List<TestRun> findRootCauseIdTestingStatusByExecutionRequestIdAndNameNot(UUID var1, String var2);

    @Query(value="{executionRequestId: ?0, name: {$ne: ?1}}")
    public List<TestRun> findAllByExecutionRequestIdAndNameNot(UUID var1, String var2);

    public void deleteAllByUuidIn(List<UUID> var1);

    public List<TestRun> findAllByExecutionRequestIdIn(List<UUID> var1);

    public Long countAllByExecutionRequestIdAndExecutionStatusIn(UUID var1, List<ExecutionStatuses> var2);

    @Query(fields="{'finishDate': 1}")
    public TestRun findFinishDateByExecutionRequestIdAndFinishDateIsNotNullOrderByFinishDateDesc(UUID var1);

    @Query(fields="{'testCaseName': 1}")
    public List<TestRun> findAllTestCasesNamesByExecutionRequestIdIn(List<UUID> var1);

    public TestRun findByExecutionRequestIdAndName(UUID var1, String var2);

    public List<TestRun> findAllByExecutionRequestIdAndTestingStatusIsNotNull(UUID var1);

    public List<TestRun> findAllByExecutionRequestIdAndExecutionStatusIn(UUID var1, List<ExecutionStatuses> var2);

    @Query(value="{executionRequestId: ?0, testingStatus: {$ne: ?1}}")
    public List<TestRun> findByExecutionRequestIdAndTestingStatus(UUID var1, TestingStatuses var2);

    public List<TestRun> findAllByExecutionRequestIdAndNameContains(UUID var1, String var2);

    @Query(fields="{'name': 1, 'parentTestRunId': 1}")
    public TestRun findNameParentIdByUuid(UUID var1);

    @Query(fields="{'uuid': 1, executionRequestId: 1, order: 1}")
    public List<TestRun> findAllByUuidInAndExecutionStatusIn(List<UUID> var1, List<ExecutionStatuses> var2);

    public Long countAllByTestingStatusAndParentTestRunId(TestingStatuses var1, UUID var2);

    public Long countAllByParentTestRunId(UUID var1);

    public List<TestRun> findAllByParentTestRunId(UUID var1);

    @Query(fields="{'uuid': 1, 'name': 1, 'testingStatus': 1}")
    public List<TestRun> findAllByExecutionRequestIdAndIsGroupedTestRun(UUID var1, boolean var2);

    public List<TestRun> findAllByUuidIn(Collection<UUID> var1);

    @Query(fields="{'uuid': 1, 'name': 1, 'testingStatus': 1, 'executionStatus': 1}")
    public List<TestRun> findShortTestRunsByUuidIn(Collection<UUID> var1);

    public List<TestRun> findAllByExecutionRequestIdOrderByStartDateAsc(UUID var1);

    @Query(fields="{'passedRate': 1, 'warningRate': 1, 'failedRate': 1, 'testingStatus': 1}")
    public List<TestRun> findAllRatesByUuidIn(Collection<UUID> var1);

    public Long countAllByExecutionRequestId(UUID var1);

    @Query(fields="{'name': 1, 'uuid': 1, 'testingStatus': 1, 'passedRate': 1, 'duration': 1, 'dataSetUrl': 1, 'rootCauseId': 1, 'testCaseId': 1, 'dataSetListUrl': 1, 'jiraTicket': 1}")
    public List<TestRun> findTestRunForReportByUuidIn(Set<UUID> var1);

    @Query(fields="{'name': 1, 'uuid': 1, 'testingStatus': 1, 'passedRate': 1, 'duration': 1, 'dataSetUrl': 1, 'dataSetListUrl': 1, 'rootCauseId': 1, 'testCaseId':1, 'dataSetListUrl': 1, 'jiraTicket': 1}")
    public List<TestRun> findTestRunForReportByExecutionRequestId(UUID var1);

    @Query(fields="{'name': 1, 'uuid': 1, 'testingStatus': 1, 'fdrWasSent': 1, 'executionStatus': 1}")
    public List<TestRun> findTestRunsForFdrByExecutionRequestId(UUID var1);

    @Query(fields="{'testingStatus': 1, 'urlToBrowserSession': 1, 'executionStatus': 1, 'testCaseId': 1, 'initialTestRunId': 1, 'labelIds': 1}")
    public List<TestRun> findTestRunForExecutionSummaryByExecutionRequestId(UUID var1);

    @Query(fields="{'uuid': 1, 'testingStatus': 1}")
    public List<TestRun> findTestRunsUuidAndTestingStatusByExecutionRequestId(UUID var1);

    @Query(fields="{'uuid': 1}")
    public List<TestRun> findTestRunsUuidByExecutionRequestId(UUID var1);

    @Query(fields="{'executionStatus': 1, 'name': 1, 'passedRate': 1, 'reportLabelParams': 1, 'testingStatus': 1}")
    public TestRun findTestRunForTreeNodeByUuid(UUID var1);

    @Query(fields="{'executionRequestId': 1}")
    public TestRun findTestRunExecReqIdByUuid(UUID var1);

    public List<TestRun> findAllByRootCauseId(UUID var1);

    @Query(fields="{'executionRequestId': 1, 'testingStatus': 1}")
    public TestRun findTestRunExecReqIdAndTestStatusByUuid(UUID var1);

    @Query(fields="{'uuid': 1}")
    public List<TestRun> findTestRunsIdByExecutionRequestIdAndTestingStatus(UUID var1, TestingStatuses var2);

    @Query(fields="{'uuid':1}")
    public List<TestRun> findTestRunsByExecutionRequestIdAndTestingStatusIn(UUID var1, List<TestingStatuses> var2);

    @Query(fields="{'uuid': 1, 'executionRequestId': 1}")
    public List<TestRun> findTestRunsUuidErIdByTestingStatusAndUuidIn(TestingStatuses var1, List<UUID> var2);

    @Query(fields="{'uuid': 1, 'executionRequestId': 1}")
    public List<TestRun> findTestRunsUuidErIdByTestingStatusInAndUuidIn(List<TestingStatuses> var1, List<UUID> var2);

    @Query(fields="{'uuid': 1, 'testingStatus': 1, 'name': 1}")
    public List<TestRun> findTestRunsIdNameTestingStatusByExecutionRequestId(UUID var1);

    @Query(fields="{'uuid': 1, 'name': 1}")
    public List<TestRun> findTestRunsIdNameByExecutionRequestId(UUID var1);

    public List<EnrichedTestRun> findAllEnrichedTestRunsByExecutionRequestId(UUID var1);

    public List<TestRunsRatesResponse> findTestRunsRatesResponseByExecutionRequestId(UUID var1);

    @Query(fields="{'uuid': 1}")
    public List<TestRun> findTestRunsIdByExecutionRequestId(UUID var1);

    @Query(value="{'executionRequestId': ?0, 'numberOfScreens': {$exists: true}}")
    public List<TestRun> findTestRunsByExecutionRequestId(UUID var1);

    @Query(fields="{'executionRequestId': 1}")
    public TestRun findFirstByTestCaseId(UUID var1);

    @Query(fields="{'executionRequestId': 1}")
    public List<TestRun> findErByUuidIn(List<UUID> var1);
}

