/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.repositories.impl;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.qubership.atp.ram.models.EnvironmentsInfo;
import org.qubership.atp.ram.repositories.CustomEnvironmentsInfoRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.stereotype.Repository;

@Repository
public class CustomEnvironmentsInfoRepositoryImpl
implements CustomEnvironmentsInfoRepository {
    private static final Logger log = LoggerFactory.getLogger(CustomEnvironmentsInfoRepositoryImpl.class);
    private final MongoTemplate mongoTemplate;
    private static final String ENVIRONMENTS_INFO_COLLECTION_NAME = EnvironmentsInfo.class.getAnnotation(Document.class).collection();

    @Override
    public List<EnvironmentsInfo> findByExecutionRequestIdInForErTestResult(Set<UUID> requestIds) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)new Criteria("executionRequestId").in(requestIds)), Aggregation.project((String[])new String[]{"environmentId", "name", "executionRequestId", "qaSystemInfoList", "taSystemInfoList"}).andExclude(new String[]{"_id"})});
        AggregationResults res = this.mongoTemplate.aggregate(aggregation, ENVIRONMENTS_INFO_COLLECTION_NAME, EnvironmentsInfo.class);
        return res.getMappedResults();
    }

    public CustomEnvironmentsInfoRepositoryImpl(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }
}

