/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.repositories.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.ram.dto.response.BaseEntityResponse;
import org.qubership.atp.ram.dto.response.PaginationResponse;
import org.qubership.atp.ram.models.DefectPriority;
import org.qubership.atp.ram.models.FailPattern;
import org.qubership.atp.ram.models.FailPatternSearchRequest;
import org.qubership.atp.ram.models.PaginationSearchRequest;
import org.qubership.atp.ram.models.RootCause;
import org.qubership.atp.ram.models.RootCauseType;
import org.qubership.atp.ram.repositories.CustomFailPatternRepository;
import org.qubership.atp.ram.repositories.impl.GenericEntitySearchComponent;
import org.qubership.atp.ram.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.ArrayOperators;
import org.springframework.data.mongodb.core.aggregation.ComparisonOperators;
import org.springframework.data.mongodb.core.aggregation.ConditionalOperators;
import org.springframework.data.mongodb.core.aggregation.StringOperators;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class CustomFailPatternRepositoryImpl
implements CustomFailPatternRepository {
    private static final Logger log = LoggerFactory.getLogger(CustomFailPatternRepositoryImpl.class);
    private static final String FAIL_PATTERN_COLLECTION_NAME = FailPattern.class.getAnnotation(Document.class).collection();
    private static final String ROOT_CAUSE_COLLECTION_NAME = RootCause.class.getAnnotation(Document.class).collection();
    public static final String NAME = "name";
    public static final String PRIORITY = "priority";
    public static final String MESSAGE = "message";
    public static final String JIRA_TICKETS = "jiraTickets";
    public static final String $JIRA_TICKETS = "$jiraTickets";
    public static final String DISTINCT_JIRA_TICKETS = "distinctTickets";
    public static final String $DISTINCT_JIRA_TICKETS = "$distinctTickets";
    public static final String PROJECT_ID = "projectId";
    public static final String FAIL_REASON_ID = "failReasonId";
    public static final String TYPE = "type";
    private final MongoTemplate mongoTemplate;
    private final GenericEntitySearchComponent searchComponent;

    @Override
    public PaginationResponse<FailPattern> findAllFailPatterns(FailPatternSearchRequest request, Pageable pageable) {
        Set failReasonIds;
        Set projectIds;
        Set issues;
        String message;
        Set priorities;
        log.info("Search fail patterns by request: {}", (Object)request);
        ArrayList<AggregationOperation> aggregation = new ArrayList<AggregationOperation>();
        ArrayList<Criteria> criteria = new ArrayList<Criteria>();
        Set names = request.getNames();
        if (CollectionUtils.isNotEmpty((Collection)names)) {
            criteria.add(this.searchComponent.namesRegexIgnoreCase(NAME, names));
        }
        if (CollectionUtils.isNotEmpty((Collection)(priorities = request.getPriorities()))) {
            criteria.add(this.searchComponent.foundInArrayStrings(PRIORITY, StreamUtils.toUpperCase(priorities)));
        }
        if (StringUtils.isNotEmpty((String)(message = request.getMessage()))) {
            criteria.add(this.searchComponent.namesRegexIgnoreCase(MESSAGE, message));
        }
        if (CollectionUtils.isNotEmpty((Collection)(issues = request.getIssues()))) {
            criteria.add(this.searchComponent.foundInArrayStrings(JIRA_TICKETS, issues));
        }
        if (CollectionUtils.isNotEmpty((Collection)(projectIds = request.getProjects()))) {
            criteria.add(this.searchComponent.foundInArrayIds(PROJECT_ID, projectIds));
        }
        if (CollectionUtils.isNotEmpty((Collection)(failReasonIds = request.getFailReasons()))) {
            criteria.add(this.searchComponent.foundInArrayIds(FAIL_REASON_ID, failReasonIds));
        }
        log.debug("Criteria for search fail patterns: {}", criteria);
        aggregation.add((AggregationOperation)(criteria.isEmpty() ? Aggregation.match((Criteria)new Criteria()) : Aggregation.match((Criteria)new Criteria().andOperator(criteria.toArray(new Criteria[0])))));
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)new Criteria().andOperator(criteria.toArray(new Criteria[0])));
        this.addSortOperations(aggregation, pageable.getSort());
        this.addPaginationOperations(aggregation, pageable);
        long count = this.mongoTemplate.count(query, FailPattern.class);
        log.debug("Count of fail patterns: {}", (Object)count);
        log.debug("Aggregation for search fail patterns: {}", aggregation);
        List failPatterns = this.mongoTemplate.aggregate(Aggregation.newAggregation(aggregation), FAIL_PATTERN_COLLECTION_NAME, FailPattern.class).getMappedResults();
        log.debug("Found fail patterns: {}", StreamUtils.extractIds(failPatterns));
        return new PaginationResponse(failPatterns, count);
    }

    @Override
    public PaginationResponse getAllIssuesWithPagination(PaginationSearchRequest request) {
        String name;
        log.info("Search all issues by request: {}", (Object)request);
        ArrayList<AggregationOperation> aggregation = new ArrayList<AggregationOperation>();
        ArrayList criteria = new ArrayList();
        Set projectIds = request.getProjects();
        if (CollectionUtils.isNotEmpty((Collection)projectIds)) {
            aggregation.add((AggregationOperation)Aggregation.match((Criteria)this.searchComponent.foundInArrayIds(PROJECT_ID, projectIds)));
        }
        if (StringUtils.isNotEmpty((String)(name = request.getName()))) {
            aggregation.add((AggregationOperation)Aggregation.match((Criteria)this.searchComponent.namesRegexIgnoreCase(JIRA_TICKETS, name)));
        }
        aggregation.add((AggregationOperation)Aggregation.unwind((String)$JIRA_TICKETS));
        aggregation.add((AggregationOperation)Aggregation.group((String[])new String[0]).addToSet(JIRA_TICKETS).as(DISTINCT_JIRA_TICKETS));
        aggregation.add((AggregationOperation)Aggregation.unwind((String)DISTINCT_JIRA_TICKETS));
        Sort.Direction direction = Objects.nonNull(request.getDirection()) ? request.getDirection() : Sort.Direction.ASC;
        aggregation.add((AggregationOperation)Aggregation.sort((Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{DISTINCT_JIRA_TICKETS})));
        aggregation.add((AggregationOperation)Aggregation.project((String[])new String[0]).and($DISTINCT_JIRA_TICKETS).as(NAME));
        this.addPaginationOperations(aggregation, request);
        log.debug("Aggregation for search all issues: {}", aggregation);
        List issues = this.mongoTemplate.aggregate(Aggregation.newAggregation(aggregation), FAIL_PATTERN_COLLECTION_NAME, BaseEntityResponse.class).getMappedResults();
        int totalCount = this.getTotalCount(aggregation, FAIL_PATTERN_COLLECTION_NAME);
        boolean isLastPage = this.isLastPage(request, issues.size(), totalCount);
        return new PaginationResponse(issues, (long)totalCount, Boolean.valueOf(isLastPage));
    }

    @Override
    public PaginationResponse getAllFailReasonsWithPagination(PaginationSearchRequest request) {
        String name;
        log.info("Search all fail reasons by request: {}", (Object)request);
        ArrayList<AggregationOperation> aggregation = new ArrayList<AggregationOperation>();
        ArrayList criteria = new ArrayList();
        Set projectIds = request.getProjects();
        if (CollectionUtils.isNotEmpty((Collection)projectIds)) {
            aggregation.add((AggregationOperation)Aggregation.match((Criteria)new Criteria().orOperator(new Criteria[]{this.searchComponent.foundInArrayIds(PROJECT_ID, projectIds), Criteria.where((String)TYPE).is((Object)RootCauseType.GLOBAL.name())})));
        }
        if (StringUtils.isNotEmpty((String)(name = request.getName()))) {
            aggregation.add((AggregationOperation)Aggregation.match((Criteria)this.searchComponent.namesRegexIgnoreCase(NAME, name)));
        }
        Sort.Direction direction = Objects.nonNull(request.getDirection()) ? request.getDirection() : Sort.Direction.ASC;
        aggregation.add((AggregationOperation)Aggregation.sort((Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{NAME})));
        this.addPaginationOperations(aggregation, request);
        log.debug("Aggregation for search all fail reasons: {}", aggregation);
        List failPatterns = this.mongoTemplate.aggregate(Aggregation.newAggregation(aggregation), ROOT_CAUSE_COLLECTION_NAME, BaseEntityResponse.class).getMappedResults();
        int totalCount = this.getTotalCount(aggregation, ROOT_CAUSE_COLLECTION_NAME);
        boolean isLastPage = this.isLastPage(request, failPatterns.size(), totalCount);
        return new PaginationResponse(failPatterns, (long)totalCount, Boolean.valueOf(isLastPage));
    }

    private boolean isLastPage(PaginationSearchRequest request, int filteredCount, int totalCount) {
        return request.getPage() * request.getSize() + filteredCount >= totalCount;
    }

    private void addPaginationOperations(List<AggregationOperation> aggregation, Pageable pageable) {
        this.addPaginationOperations(aggregation, pageable.getPageNumber(), pageable.getPageSize());
    }

    private void addPaginationOperations(List<AggregationOperation> aggregation, PaginationSearchRequest request) {
        this.addPaginationOperations(aggregation, request.getPage(), request.getSize());
    }

    private void addPaginationOperations(List<AggregationOperation> aggregation, int pageNumber, int pageSize) {
        aggregation.add((AggregationOperation)Aggregation.skip((int)(pageNumber * pageSize)));
        aggregation.add((AggregationOperation)Aggregation.limit((long)pageSize));
    }

    private int getTotalCount(List<AggregationOperation> aggregation, String collectionName) {
        ArrayList<AggregationOperation> copy = new ArrayList<AggregationOperation>(aggregation);
        copy.add((AggregationOperation)Aggregation.count().as("totalCount"));
        Map result = (Map)this.mongoTemplate.aggregate(Aggregation.newAggregation(copy), collectionName, Map.class).getUniqueMappedResult();
        return (Integer)result.get("totalCount");
    }

    private void addSortOperations(List<AggregationOperation> aggregation, Sort sort) {
        boolean isSorted = sort.isSorted();
        log.debug("Is sorted: {}", (Object)isSorted);
        if (isSorted) {
            sort.get().findFirst().ifPresent(order -> {
                String sortingProperty = order.getProperty();
                log.debug("Sorting by: {}", (Object)sortingProperty);
                switch (sortingProperty) {
                    case "priority": {
                        log.debug("Sorting by priority");
                        List caseOperators = DefectPriority.getAll().stream().map(priority -> ConditionalOperators.Switch.CaseOperator.when((AggregationExpression)ComparisonOperators.Eq.valueOf((String)PRIORITY).equalToValue((Object)priority.name())).then((Object)priority.getId())).collect(Collectors.toList());
                        aggregation.add((AggregationOperation)Aggregation.addFields().addFieldWithValue("priorityNumberValue", (Object)ConditionalOperators.Switch.switchCases(caseOperators).defaultTo((Object)-1)).build());
                        sortingProperty = "priorityNumberValue";
                        break;
                    }
                    case "issue": {
                        log.debug("Sorting by issue");
                        aggregation.add((AggregationOperation)Aggregation.addFields().addFieldWithValue("firstJiraTicket", (Object)ArrayOperators.ArrayElemAt.arrayOf((String)JIRA_TICKETS).elementAt(0)).build());
                        aggregation.add((AggregationOperation)Aggregation.addFields().addFieldWithValue("firstJiraTicket", (Object)ArrayOperators.ArrayElemAt.arrayOf((AggregationExpression)StringOperators.Split.valueOf((String)"$firstJiraTicket").split("/")).elementAt(-1)).build());
                        sortingProperty = "firstJiraTicket";
                        break;
                    }
                    case "project": {
                        log.debug("Sorting by project");
                        aggregation.add((AggregationOperation)Aggregation.lookup((String)"projects", (String)PROJECT_ID, (String)"_id", (String)"projectInfo"));
                        sortingProperty = "projectInfo.name";
                        break;
                    }
                    case "failReason": {
                        log.debug("Sorting by fail reason");
                        aggregation.add((AggregationOperation)Aggregation.lookup((String)"rootCause", (String)FAIL_REASON_ID, (String)"_id", (String)"failReasonInfo"));
                        sortingProperty = "failReasonInfo.name";
                        break;
                    }
                    case "name": 
                    case "message": 
                    case "rule": 
                    case "patternDescription": {
                        log.debug("Skip custom sorting by string property: {}", (Object)sortingProperty);
                        break;
                    }
                    default: {
                        log.warn("Unknown sorting property: {}", (Object)sortingProperty);
                    }
                }
                Sort.Direction direction = order.getDirection();
                log.debug("Sorting direction: {}", (Object)direction);
                aggregation.add((AggregationOperation)Aggregation.sort((Sort)Sort.by((Sort.Direction)direction, (String[])new String[]{sortingProperty})));
            });
        }
    }

    public CustomFailPatternRepositoryImpl(MongoTemplate mongoTemplate, GenericEntitySearchComponent searchComponent) {
        this.mongoTemplate = mongoTemplate;
        this.searchComponent = searchComponent;
    }
}

