/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.repositories.impl;

import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.qubership.atp.ram.model.JaversCountResponse;
import org.qubership.atp.ram.model.JaversIdsResponse;
import org.qubership.atp.ram.repositories.JaversSnapshotRepository;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository
public class JaversSnapshotRepositoryImpl
implements JaversSnapshotRepository {
    private final MongoTemplate mongoTemplate;
    private static final String JV_SNAPSHOT_COLLECTION_NAME = "jv_snapshots";
    private static final String SEPARATOR = ".";
    private static final String LINK = "$";
    private static final String ID = "_id";
    private static final String GLOBAL_ID = "globalId";
    private static final String CDO_ID = "cdoId";
    private static final String VERSION = "version";
    private static final String DELETE = "delete";
    private static final String VERSIONS = "versions";
    private static final String TYPE = "type";
    private static final String INITIAL_VALUE = "INITIAL";
    private static final String TERMINAL_VALUE = "TERMINAL";
    private static final String LINK_ID = "$_id";
    private static final String GLOBAL_ID_CDO_ID = "globalId.cdoId";
    private static final String LINK_GLOBAL_ID_CDO_ID = "$globalId.cdoId";
    private static final String LINK_VERSION = "$version";

    @Override
    public List<JaversCountResponse> findCdoIdAndCount(List<String> listOfCdoId) {
        MatchOperation matchOperation = Aggregation.match((Criteria)Criteria.where((String)GLOBAL_ID_CDO_ID).in(listOfCdoId));
        GroupOperation groupOperation = Aggregation.group((String[])new String[]{LINK_GLOBAL_ID_CDO_ID}).addToSet(LINK_VERSION).as(VERSION);
        ProjectionOperation projectionOperation = Aggregation.project((String[])new String[0]).and(LINK_ID).as(CDO_ID).and(LINK_VERSION).as(VERSIONS).andExclude(new String[]{ID});
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{matchOperation, groupOperation, projectionOperation});
        AggregationResults aggregationResults = this.mongoTemplate.aggregate(aggregation, JV_SNAPSHOT_COLLECTION_NAME, JaversCountResponse.class);
        return aggregationResults.getMappedResults();
    }

    @Override
    public Stream<JaversIdsResponse> findAllCdoIds() {
        GroupOperation groupOperation = Aggregation.group((String[])new String[]{LINK_GLOBAL_ID_CDO_ID});
        ProjectionOperation projectionOperation = Aggregation.project((String[])new String[0]).and(LINK_ID).as(CDO_ID).andExclude(new String[]{ID});
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{groupOperation, projectionOperation});
        Iterable iterable = () -> this.mongoTemplate.aggregateStream(aggregation, JV_SNAPSHOT_COLLECTION_NAME, JaversIdsResponse.class);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    @Override
    public void deleteByCdoIdAndVersions(String cdoId, List<Long> versions) {
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)GLOBAL_ID_CDO_ID).is((Object)cdoId)).addCriteria((CriteriaDefinition)Criteria.where((String)VERSION).in(versions));
        this.mongoTemplate.remove(query, JV_SNAPSHOT_COLLECTION_NAME);
    }

    @Override
    public void updateAsInitial(String cdoId, Long version) {
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)GLOBAL_ID_CDO_ID).is((Object)cdoId)).addCriteria((CriteriaDefinition)Criteria.where((String)VERSION).is((Object)version));
        Update update = new Update().set(TYPE, (Object)INITIAL_VALUE);
        this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, JV_SNAPSHOT_COLLECTION_NAME);
    }

    @Override
    public List<JaversIdsResponse> findTerminatedSnapshots() {
        MatchOperation matchOperation = Aggregation.match((Criteria)Criteria.where((String)TYPE).is((Object)TERMINAL_VALUE));
        ProjectionOperation projectionOperation = Aggregation.project((String[])new String[0]).and(LINK_GLOBAL_ID_CDO_ID).as(CDO_ID).andExclude(new String[]{ID});
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{matchOperation, projectionOperation});
        AggregationResults aggregationResults = this.mongoTemplate.aggregate(aggregation, JV_SNAPSHOT_COLLECTION_NAME, JaversIdsResponse.class);
        return aggregationResults.getMappedResults();
    }

    @Override
    public void deleteByCdoIds(List<String> cdoIds) {
        Query query = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)GLOBAL_ID_CDO_ID).in(cdoIds));
        this.mongoTemplate.remove(query, JV_SNAPSHOT_COLLECTION_NAME);
    }

    public JaversSnapshotRepositoryImpl(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }
}

