/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.repositories.operations;

import java.util.ArrayList;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationPipeline;

public class CustomLookupOperation
implements AggregationOperation {
    private final String from;
    private final Document let;
    private final AggregationPipeline pipeline;
    private final String as;

    public Document toDocument(AggregationOperationContext context) {
        Document lookupObject = new Document();
        lookupObject.append("from", (Object)this.from);
        lookupObject.append("let", (Object)this.let);
        ArrayList<Document> pipelineDocument = new ArrayList<Document>();
        for (AggregationOperation operation : this.pipeline.getOperations()) {
            pipelineDocument.add(operation.toDocument(context));
        }
        lookupObject.append("pipeline", pipelineDocument);
        lookupObject.append("as", (Object)this.as);
        return new Document(this.getOperator(), (Object)lookupObject);
    }

    public String getOperator() {
        return "$lookup";
    }

    public String getFrom() {
        return this.from;
    }

    public Document getLet() {
        return this.let;
    }

    public AggregationPipeline getPipeline() {
        return this.pipeline;
    }

    public String getAs() {
        return this.as;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomLookupOperation)) {
            return false;
        }
        CustomLookupOperation other = (CustomLookupOperation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        Document this$let = this.getLet();
        Document other$let = other.getLet();
        if (this$let == null ? other$let != null : !this$let.equals(other$let)) {
            return false;
        }
        AggregationPipeline this$pipeline = this.getPipeline();
        AggregationPipeline other$pipeline = other.getPipeline();
        if (this$pipeline == null ? other$pipeline != null : !this$pipeline.equals(other$pipeline)) {
            return false;
        }
        String this$as = this.getAs();
        String other$as = other.getAs();
        return !(this$as == null ? other$as != null : !this$as.equals(other$as));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CustomLookupOperation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        Document $let = this.getLet();
        result = result * 59 + ($let == null ? 43 : $let.hashCode());
        AggregationPipeline $pipeline = this.getPipeline();
        result = result * 59 + ($pipeline == null ? 43 : $pipeline.hashCode());
        String $as = this.getAs();
        result = result * 59 + ($as == null ? 43 : $as.hashCode());
        return result;
    }

    public String toString() {
        return "CustomLookupOperation(from=" + this.getFrom() + ", let=" + this.getLet() + ", pipeline=" + this.getPipeline() + ", as=" + this.getAs() + ")";
    }

    public CustomLookupOperation(String from, Document let, AggregationPipeline pipeline, String as) {
        this.from = from;
        this.let = let;
        this.pipeline = pipeline;
        this.as = as;
    }
}

