/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.sql.Timestamp;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpIllegalNullableArgumentException;
import org.qubership.atp.ram.dto.response.PaginationResponse;
import org.qubership.atp.ram.models.BrowserConsoleLog;
import org.qubership.atp.ram.models.BrowserConsoleLogsTable;
import org.qubership.atp.ram.repositories.BrowserConsoleLogRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class BrowserConsoleLogService {
    private static final Logger log = LoggerFactory.getLogger(BrowserConsoleLogService.class);
    private final BrowserConsoleLogRepository repository;

    public PaginationResponse<BrowserConsoleLogsTable> getBrowserConsoleLogsTable(UUID logRecordId, Pageable pageable) {
        if (Objects.isNull(logRecordId)) {
            log.error("Found illegal nullable log record id");
            throw new AtpIllegalNullableArgumentException("log record id", "method parameter");
        }
        return this.repository.findBrowserConsoleLogsByLogRecordIdWithPagination(logRecordId, pageable);
    }

    public void createBrowserConsoleLog(UUID logRecordId, List<BrowserConsoleLogsTable> logs) {
        if (Objects.isNull(logRecordId)) {
            log.error("Found illegal nullable log record id");
            throw new AtpIllegalNullableArgumentException("log record id", "method parameter");
        }
        log.info("Create browser console logs for log record '{}'.", (Object)logRecordId);
        BrowserConsoleLog browserConsoleLog = this.repository.findBrowserConsoleLogByLogRecordId(logRecordId).orElse(new BrowserConsoleLog(UUID.randomUUID(), logRecordId, new Timestamp(System.currentTimeMillis()), null));
        browserConsoleLog.setBrowserConsoleLogsTable(logs);
        log.debug("Create browser console logs for log record '{}' with logs [{}]", (Object)logRecordId, logs);
        this.repository.save(browserConsoleLog);
    }

    public boolean isBrowserConsoleLogsPresent(UUID logRecordUuid) {
        return this.repository.existsByLogRecordId(logRecordUuid);
    }

    public BrowserConsoleLogService(BrowserConsoleLogRepository repository) {
        this.repository = repository;
    }
}

