/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ram.dto.response.Environment;
import org.qubership.atp.ram.enums.TestScopeSections;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.enums.TypeAction;
import org.qubership.atp.ram.model.BaseSearchRequest;
import org.qubership.atp.ram.model.CompareItem;
import org.qubership.atp.ram.model.CompareTestRunsDetailsCell;
import org.qubership.atp.ram.model.CompareTestRunsDetailsRow;
import org.qubership.atp.ram.model.DefectStatisticExecutionRequestResponse;
import org.qubership.atp.ram.model.DefectStatisticResponse;
import org.qubership.atp.ram.model.EnvironmentDetailsCompareResponse;
import org.qubership.atp.ram.model.ExecutionRequestsCompareScreenshotResponse;
import org.qubership.atp.ram.model.LogRecordCompareScreenshotResponse;
import org.qubership.atp.ram.model.LogRecordWithParentListResponse;
import org.qubership.atp.ram.model.RootCauseStatisticResponse;
import org.qubership.atp.ram.model.ShortExecutionRequest;
import org.qubership.atp.ram.model.SubstepScreenshotResponse;
import org.qubership.atp.ram.model.TestRunDetailsCompareResponse;
import org.qubership.atp.ram.model.request.EnvironmentsCompareRequest;
import org.qubership.atp.ram.model.request.LogRecordCompareRequest;
import org.qubership.atp.ram.model.request.LogRecordCompareRequestItem;
import org.qubership.atp.ram.model.request.RowScreenshotRequest;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.models.MetaInfo;
import org.qubership.atp.ram.models.RamObject;
import org.qubership.atp.ram.models.TestPlan;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.services.EnvironmentsService;
import org.qubership.atp.ram.services.ExecutionRequestService;
import org.qubership.atp.ram.services.LogRecordService;
import org.qubership.atp.ram.services.RootCauseService;
import org.qubership.atp.ram.services.TestPlansService;
import org.qubership.atp.ram.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExecutionRequestCompareService {
    private static final Logger log = LoggerFactory.getLogger(ExecutionRequestCompareService.class);
    private static final String PARENT_DELIMITER = " / ";
    @Value(value="${catalogue.url}")
    String catalogueUrl;
    private final LogRecordService logRecordService;
    private final ExecutionRequestService executionRequestService;
    private final EnvironmentsService environmentsService;
    private final RootCauseService rootCauseService;
    private final TestPlansService testPlansService;
    private final String deltaPostfix = "s";

    public boolean validateExecutionRequestsDuplicates(List<UUID> executionRequestIds) {
        for (UUID id : executionRequestIds) {
            if (Collections.frequency(executionRequestIds, id) <= 1) continue;
            return false;
        }
        return true;
    }

    public List<EnvironmentDetailsCompareResponse> getEnvironmentDetailsCompareResponse(EnvironmentsCompareRequest environmentsCompareRequest) {
        List<ExecutionRequest> executionRequests = this.executionRequestService.getExecutionRequestsByIds(environmentsCompareRequest.getExecutionRequestIds());
        BaseSearchRequest searchRequest = new BaseSearchRequest();
        searchRequest.setIds(new ArrayList<UUID>());
        if (CollectionUtils.isEmpty(environmentsCompareRequest.getEnvironmentIds())) {
            executionRequests.forEach(executionRequest -> searchRequest.getIds().add(executionRequest.getEnvironmentId()));
        } else {
            searchRequest.getIds().addAll(environmentsCompareRequest.getEnvironmentIds());
        }
        List<Environment> environments = this.environmentsService.searchEnvironments(searchRequest);
        ArrayList<EnvironmentDetailsCompareResponse> environmentDetailsCompareResponses = new ArrayList<EnvironmentDetailsCompareResponse>();
        for (ExecutionRequest request : executionRequests) {
            List foundEnvironmentList = environments.stream().filter(env -> request.getEnvironmentId().equals(env.getId())).collect(Collectors.toList());
            if (foundEnvironmentList.isEmpty() && !CollectionUtils.isEmpty(environmentsCompareRequest.getEnvironmentIds())) continue;
            String environmentName = foundEnvironmentList.isEmpty() ? "-" : ((Environment)foundEnvironmentList.get(0)).getName();
            String environmentLink = foundEnvironmentList.isEmpty() ? null : this.generateEnvironmentLink(request);
            environmentDetailsCompareResponses.add(new EnvironmentDetailsCompareResponse(request.getUuid(), request.getName(), environmentName, environmentLink, request.getEnvironmentId()));
        }
        return environmentDetailsCompareResponses;
    }

    private String generateEnvironmentLink(ExecutionRequest executionRequest) {
        return this.catalogueUrl + "/project/" + executionRequest.getProjectId() + "/environments/environment/" + executionRequest.getEnvironmentId();
    }

    public DefectStatisticResponse getDefectStatisticResponse(List<UUID> executionRequestIds) {
        DefectStatisticResponse defectStatisticResponse = new DefectStatisticResponse();
        HashMap<UUID, List<TestRun>> testRunMatrix = new HashMap<UUID, List<TestRun>>();
        for (UUID uUID : executionRequestIds) {
            testRunMatrix.put(uUID, this.executionRequestService.getAllTestRuns(uUID));
        }
        ArrayList<UUID> rootCauseIds = new ArrayList<UUID>();
        for (Map.Entry entry : testRunMatrix.entrySet()) {
            rootCauseIds.addAll(((List)entry.getValue()).stream().filter(testRun -> testRun.getRootCauseId() != null).map(TestRun::getRootCauseId).collect(Collectors.toList()));
        }
        Map<UUID, String> map = this.rootCauseService.getByIds(rootCauseIds).stream().collect(Collectors.toMap(RamObject::getUuid, RamObject::getName));
        List<ExecutionRequest> list = this.executionRequestService.getExecutionRequestsByIds(executionRequestIds);
        for (ExecutionRequest executionRequest : list) {
            DefectStatisticExecutionRequestResponse defectStatisticExecutionRequestResponse = new DefectStatisticExecutionRequestResponse();
            defectStatisticExecutionRequestResponse.setExecutionRequestName(executionRequest.getName());
            List testRuns = (List)testRunMatrix.get(executionRequest.getUuid());
            defectStatisticExecutionRequestResponse.setRootCauseStatisticResponseList(this.generateRootCauseStatisticResponses(testRuns, map));
            defectStatisticResponse.addDefectStatisticExecutionRequestResponse(defectStatisticExecutionRequestResponse);
        }
        return defectStatisticResponse;
    }

    private List<RootCauseStatisticResponse> generateRootCauseStatisticResponses(List<TestRun> testRuns, Map<UUID, String> rootCauses) {
        int testRunsCount = testRuns.size();
        if (testRunsCount == 0) {
            return Collections.emptyList();
        }
        HashMap<String, Integer> defectStatisticStatusMap = new HashMap<String, Integer>();
        for (TestRun testRun : testRuns) {
            if (testRun.getRootCauseId() != null) {
                String rootCauseName = rootCauses.get(testRun.getRootCauseId());
                defectStatisticStatusMap.merge(rootCauseName, 1, Integer::sum);
                continue;
            }
            if (testRun.getTestingStatus() == TestingStatuses.PASSED) {
                defectStatisticStatusMap.merge("Passed", 1, Integer::sum);
                continue;
            }
            defectStatisticStatusMap.merge("Not Analyzed", 1, Integer::sum);
        }
        return defectStatisticStatusMap.entrySet().stream().map(defectStatisticEntry -> new RootCauseStatisticResponse((String)defectStatisticEntry.getKey(), (Integer)defectStatisticEntry.getValue())).collect(Collectors.toList());
    }

    public TestRunDetailsCompareResponse getTestRunDetailsCompareResponses(List<UUID> executionRequestIds) {
        LinkedList<ExecutionRequest> executionRequests = this.getSortedExecutionRequests(executionRequestIds);
        Map<UUID, List<TestRun>> notSortedMap = this.executionRequestService.getMapTestRunsForExecutionRequests(executionRequestIds);
        Map<UUID, List<TestRun>> sortedCompareMap = this.generateOrderedMapWithExecutionRequestsAndTestRuns(executionRequests, notSortedMap);
        List firstSortedTestRuns = sortedCompareMap.get(executionRequestIds.get(0)).stream().sorted(Comparator.comparingInt(TestRun::getOrder)).collect(Collectors.toList());
        TestRunDetailsCompareResponse testRunDetailsCompareResponse = new TestRunDetailsCompareResponse();
        testRunDetailsCompareResponse.setExecutionRequests(executionRequests.stream().map(er -> new ShortExecutionRequest(er.getUuid(), er.getName())).collect(Collectors.toList()));
        ExecutionRequest firstExecutionRequest = (ExecutionRequest)executionRequests.get(0);
        executionRequests.remove(0);
        for (TestRun testRun : firstSortedTestRuns) {
            CompareTestRunsDetailsRow row = new CompareTestRunsDetailsRow();
            row.setRowType(CompareTestRunsDetailsRow.CompareTestRunsRowType.TEST_RUN);
            row.setName(testRun.getName());
            this.addTestRunCell(row, testRun);
            for (ExecutionRequest executionRequest : executionRequests) {
                TestRun foundTestRun;
                UUID executionRequestId = executionRequest.getUuid();
                boolean testPlansAreEquals = this.checkTestPlansAreEquals(Arrays.asList(firstExecutionRequest, executionRequest));
                TestRun testRun2 = foundTestRun = testPlansAreEquals ? this.getTestRunByTestCaseId(sortedCompareMap.get(executionRequestId), testRun.getTestCaseId()) : this.getTestRunByTestRunName(sortedCompareMap.get(executionRequestId), testRun.getName());
                if (foundTestRun == null) {
                    this.addEmptyTestRunCell(row, executionRequestId);
                    continue;
                }
                this.addTestRunCell(row, foundTestRun);
                sortedCompareMap.get(executionRequestId).remove(foundTestRun);
            }
            this.setDeltaValues(row);
            testRunDetailsCompareResponse.getRowList().add(row);
        }
        return testRunDetailsCompareResponse;
    }

    private LinkedList<ExecutionRequest> getSortedExecutionRequests(List<UUID> executionRequestIds) {
        return this.executionRequestService.getExecutionRequestsByIds(executionRequestIds).stream().sorted(Comparator.comparing(er -> executionRequestIds.indexOf(er.getUuid()))).collect(Collectors.toCollection(LinkedList::new));
    }

    private Map<UUID, List<TestRun>> generateOrderedMapWithExecutionRequestsAndTestRuns(List<ExecutionRequest> executionRequests, Map<UUID, List<TestRun>> notSortedMap) {
        LinkedHashMap<UUID, List<TestRun>> compareMap = new LinkedHashMap<UUID, List<TestRun>>();
        for (ExecutionRequest executionRequest : executionRequests) {
            List<TestRun> testRuns = notSortedMap.get(executionRequest.getUuid());
            if (executionRequest.getTestScopeId() != null) {
                this.reorderTestRunByScope(testRuns);
            }
            compareMap.put(executionRequest.getUuid(), testRuns);
        }
        return compareMap;
    }

    private void setDeltaValues(CompareTestRunsDetailsRow row) {
        if (row.getCellList().size() >= 2) {
            Iterator<CompareTestRunsDetailsCell> cellIterator = row.getCellList().iterator();
            CompareTestRunsDetailsCell firstCell = cellIterator.next();
            CompareTestRunsDetailsCell secondCell = cellIterator.next();
            this.setDeltaValue(firstCell, secondCell);
            while (cellIterator.hasNext()) {
                secondCell = cellIterator.next();
                this.setDeltaValue(firstCell, secondCell);
            }
        }
    }

    private void setDeltaValue(CompareTestRunsDetailsCell firstCell, CompareTestRunsDetailsCell currentCell) {
        currentCell.setDelta(currentCell.getDuration() - firstCell.getDuration());
    }

    private void addTestRunCell(CompareTestRunsDetailsRow row, TestRun testRun) {
        row.addCell(new CompareTestRunsDetailsCell(testRun.getTestingStatus().toString().toUpperCase(), testRun.getDuration(), false, testRun.getExecutionRequestId(), testRun.getUuid(), null));
    }

    private void addEmptyTestRunCell(CompareTestRunsDetailsRow row, UUID executionRequestId) {
        row.addCell(new CompareTestRunsDetailsCell(null, 0L, true, executionRequestId, null, null));
    }

    public TestRun getTestRunByTestCaseId(List<TestRun> testRuns, UUID testCaseId) {
        if (!testRuns.isEmpty()) {
            for (TestRun testRun : testRuns) {
                if (!testRun.getTestCaseId().equals(testCaseId)) continue;
                return testRun;
            }
        }
        return null;
    }

    public TestRun getTestRunByTestRunName(List<TestRun> testRuns, String testRunName) {
        if (!testRuns.isEmpty()) {
            for (TestRun testRun : testRuns) {
                if (!testRun.getName().equals(testRunName)) continue;
                return testRun;
            }
        }
        return null;
    }

    public void reorderTestRunByScope(List<TestRun> testRuns) {
        List<TestRun> prerequisitesTestRuns = this.getFilteredTestRunBySection(testRuns, TestScopeSections.PREREQUISITES);
        int maxPrerequisitesOrder = prerequisitesTestRuns.isEmpty() ? 0 : prerequisitesTestRuns.stream().max(Comparator.comparingInt(TestRun::getOrder)).get().getOrder();
        this.reorderTestRunsBySection(testRuns, TestScopeSections.EXECUTION, maxPrerequisitesOrder);
        this.reorderTestRunsBySection(testRuns, TestScopeSections.VALIDATION, maxPrerequisitesOrder);
    }

    public void reorderTestRunsBySection(List<TestRun> testRuns, TestScopeSections section, int previousMaxOrder) {
        List<TestRun> sectionTestRuns = this.getFilteredTestRunBySection(testRuns, section);
        int currentMaxOrder = previousMaxOrder + 1;
        int index = 0;
        while (index < sectionTestRuns.size()) {
            sectionTestRuns.get(index).setOrder(currentMaxOrder);
            ++index;
            ++currentMaxOrder;
        }
    }

    public List<TestRun> getFilteredTestRunBySection(List<TestRun> testRuns, TestScopeSections section) {
        return StreamUtils.filterByTestScopeSection(testRuns, TestRun::getTestScopeSection, section).stream().sorted(Comparator.comparingInt(TestRun::getOrder)).collect(Collectors.toList());
    }

    public CompareItem getReferenceToRecord(List<CompareItem> compareItems, CompareItem item, boolean compareWithFirst) {
        int index = 0;
        if (compareWithFirst) {
            index = compareItems.stream().filter(CompareItem::isCompared).mapToInt(CompareItem::getRowNumberInCase).max().orElse(0);
        }
        while (index < compareItems.size()) {
            CompareItem compareItem = compareItems.get(index);
            if (!compareItem.isCompared() && this.checkHashSum(compareItem, item) && this.recordsPathsAreNullOrHaveSamePaths(compareItem, item)) {
                compareItem.setCompared(true);
                return compareItem;
            }
            ++index;
        }
        return new CompareItem();
    }

    public boolean recordsPathsAreNullOrHaveSamePaths(CompareItem firstItem, CompareItem secondItem) {
        return Objects.isNull(firstItem.getPath()) && Objects.isNull(secondItem.getPath()) || Strings.nullToEmpty((String)firstItem.getPath()).equals(secondItem.getPath());
    }

    public boolean recordsHaveSameNames(CompareItem firstItem, CompareItem secondItem) {
        return firstItem.getItemValue().getName().equals(secondItem.getItemValue().getName());
    }

    public boolean recordsHaveSameDefinitionIds(CompareItem firstItem, CompareItem secondItem) {
        return firstItem.getItemValue().getMetaInfo() != null && secondItem.getItemValue().getMetaInfo() != null && firstItem.getItemValue().getMetaInfo().getDefinitionId().equals(secondItem.getItemValue().getMetaInfo().getDefinitionId());
    }

    public List<CompareItem> getEmptyCompareList(int listSize, CompareItem lastItem) {
        ArrayList<CompareItem> returnedList = new ArrayList<CompareItem>();
        for (int index = 0; index < listSize - 1; ++index) {
            returnedList.add(new CompareItem());
        }
        returnedList.add(lastItem);
        return returnedList;
    }

    public int getMaximalRowInCompareItems(List<CompareItem> compareItems) {
        return compareItems.isEmpty() ? 0 : compareItems.stream().max(Comparator.comparingInt(CompareItem::getRowNumberInCase)).get().getRowNumberInCase();
    }

    public TestRunDetailsCompareResponse getLogRecordCompareResponse(LogRecordCompareRequest request) {
        if (request.getLogRecordCompareRequestItems().isEmpty()) {
            return new TestRunDetailsCompareResponse();
        }
        String compareType = request.getCompareType();
        ArrayList<List<CompareItem>> compareItemsMatrix = new ArrayList<List<CompareItem>>();
        int erCount = request.getLogRecordCompareRequestItems().size();
        request.getLogRecordCompareRequestItems().forEach(requestItem -> {
            ArrayList<CompareItem> compareItems = new ArrayList<CompareItem>();
            if (requestItem.getItemId() != null) {
                List<LogRecord> logRecordList = compareType.equals("TEST_RUN") ? this.logRecordService.findTopLogRecordsOnTestRun(requestItem.getItemId()) : this.logRecordService.getOrderedChildrenLogRecordsForParentLogRecord(requestItem.getItemId());
                for (int index = 0; index < logRecordList.size(); ++index) {
                    LogRecord logRecord = logRecordList.get(index);
                    if (!Objects.nonNull(logRecord.getMetaInfo()) || !Objects.nonNull(logRecord.getMetaInfo().getScenarioHashSum())) {
                        MetaInfo metaInfo = new MetaInfo();
                        metaInfo.setScenarioHashSum(logRecord.getName());
                        logRecord.setMetaInfo(metaInfo);
                    }
                    compareItems.add(new CompareItem(requestItem.getExecutionRequestId(), null, index, index, logRecord, false, logRecord.getMetaInfo().getScenarioHashSum()));
                }
            }
            compareItemsMatrix.add(compareItems);
        });
        List<LinkedList<CompareItem>> comparedItemMatrix = this.compareLogRecords(compareItemsMatrix, erCount);
        TestRunDetailsCompareResponse testRunDetailsCompareResponse = new TestRunDetailsCompareResponse();
        comparedItemMatrix = comparedItemMatrix.stream().sorted(Comparator.comparingInt(this::getMaximalRowInCompareItems)).collect(Collectors.toList());
        List executionRequestIds = request.getLogRecordCompareRequestItems().stream().map(LogRecordCompareRequestItem::getExecutionRequestId).collect(Collectors.toList());
        comparedItemMatrix.forEach(compareItems -> {
            CompareTestRunsDetailsRow row = new CompareTestRunsDetailsRow();
            CompareItem notEmptyItem = (CompareItem)compareItems.stream().filter(compareItem -> compareItem.getItemValue() != null).collect(Collectors.toList()).get(0);
            if (notEmptyItem.getItemValue().isCompaund() || notEmptyItem.getItemValue().isSection()) {
                row.setRowType("COMPOUND");
            } else {
                row.setRowType(notEmptyItem.getItemValue().getType().toString());
            }
            row.setName(notEmptyItem.getItemValue().getName());
            executionRequestIds.forEach(executionRequestId -> {
                CompareTestRunsDetailsCell cell = new CompareTestRunsDetailsCell();
                List filterItems = compareItems.stream().filter(item -> executionRequestId.equals(item.getExecutionRequestId())).collect(Collectors.toList());
                if (filterItems.isEmpty()) {
                    cell.setCellStatus(null);
                    cell.setExecutionRequestId((UUID)executionRequestId);
                    cell.setEmpty(true);
                } else {
                    CompareItem compareItem = (CompareItem)filterItems.get(0);
                    cell.setItemId(compareItem.getItemValue().getUuid());
                    cell.setExecutionRequestId((UUID)executionRequestId);
                    cell.setCellStatus(compareItem.getItemValue().getTestingStatus().getName().toUpperCase());
                    cell.setDuration(compareItem.getItemValue().getDuration());
                    cell.setEmpty(false);
                }
                row.addCell(cell);
            });
            this.setDeltaValues(row);
            testRunDetailsCompareResponse.getRowList().add(row);
        });
        return testRunDetailsCompareResponse;
    }

    private void fillEmptyCells(LinkedList<CompareItem> items, int currentIndex) {
        while (items.size() <= currentIndex) {
            items.add(new CompareItem());
        }
    }

    private List<LinkedList<CompareItem>> compareLogRecords(List<List<CompareItem>> compareItemsMatrix, int erCount) {
        LinkedList<LinkedList<CompareItem>> comparedItemMatrix = new LinkedList<LinkedList<CompareItem>>();
        for (CompareItem compareItem : compareItemsMatrix.get(0)) {
            LinkedList<CompareItem> comparedItemList = new LinkedList<CompareItem>();
            comparedItemList.add(compareItem);
            comparedItemMatrix.add(comparedItemList);
        }
        for (int index = 1; index < erCount; ++index) {
            LinkedList<CompareItem> firstErItems = new LinkedList<CompareItem>((Collection)compareItemsMatrix.get(0));
            for (CompareItem compareItem : compareItemsMatrix.get(index)) {
                List comparedItemRow;
                if (compareItem.isCompared()) continue;
                CompareItem secondItem = this.getReferenceToRecord(firstErItems, compareItem, true);
                if (!secondItem.isCompared()) {
                    for (int compareIndex = 1; compareIndex < index && !(secondItem = this.getReferenceToRecord(compareItemsMatrix.get(compareIndex), compareItem, false)).isCompared(); ++compareIndex) {
                    }
                    if (!secondItem.isCompared()) {
                        LinkedList<CompareItem> comparedItemsRow = new LinkedList<CompareItem>();
                        for (int i = 0; i < index; ++i) {
                            comparedItemsRow.add(new CompareItem());
                        }
                        compareItem.setRowNumberInMatrix(comparedItemMatrix.size());
                        comparedItemsRow.add(compareItem);
                        comparedItemMatrix.add(comparedItemsRow);
                        continue;
                    }
                    comparedItemRow = (List)comparedItemMatrix.get(secondItem.getRowNumberInMatrix());
                    compareItem.setCompared(true);
                    compareItem.setRowNumberInMatrix(secondItem.getRowNumberInMatrix());
                    comparedItemRow.add(compareItem);
                    continue;
                }
                comparedItemRow = (List)comparedItemMatrix.get(secondItem.getRowNumberInMatrix());
                comparedItemRow.add(compareItem);
            }
            for (LinkedList linkedList : comparedItemMatrix) {
                this.fillEmptyCells(linkedList, index);
            }
            firstErItems.forEach(item -> item.setCompared(false));
        }
        return comparedItemMatrix;
    }

    public boolean checkHashSum(CompareItem item, CompareItem itemCompare) {
        return item.getHashSumForCompare().equals(itemCompare.getHashSumForCompare());
    }

    public boolean checkTestPlansAreEquals(List<ExecutionRequest> executionRequests) {
        Set<UUID> testPlansId = StreamUtils.extractIds(executionRequests, ExecutionRequest::getTestPlanId);
        return testPlansId.size() <= 1;
    }

    public List<SubstepScreenshotResponse> getCompareScreenshotsSubSteps(List<RowScreenshotRequest> rows) {
        if (CollectionUtils.isEmpty(rows)) {
            return new ArrayList<SubstepScreenshotResponse>();
        }
        ArrayList<UUID> logRecordIds = new ArrayList<UUID>();
        rows.forEach(rowScreenshotRequest -> logRecordIds.addAll(rowScreenshotRequest.getRow()));
        return this.logRecordService.getSubstepScreenshots(logRecordIds);
    }

    public ExecutionRequestsCompareScreenshotResponse getCompareScreenshotsExecutionRequests(List<UUID> executionRequestIds, boolean logsWithScreenshotsContent) {
        log.debug("Start comparing ER's with screenshots: {}", executionRequestIds);
        ExecutionRequestsCompareScreenshotResponse response = new ExecutionRequestsCompareScreenshotResponse();
        LinkedList<ExecutionRequest> executionRequests = this.getSortedExecutionRequests(executionRequestIds);
        this.fillExecutionRequestsSection(response, executionRequests);
        Map<UUID, List<TestRun>> notSortedMap = this.executionRequestService.getMapTestRunsWithScreenShotsForExecutionRequests(executionRequestIds);
        Map<UUID, List<TestRun>> compareMap = this.generateOrderedMapWithExecutionRequestsAndTestRuns(executionRequests, notSortedMap);
        LinkedList<RamObject> testPlanInfoList = new LinkedList<RamObject>();
        executionRequests.forEach(executionRequest -> {
            TestPlan testPlan = new TestPlan();
            UUID testPlanId = executionRequest.getTestPlanId();
            testPlan.setName(this.testPlansService.getTestPlanName(testPlanId));
            testPlan.setUuid(testPlanId);
            testPlanInfoList.add((RamObject)testPlan);
        });
        List firstSortedTestRuns = compareMap.get(executionRequestIds.get(0)).stream().sorted(Comparator.comparingInt(TestRun::getOrder)).collect(Collectors.toList());
        LinkedList<ExecutionRequestsCompareScreenshotResponse.TestRunCompareScreenshotResponse> testRuns = new LinkedList<ExecutionRequestsCompareScreenshotResponse.TestRunCompareScreenshotResponse>();
        for (TestRun leftTestRun : firstSortedTestRuns) {
            UUID executionRequestId = executionRequestIds.get(1);
            TestRun rightTestRun = this.checkTestPlansAreEquals(executionRequests) ? this.getTestRunByTestCaseId(compareMap.get(executionRequestId), leftTestRun.getTestCaseId()) : this.getTestRunByTestRunName(compareMap.get(executionRequestId), leftTestRun.getName());
            if (rightTestRun == null) continue;
            ExecutionRequestsCompareScreenshotResponse.TestRunCompareScreenshotResponse testRunResponse = new ExecutionRequestsCompareScreenshotResponse.TestRunCompareScreenshotResponse();
            testRunResponse.setTestRunName(leftTestRun.getName());
            testRunResponse.setType(ExecutionRequestsCompareScreenshotResponse.Type.TESTRUN);
            LinkedHashMap<UUID, TestRun> compareTestRunMap = new LinkedHashMap<UUID, TestRun>();
            compareTestRunMap.put(leftTestRun.getExecutionRequestId(), leftTestRun);
            compareTestRunMap.put(executionRequestId, rightTestRun);
            LinkedList<List<CompareItem>> comparedLogRecordsMatrix = this.createComparedMatrix(compareTestRunMap);
            LinkedList<LogRecordCompareScreenshotResponse> topLogRecordsList = new LinkedList<LogRecordCompareScreenshotResponse>();
            this.createLogRecordsTree(comparedLogRecordsMatrix, testPlanInfoList, topLogRecordsList, logsWithScreenshotsContent);
            testRunResponse.setChild(topLogRecordsList);
            testRuns.add(testRunResponse);
        }
        response.setTree(testRuns);
        log.debug("End comparing ER's with screenshots: {}", executionRequestIds);
        return response;
    }

    public LinkedList<List<CompareItem>> createComparedMatrix(Map<UUID, TestRun> compareMap) {
        List testRunIds = compareMap.values().stream().map(RamObject::getUuid).collect(Collectors.toList());
        log.debug("Start comparing LR's with screenshots for ER's {} and TR's {}", compareMap.keySet(), testRunIds);
        ArrayList<List<CompareItem>> compareItemsMatrix = new ArrayList<List<CompareItem>>();
        compareMap.forEach((erId, testRun) -> {
            ArrayList<CompareItem> compareItems = new ArrayList<CompareItem>();
            List<LogRecordWithParentListResponse> logRecordList = this.logRecordService.findLogRecordsWithParentsByPreviewExists(testRun.getUuid());
            for (int index = 0; index < logRecordList.size(); ++index) {
                LogRecordWithParentListResponse logRecord = logRecordList.get(index);
                List logRecordParentList = logRecord.getParent().stream().sorted(Comparator.comparingInt(LogRecordWithParentListResponse.LogRecordParent::getDepth).reversed()).collect(Collectors.toList());
                StringBuilder path = new StringBuilder();
                if (logRecordParentList.size() == 1) {
                    logRecord.setMetaInfo(((LogRecordWithParentListResponse.LogRecordParent)((Object)((Object)logRecordParentList.get(0)))).getMetaInfo());
                } else if (logRecordParentList.size() > 1) {
                    for (LogRecordWithParentListResponse.LogRecordParent parent : logRecordParentList) {
                        if (Objects.nonNull(parent.getMetaInfo()) && !parent.getType().equals((Object)TypeAction.COMPOUND)) {
                            logRecord.setMetaInfo(parent.getMetaInfo());
                            break;
                        }
                        path.append(parent.getMetaInfo().getScenarioHashSum()).append(PARENT_DELIMITER);
                    }
                }
                compareItems.add(new CompareItem((UUID)erId, path.toString(), index, index, logRecord, false, logRecord.getMetaInfo().getScenarioHashSum()));
            }
            compareItemsMatrix.add(compareItems);
        });
        List<Object> comparedItemMatrix = new ArrayList();
        try {
            comparedItemMatrix = this.compareLogRecords(compareItemsMatrix, 2);
        }
        catch (NullPointerException e) {
            log.trace("Can not compared Log Records for screenshots : {}", compareItemsMatrix, (Object)e);
        }
        log.trace("Matrix of compared Log Records: {}", comparedItemMatrix);
        log.debug("End comparing LR's with screenshots for ER's {} and TR's {}", compareMap.keySet(), testRunIds);
        return comparedItemMatrix.stream().sorted(Comparator.comparingInt(this::getMaximalRowInCompareItems)).collect(Collectors.toCollection(LinkedList::new));
    }

    public void createLogRecordsTree(LinkedList<List<CompareItem>> comparedLogRecordsMatrix, List<RamObject> testPlanInfoList, LinkedList<LogRecordCompareScreenshotResponse> topLogRecordsList, boolean logsWithScreenshotsContent) {
        log.debug("Start creating Log Record tree.");
        comparedLogRecordsMatrix.forEach(items -> {
            LogRecordCompareScreenshotResponse action = new LogRecordCompareScreenshotResponse();
            action.setType(ExecutionRequestsCompareScreenshotResponse.Type.ACTION.name());
            LogRecordWithParentListResponse logRecord = this.createSubSteps((List<CompareItem>)items, action, testPlanInfoList, logsWithScreenshotsContent);
            if (Objects.nonNull((Object)logRecord)) {
                List parent = logRecord.getParent().stream().sorted(Comparator.comparingInt(LogRecordWithParentListResponse.LogRecordParent::getDepth).reversed()).collect(Collectors.toList());
                if (!parent.isEmpty()) {
                    LogRecordWithParentListResponse.LogRecordParent topParent = (LogRecordWithParentListResponse.LogRecordParent)((Object)((Object)parent.get(0)));
                    LogRecordCompareScreenshotResponse topLogRecord = this.createParentLogRecord(topParent.getName(), TypeAction.COMPOUND.equals((Object)topParent.getType()) ? ExecutionRequestsCompareScreenshotResponse.Type.COMPOUND.name() : ExecutionRequestsCompareScreenshotResponse.Type.ACTION.name());
                    parent.remove(0);
                    String path = parent.stream().map(RamObject::getName).collect(Collectors.joining(PARENT_DELIMITER));
                    List<LogRecordCompareScreenshotResponse> children = topLogRecord.getChild();
                    if (!path.isEmpty()) {
                        LogRecordCompareScreenshotResponse pathLogRecord = this.createParentLogRecord(path, ExecutionRequestsCompareScreenshotResponse.Type.ACTION.name());
                        List<LogRecordCompareScreenshotResponse> childLogRecords = pathLogRecord.getChild();
                        childLogRecords.add(action);
                        pathLogRecord.setChild(childLogRecords);
                        children.add(pathLogRecord);
                    } else {
                        children.add(action);
                    }
                    topLogRecord.setChild(children);
                    topLogRecordsList.add(topLogRecord);
                } else {
                    LogRecordCompareScreenshotResponse topLogRecord = new LogRecordCompareScreenshotResponse();
                    topLogRecord.setType(ExecutionRequestsCompareScreenshotResponse.Type.ACTION.name());
                    topLogRecord.setName("");
                    topLogRecord.setChild(Collections.singletonList(action));
                    topLogRecordsList.add(topLogRecord);
                }
            }
        });
        log.debug("End creating Log Record tree.");
    }

    private LogRecordCompareScreenshotResponse createParentLogRecord(String name, String type) {
        LogRecordCompareScreenshotResponse topLogRecord = new LogRecordCompareScreenshotResponse();
        topLogRecord.setType(type);
        topLogRecord.setName(name);
        return topLogRecord;
    }

    private LogRecordWithParentListResponse createSubSteps(List<CompareItem> items, LogRecordCompareScreenshotResponse action, List<RamObject> testPlanInfoList, boolean logsWithScreenshotsContent) {
        LogRecordWithParentListResponse logRecord = null;
        LinkedList<LogRecordCompareScreenshotResponse.SubStepCompareScreenshotResponse> subSteps = new LinkedList<LogRecordCompareScreenshotResponse.SubStepCompareScreenshotResponse>();
        for (int index = 0; index < items.size(); ++index) {
            LogRecordCompareScreenshotResponse.SubStepCompareScreenshotResponse subStep;
            CompareItem item = items.get(index);
            if (Objects.nonNull(item.getItemValue())) {
                logRecord = (LogRecordWithParentListResponse)item.getItemValue();
                action.setSubStepName(logRecord.getName());
                RamObject testPlanInfo = testPlanInfoList.get(index);
                if (logsWithScreenshotsContent) {
                    String screenshot = "";
                    List<SubstepScreenshotResponse> screenshotResponses = this.logRecordService.getSubstepScreenshots(Collections.singletonList(logRecord.getUuid()));
                    if (!CollectionUtils.isEmpty(screenshotResponses)) {
                        screenshot = screenshotResponses.get(0).getScreenshot();
                    }
                    subStep = new LogRecordCompareScreenshotResponse.SubStepCompareScreenshotResponse(logRecord.getUuid(), logRecord.getTestingStatus(), testPlanInfo.getUuid(), testPlanInfo.getName(), screenshot);
                } else {
                    subStep = new LogRecordCompareScreenshotResponse.SubStepCompareScreenshotResponse(logRecord.getUuid(), logRecord.getTestingStatus(), testPlanInfo.getUuid(), testPlanInfo.getName(), "");
                }
            } else {
                subStep = new LogRecordCompareScreenshotResponse.SubStepCompareScreenshotResponse();
            }
            subSteps.add(subStep);
        }
        action.setRow(subSteps);
        return logRecord;
    }

    private void fillExecutionRequestsSection(ExecutionRequestsCompareScreenshotResponse response, List<ExecutionRequest> executionRequests) {
        response.setExecutionRequests(executionRequests.stream().map(executionRequest -> new ShortExecutionRequest(executionRequest.getUuid(), executionRequest.getName())).collect(Collectors.toList()));
    }

    public ExecutionRequestCompareService(LogRecordService logRecordService, ExecutionRequestService executionRequestService, EnvironmentsService environmentsService, RootCauseService rootCauseService, TestPlansService testPlansService) {
        this.logRecordService = logRecordService;
        this.executionRequestService = executionRequestService;
        this.environmentsService = environmentsService;
        this.rootCauseService = rootCauseService;
        this.testPlansService = testPlansService;
    }
}

