/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.modelmapper.ModelMapper;
import org.qubership.atp.common.lock.LockManager;
import org.qubership.atp.common.utils.regex.TimeoutRegexCharSequence;
import org.qubership.atp.common.utils.regex.TimeoutRegexException;
import org.qubership.atp.ram.dto.response.FailPatternResponse;
import org.qubership.atp.ram.dto.response.IssueResponse;
import org.qubership.atp.ram.dto.response.IssueResponsesModel;
import org.qubership.atp.ram.dto.response.IssueTestRunResponse;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.exceptions.topissues.RamTopIssuesCalculationException;
import org.qubership.atp.ram.model.IssueDto;
import org.qubership.atp.ram.model.LogRecordWithFailPatternsDto;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.FailPattern;
import org.qubership.atp.ram.models.Issue;
import org.qubership.atp.ram.models.LogRecord;
import org.qubership.atp.ram.models.RamObject;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.pojo.IssueFilteringParams;
import org.qubership.atp.ram.repositories.CustomExecutionRequestRepository;
import org.qubership.atp.ram.repositories.CustomIssueRepository;
import org.qubership.atp.ram.repositories.ExecutionRequestRepository;
import org.qubership.atp.ram.repositories.IssueRepository;
import org.qubership.atp.ram.services.CrudService;
import org.qubership.atp.ram.services.ExecutionRequestDetailsService;
import org.qubership.atp.ram.services.FailPatternService;
import org.qubership.atp.ram.services.LogRecordService;
import org.qubership.atp.ram.services.TestRunService;
import org.qubership.atp.ram.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IssueService
extends CrudService<Issue> {
    private static final Logger log = LoggerFactory.getLogger(IssueService.class);
    @Value(value="${atp.ram.regexp.timeout.sec}")
    private int regexpTimeout;
    @Value(value="${atp.logrecord.step.for.recalculating.topissues}")
    private int logRecordStep;
    private final IssueRepository repository;
    private final CustomIssueRepository customIssueRepository;
    private final TestRunService testRunService;
    private final FailPatternService failPatternService;
    private final LogRecordService logRecordService;
    private final ExecutionRequestDetailsService executionRequestDetailsService;
    private final ModelMapper modelMapper;
    private final ExecutionRequestRepository executionRequestRepository;
    private final CustomExecutionRequestRepository customExecutionRequestRepository;
    private final LockManager lockManager;
    @Value(value="${atp.ram.services.issues_creating.lock.duration.sec:300}")
    private Integer lockDurationForCreatingIssuesSec;

    public IssueService(IssueRepository repository, CustomIssueRepository customIssueRepository, @Lazy TestRunService testRunService, FailPatternService failPatternService, LogRecordService logRecordService, ExecutionRequestDetailsService executionRequestDetailsService, ModelMapper modelMapper, ExecutionRequestRepository executionRequestRepository, CustomExecutionRequestRepository customExecutionRequestRepository, LockManager lockManager) {
        this.repository = repository;
        this.customIssueRepository = customIssueRepository;
        this.testRunService = testRunService;
        this.failPatternService = failPatternService;
        this.logRecordService = logRecordService;
        this.executionRequestDetailsService = executionRequestDetailsService;
        this.modelMapper = modelMapper;
        this.executionRequestRepository = executionRequestRepository;
        this.customExecutionRequestRepository = customExecutionRequestRepository;
        this.lockManager = lockManager;
    }

    public Issue create(Issue issue) {
        return (Issue)this.repository.save(issue);
    }

    public Issue update(Issue issue) {
        return (Issue)this.repository.save(issue);
    }

    private IssueResponsesModel getAllIssuesByParameters(IssueFilteringParams issueFilteringParams, String columnType, String sortType, int startIndex, int endIndex) {
        return this.getIssueResponsesModel(startIndex, endIndex, columnType, sortType, issueFilteringParams);
    }

    public List<Issue> getAllIssuesByTestRunIds(UUID executionRequestId, Collection<UUID> testRunIds) {
        return this.repository.findByExecutionRequestIdAndFailedTestRunIdsIn(executionRequestId, testRunIds);
    }

    public IssueResponsesModel getAllIssuesByExecutionRequestId(UUID id) {
        List<IssueResponse> issues = this.getResponses(this.repository.findByExecutionRequestId(id));
        return new IssueResponsesModel((int)this.repository.countByExecutionRequestId(id), issues);
    }

    public IssueResponsesModel getAllIssuesByExecutionRequestId(UUID executionRequestId, int startIndex, int endIndex, String columnType, String sortType) {
        IssueFilteringParams filteringParams = new IssueFilteringParams();
        filteringParams.setExecutionRequestId(executionRequestId);
        return this.getAllIssuesByParameters(filteringParams, columnType, sortType, startIndex, endIndex);
    }

    public IssueResponsesModel getAllIssuesByExecutionRequestId(IssueFilteringParams issueFilteringParams, int startIndex, int endIndex, String columnType, String sortType) {
        return this.getAllIssuesByParameters(issueFilteringParams, columnType, sortType, startIndex, endIndex);
    }

    public IssueResponsesModel getAllIssuesByLogRecordId(IssueFilteringParams issueFilteringParams, int startIndex, int endIndex, String columnType, String sortType) {
        log.debug("Finding issues in a Log Record {} from {} to {}, Execution Request ids [{}]", new Object[]{issueFilteringParams.getLogRecordIds().get(0), startIndex, endIndex, issueFilteringParams.getExecutionRequestId()});
        return this.getAllIssuesByParameters(issueFilteringParams, columnType, sortType, startIndex, endIndex);
    }

    @Override
    protected MongoRepository<Issue, UUID> repository() {
        return this.repository;
    }

    @Override
    public List<Issue> getAll() {
        return this.repository.findAll();
    }

    public void mapTestRunsAndRecalculateIssues(List<UUID> testRunIds) {
        List<TestRun> testRunList = this.getTestRunsWithUuidAndErIdForIssueCalculation(testRunIds);
        Map<UUID, List<TestRun>> testRunMap = StreamUtils.toMapWithListEntitiesValues(testRunList, TestRun::getExecutionRequestId);
        log.debug("Start recalculate issues for failed Test Runs from Execution Request ids [{}]", testRunMap.keySet());
        testRunMap.forEach((uuid, testRuns) -> this.calculateIssuesForExecution((UUID)uuid, StreamUtils.extractIdsToList(testRuns)));
    }

    public void recalculateTopIssues(UUID executionRequestId) {
        log.debug("Start recalculating Top Issues for ER {}", (Object)executionRequestId);
        ExecutionRequest executionRequest = this.executionRequestRepository.findByUuid(executionRequestId);
        long failedLogrecordsCounter = executionRequest.getFailedLogrecordsCounter();
        List<UUID> testRunIds = this.getTestRunIdsForIssueCalculation(executionRequestId);
        Long updatedFailedLogrecordsCounter = this.logRecordService.countAllFailedLrByTestRunIds(testRunIds);
        if (failedLogrecordsCounter != updatedFailedLogrecordsCounter) {
            try {
                this.calculateIssuesForExecution(executionRequestId, testRunIds);
                log.debug("Complete recalculating Top Issues for ER {}", (Object)executionRequestId);
                return;
            }
            catch (Exception e) {
                log.error("Failed to calculate top issues for the execution request: {}", (Object)executionRequestId, (Object)e);
                throw new RamTopIssuesCalculationException();
            }
        }
        log.debug("Recalculating for ER {} wasn't started,because failed log records count wasn't changed", (Object)executionRequestId);
    }

    public void recalculateIssuesForExecution(UUID executionRequestId) {
        log.info("Start recalculating issues process for the ER: {}", (Object)executionRequestId);
        List<Issue> existedIssues = this.repository.findByExecutionRequestId(executionRequestId);
        List<UUID> issueIds = StreamUtils.extractIdsToList(existedIssues);
        log.debug("Existed issues: {}", issueIds);
        this.repository.deleteAllById(issueIds);
        log.debug("Issues has been deleted");
        List<UUID> testRunIds = this.getTestRunIdsForIssueCalculation(executionRequestId);
        log.debug("Found not passed test runs: {}", testRunIds);
        UUID projectId = this.executionRequestRepository.findProjectIdByUuid(executionRequestId).getProjectId();
        this.calculateIssuesForExecution(executionRequestId, testRunIds, projectId);
    }

    private List<UUID> getTestRunIdsForIssueCalculation(UUID executionRequestId) {
        List<TestingStatuses> testRunStatuses = this.getTestRunStatusesForIssueCalculation();
        List<TestRun> testRuns = this.testRunService.getTestRunsIdByExecutionRequestIdAndTestingStatuses(executionRequestId, testRunStatuses);
        return StreamUtils.extractIdsToList(testRuns);
    }

    private List<TestRun> getTestRunsWithUuidAndErIdForIssueCalculation(List<UUID> testRunIds) {
        List<TestingStatuses> testRunStatuses = this.getTestRunStatusesForIssueCalculation();
        return this.testRunService.getTestRunsUuidErIdByTestingStatusesAndUuidIn(testRunIds, testRunStatuses);
    }

    private List<TestingStatuses> getTestRunStatusesForIssueCalculation() {
        return Arrays.asList(TestingStatuses.FAILED, TestingStatuses.STOPPED, TestingStatuses.WARNING);
    }

    public void calculateIssuesForExecution(UUID executionRequestId, List<UUID> testRunsIds) {
        UUID projectId = this.executionRequestRepository.findProjectIdByUuid(executionRequestId).getProjectId();
        this.calculateIssuesForExecution(executionRequestId, testRunsIds, projectId);
    }

    public void calculateIssuesForExecution(UUID executionRequestId, List<UUID> testRunIds, UUID projectId) {
        List<Issue> createdIssues = this.repository.findShortByExecutionRequestId(executionRequestId);
        List<UUID> linkedLogRecordsId = createdIssues.stream().flatMap(issue -> issue.getLogRecordIds().stream()).collect(Collectors.toList());
        Stream<LogRecord> failedLogRecordsInExecutionRequest = this.logRecordService.getAllFailedLogRecordsByTestRunIdsStream(testRunIds, linkedLogRecordsId);
        Long failedLrsCount = this.logRecordService.countAllFailedLrByTestRunIds(testRunIds);
        List<FailPattern> patternByProjectId = this.failPatternService.findPatternByProjectId(projectId);
        this.lockManager.executeWithLock("calculateIssuesForExecution_" + executionRequestId.toString(), this.lockDurationForCreatingIssuesSec, () -> {
            this.analyzeFailedLogRecords(executionRequestId, failedLogRecordsInExecutionRequest, patternByProjectId);
            this.customExecutionRequestRepository.updateLogRecordsCount(executionRequestId, Math.toIntExact(failedLrsCount));
        });
    }

    private void createdIssues(UUID executionRequestId, Stream<LogRecord> failedLogRecordsInExecutionRequest, List<FailPattern> patternByProjectId, List<Issue> createdIssues) {
        this.analyzeFailedLogRecords(executionRequestId, failedLogRecordsInExecutionRequest, patternByProjectId);
    }

    public void delete(UUID id) {
        this.repository.deleteById(id);
    }

    private IssueResponsesModel getIssueResponsesModel(int startIndex, int endIndex, String columnType, String sortType, IssueFilteringParams issueFilteringParams) {
        IssueDto issueDto = this.customIssueRepository.getSortedAndPaginatedIssuesByFilters(issueFilteringParams, columnType, sortType, startIndex, endIndex);
        List<IssueResponse> responses = this.getResponses(issueDto.getData());
        return new IssueResponsesModel(issueDto.getMetadata().isEmpty() ? 0 : (int)issueDto.getMetadata().get(0).getTotalCount(), responses);
    }

    private void analyzeFailedLogRecords(UUID executionRequestId, Stream<LogRecord> logRecords, List<FailPattern> failPatterns) {
        try {
            Map<Pattern, FailPattern> compiledPatterns = this.collectCompiledPatternsToMap(failPatterns);
            Iterators.partition(logRecords.iterator(), (int)this.logRecordStep).forEachRemaining(partOfLogRecords -> {
                List<Issue> createdIssues = this.prepareIssueByLogRecord((List<LogRecord>)partOfLogRecords, compiledPatterns, executionRequestId);
                this.saveAll(createdIssues);
                createdIssues.forEach(issue -> this.testRunService.updateFieldRootCauseIdByTestRunsIds(issue.getFailedTestRunIds(), issue.getFailReasonId()));
                log.trace("Created issues: {}", createdIssues);
            });
        }
        catch (Exception e) {
            log.error("Analyze failed Log Records finished with error, Fail Patterns: {}, Log Records: {}, Execution Request ids: {}", new Object[]{failPatterns, logRecords, executionRequestId, e});
            throw e;
        }
    }

    private List<Issue> prepareIssueByLogRecord(List<LogRecord> logRecords, Map<Pattern, FailPattern> compiledPatterns, UUID executionRequestId) {
        HashMap<UUID, LogRecordWithFailPatternsDto> logRecordsWithPatterns = new HashMap<UUID, LogRecordWithFailPatternsDto>();
        ArrayList<LogRecord> logRecordsWithoutPatterns = new ArrayList<LogRecord>();
        logRecords.forEach(logRecord -> {
            String message = logRecord.getMessage();
            List<FailPattern> matchingPatterns = this.findMatchingFailPatterns(executionRequestId, message, compiledPatterns);
            if (matchingPatterns.isEmpty() && !Strings.isNullOrEmpty((String)message)) {
                logRecordsWithoutPatterns.add((LogRecord)logRecord);
            } else {
                logRecordsWithPatterns.put(logRecord.getUuid(), new LogRecordWithFailPatternsDto((LogRecord)logRecord, matchingPatterns));
            }
        });
        List<Issue> createdIssues = this.updateCreatedIssuesAndCreateNewByMessage(logRecordsWithoutPatterns, executionRequestId);
        createdIssues.addAll(this.updateCreatedIssuesAndCreateNewByPatterns(logRecordsWithPatterns, executionRequestId));
        return createdIssues;
    }

    private List<Issue> updateCreatedIssuesAndCreateNewByMessage(List<LogRecord> logRecords, UUID executionRequestId) {
        if (!logRecords.isEmpty()) {
            ArrayList<Issue> createdIssues = new ArrayList<Issue>(this.customIssueRepository.getCreatedIssuesByLogRecordsMessage(logRecords.stream().map(RamObject::getUuid).collect(Collectors.toList()), executionRequestId));
            List updatedLogRecords = createdIssues.stream().flatMap(issue -> issue.getLogRecordIds().stream()).collect(Collectors.toList());
            ArrayList newIssues = new ArrayList();
            logRecords.stream().filter(logRecord -> !updatedLogRecords.contains(logRecord.getUuid())).forEach(logRecord -> this.addIssueToList(issue -> issue.getMessage().equals(logRecord.getMessage()), () -> this.createIssue((LogRecord)logRecord, executionRequestId), newIssues, (LogRecord)logRecord));
            createdIssues.addAll(newIssues);
            return createdIssues;
        }
        return new ArrayList<Issue>();
    }

    private List<Issue> updateCreatedIssuesAndCreateNewByPatterns(Map<UUID, LogRecordWithFailPatternsDto> logRecordsWithPatterns, UUID executionRequestId) {
        Collection<LogRecordWithFailPatternsDto> values = logRecordsWithPatterns.values();
        ArrayList<Issue> createdIssues = new ArrayList<Issue>(this.repository.findByExecutionRequestIdAndFailPatternIdIn(executionRequestId, values.stream().flatMap(entity -> entity.getFailPatterns().stream()).map(RamObject::getUuid).collect(Collectors.toList())));
        createdIssues.forEach(issue -> values.stream().filter(entity -> entity.getFailPatterns().stream().anyMatch(pattern -> pattern.getUuid().equals(issue.getFailPatternId()))).forEach(entity -> this.updateExistingIssue((Issue)issue, entity.getLogRecord())));
        List updatedLogRecords = createdIssues.stream().flatMap(issue -> issue.getLogRecordIds().stream()).collect(Collectors.toList());
        ArrayList newIssues = new ArrayList();
        values.stream().filter(logRecordDto -> !updatedLogRecords.contains(logRecordDto.getLogRecord().getUuid())).forEach(logRecordDto -> logRecordDto.getFailPatterns().forEach(failPattern -> {
            LogRecord logRecord = logRecordDto.getLogRecord();
            this.addIssueToList(issue -> issue.getFailPatternId().equals(failPattern.getUuid()), () -> this.createIssue(logRecord, executionRequestId, (FailPattern)failPattern), newIssues, logRecord);
        }));
        createdIssues.addAll(newIssues);
        return createdIssues;
    }

    private Map<Pattern, FailPattern> collectCompiledPatternsToMap(List<FailPattern> failPatterns) {
        HashMap<Pattern, FailPattern> compiledFailPatternsMap = new HashMap<Pattern, FailPattern>();
        failPatterns.forEach(failPattern -> {
            try {
                compiledFailPatternsMap.put(Pattern.compile(failPattern.getRule()), (FailPattern)failPattern);
            }
            catch (PatternSyntaxException e) {
                log.error("Could not parse pattern {}", (Object)failPattern.getUuid(), (Object)e);
            }
        });
        log.debug("Compiled patterns: {}", compiledFailPatternsMap);
        return compiledFailPatternsMap;
    }

    public FailPattern saveFailPattern(FailPattern failPattern, UUID executionRequestId) {
        this.updateIssuesByFailPattern(failPattern, executionRequestId);
        return this.failPatternService.save(failPattern);
    }

    private void updateIssuesByFailPattern(FailPattern failPattern, UUID executionRequestId) {
        this.purgeOldPatternIssues(failPattern.getUuid(), executionRequestId);
        log.debug("Updating issues for the execution request {} and pattern {}", (Object)executionRequestId, (Object)failPattern.getUuid());
        List<LogRecord> logRecords = this.testRunService.findAllByExecutionRequestId(executionRequestId).stream().flatMap(testRun -> this.logRecordService.getAllFailedLogRecordsByTestRunId(testRun.getUuid()).stream()).collect(Collectors.toList());
        ArrayList createdIssues = new ArrayList();
        Pattern compiledFailPattern = Pattern.compile(failPattern.getRule());
        logRecords.forEach(logRecord -> {
            try {
                boolean isMatching = compiledFailPattern.matcher(logRecord.getMessage()).find();
                if (!isMatching) {
                    if (!Strings.isNullOrEmpty((String)logRecord.getMessage())) {
                        this.addIssueToList(issue -> issue.getMessage().equals(logRecord.getMessage()), () -> this.createIssue((LogRecord)logRecord, executionRequestId), createdIssues, (LogRecord)logRecord);
                    }
                } else {
                    this.addIssueToList(issue -> issue.getFailPatternId().equals(failPattern.getUuid()), () -> this.createIssue((LogRecord)logRecord, executionRequestId, failPattern), createdIssues, (LogRecord)logRecord);
                }
            }
            catch (StackOverflowError error) {
                this.processStackOverflowErrorDuringPatternMatch(executionRequestId, error, Pattern.compile(failPattern.getRule()), logRecord.getMessage());
            }
        });
        log.debug("Final issue list: {}, Execution Request ids: {}", createdIssues, (Object)executionRequestId);
        this.repository.saveAll(createdIssues);
    }

    public void deleteFailPattern(UUID failPatternId, UUID executionRequestId) {
        this.deleteIssuesByFailPattern(failPatternId, executionRequestId);
        this.failPatternService.deleteByUuid(failPatternId);
    }

    @Transactional
    public void deleteFailPattern(UUID failPatternId) {
        this.failPatternService.deleteByUuid(failPatternId);
        log.info("Removing deleted failPatternId = {} from issues.", (Object)failPatternId);
        this.repository.updateByRemovedPatternId(failPatternId);
        log.info("Removing deleted failPatternId = {} from issues... DONE", (Object)failPatternId);
    }

    private void deleteIssuesByFailPattern(UUID failPatternId, UUID executionRequestId) {
        this.purgeOldPatternIssues(failPatternId, executionRequestId);
        log.debug("Updating issues that belonged to Fail Pattern: {}, Execution Request id: {}", (Object)failPatternId, (Object)executionRequestId);
        List<LogRecord> logRecords = this.testRunService.findAllByExecutionRequestId(executionRequestId).stream().flatMap(testRun -> this.logRecordService.getAllFailedLogRecordsByTestRunId(testRun.getUuid()).stream()).collect(Collectors.toList());
        ArrayList createdIssues = new ArrayList();
        logRecords.forEach(logRecord -> {
            if (!Strings.isNullOrEmpty((String)logRecord.getMessage())) {
                this.addIssueToList(issue -> issue.getMessage().equals(logRecord.getMessage()), () -> this.createIssue((LogRecord)logRecord, executionRequestId), createdIssues, (LogRecord)logRecord);
            }
        });
        log.debug("Final issue list: {}, Execution Request id: {}", createdIssues, (Object)executionRequestId);
        this.repository.saveAll(createdIssues);
    }

    private void purgeOldPatternIssues(UUID failPatternId, UUID executionRequestId) {
        log.debug("Issue purge by Fail Pattern: {}, Execution Request id: {}", (Object)failPatternId, (Object)executionRequestId);
        List<Issue> oldPatternIssues = this.repository.findByFailPatternIdAndExecutionRequestId(failPatternId, executionRequestId);
        this.repository.deleteAll(oldPatternIssues);
    }

    private Issue createIssue(LogRecord logRecord, UUID executionRequestId) {
        UUID logRecordId = logRecord.getUuid();
        log.debug("Creating a new issue for log record '{}' and execution request '{}'", (Object)logRecord, (Object)executionRequestId);
        Issue issue = new Issue();
        issue.setLogRecordIds(new ArrayList());
        issue.getLogRecordIds().add(logRecordId);
        issue.setFailedTestRunIds(new ArrayList());
        issue.setExecutionRequestId(executionRequestId);
        issue.setMessage(logRecord.getMessage());
        issue.setFailedTestRunsCount(0);
        log.debug("Created issue: {}", (Object)issue);
        return issue;
    }

    private Issue createIssue(LogRecord logRecord, UUID executionRequestId, FailPattern failPattern) {
        UUID logRecordId = logRecord.getUuid();
        UUID failPatternId = failPattern.getUuid();
        log.debug("Creating a new issue for log record '{}' and and execution request '{}' and fail pattern '{}'", new Object[]{logRecordId, executionRequestId, failPattern});
        Issue issue = this.createIssue(logRecord, executionRequestId);
        issue.setMessage(failPattern.getMessage());
        issue.setJiraTickets(failPattern.getJiraTickets());
        issue.setJiraDefects(failPattern.getJiraDefects());
        issue.setFailPatternId(failPatternId);
        issue.setFailReasonId(failPattern.getFailReasonId());
        issue.setPriority(failPattern.getPriority());
        log.debug("Created issue: {}", (Object)issue);
        return issue;
    }

    public List<FailPattern> findMatchingFailPatterns(UUID executionRequestId, String message, Map<Pattern, FailPattern> compiledPatterns) {
        ArrayList<FailPattern> matchedFailPatterns = new ArrayList<FailPattern>();
        compiledPatterns.keySet().forEach(pattern -> {
            try {
                if (Objects.nonNull(message) && pattern.matcher((CharSequence)new TimeoutRegexCharSequence((CharSequence)message, this.regexpTimeout)).find()) {
                    matchedFailPatterns.add((FailPattern)compiledPatterns.get(pattern));
                }
            }
            catch (StackOverflowError error) {
                this.processStackOverflowErrorDuringPatternMatch(executionRequestId, error, (Pattern)pattern, message);
            }
            catch (TimeoutRegexException e) {
                log.error("Timeout error on regexp processing, pattern:{}, Execution Request id {}", (Object)pattern.pattern(), (Object)executionRequestId);
                log.error("Timeout error on regexp processing, error message: ", (Throwable)e);
            }
        });
        return matchedFailPatterns;
    }

    private void processStackOverflowErrorDuringPatternMatch(UUID executionRequestId, StackOverflowError error, Pattern pattern, String message) {
        String errorMessage = String.format("StackOverflowError during matching: pattern = %s, message = %s", pattern, message);
        log.error(errorMessage, (Throwable)error);
        this.executionRequestDetailsService.createDetails(executionRequestId, TestingStatuses.WARNING, errorMessage);
    }

    private void addIssueToList(Predicate<Issue> issueCheck, Supplier<Issue> newIssueSupplier, List<Issue> createdIssues, LogRecord logRecord) {
        Issue existingIssue = createdIssues.stream().filter(issueCheck).findFirst().orElseGet(() -> {
            Issue newIssue = (Issue)newIssueSupplier.get();
            createdIssues.add(newIssue);
            return newIssue;
        });
        this.updateExistingIssue(existingIssue, logRecord);
    }

    private void updateExistingIssue(Issue existingIssue, LogRecord logRecord) {
        UUID logRecordId;
        List logRecords;
        UUID logRecordTestRunId;
        List testRuns = existingIssue.getFailedTestRunIds();
        if (!testRuns.contains(logRecordTestRunId = logRecord.getTestRunId())) {
            testRuns.add(logRecordTestRunId);
            existingIssue.setFailedTestRunsCount(existingIssue.getFailedTestRunsCount() + 1);
        }
        if (!(logRecords = existingIssue.getLogRecordIds()).contains(logRecordId = logRecord.getUuid())) {
            logRecords.add(logRecordId);
        }
        log.debug("Updated Test Runs and Log Records with issue: {}", (Object)existingIssue);
    }

    private List<IssueResponse> getResponses(List<Issue> issues) {
        Set<UUID> issueFailPatternIds = StreamUtils.extractIds(issues, Issue::getFailPatternId);
        List<FailPattern> failPatterns = this.failPatternService.getFailPatternsByIds(issueFailPatternIds);
        Map<UUID, FailPattern> failPatternMap = StreamUtils.toIdEntityMap(failPatterns);
        Set<UUID> issueFailedTestRunIds = StreamUtils.extractFlatIds(issues, Issue::getFailedTestRunIds);
        List<TestRun> issueFailedTestRuns = this.testRunService.getShortTestRunsByIds(issueFailedTestRunIds);
        List<FailPatternResponse> failPatternResponses = this.failPatternService.getResponses(failPatterns);
        Map<UUID, FailPatternResponse> failPatternResponsesMap = StreamUtils.toIdEntityMap(failPatternResponses);
        return issues.stream().map(issue -> {
            FailPattern failPattern;
            IssueResponse issueResponse = (IssueResponse)this.modelMapper.map(issue, IssueResponse.class);
            List testRuns = StreamUtils.filterList(issueFailedTestRuns, issue.getFailedTestRunIds());
            IssueTestRunResponse testRunResponses = StreamUtils.mapToClazz(testRuns, IssueTestRunResponse.class);
            issueResponse.setTestRuns((List)testRunResponses);
            FailPatternResponse issueFailPattern = issueResponse.getFailPattern();
            if (Objects.nonNull(issueFailPattern) && Objects.nonNull(failPattern = (FailPattern)failPatternMap.get(issue.getFailPatternId()))) {
                FailPatternResponse failPatternResponse = (FailPatternResponse)failPatternResponsesMap.get(failPattern.getUuid());
                failPatternResponse.setJiraTickets(issue.getJiraTickets());
                issueResponse.setFailReason(failPatternResponse.getFailReason());
                issueResponse.setFailPattern(failPatternResponse);
            }
            return issueResponse;
        }).collect(Collectors.toList());
    }

    public UUID getProjectIdByIssueId(UUID issueId) {
        return this.customIssueRepository.getProjectIdByIssueId(issueId);
    }

    public void deleteAllIssueByExecutionRequestIds(List<UUID> executionRequestIds) {
        this.repository.deleteAllByExecutionRequestIdIn(executionRequestIds);
    }
}

