/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.qubership.atp.ram.dto.response.ContextVariablesResponse;
import org.qubership.atp.ram.enums.ContextVariablesActiveTab;
import org.qubership.atp.ram.models.logrecords.parts.ContextVariable;
import org.qubership.atp.ram.utils.ListUtils;
import org.springframework.stereotype.Service;

@Service
public class LogRecordContextVariableService {
    public ContextVariablesResponse getPagedContextVariables(List<ContextVariable> allContextVariables, Integer page, Integer size, List<ContextVariablesActiveTab> activeTabs) {
        ContextVariablesResponse response = new ContextVariablesResponse();
        ContextVariablesResponse splitVariables = this.splitContextVariables(allContextVariables);
        List modifiedVars = splitVariables.getModified();
        List notModifiedVars = splitVariables.getNotModified();
        int notModifiedCount = notModifiedVars.size();
        boolean isSizeSplit = notModifiedCount % size != 0;
        int sizeSplitPage = (int)Math.floor((double)notModifiedCount / (double)size.intValue());
        int shift = notModifiedCount % size;
        int totalPages = (int)Math.ceil((double)allContextVariables.size() / (double)size.intValue());
        response.setTotalPageCount(totalPages);
        response.setTotalItemCount(allContextVariables.size());
        ContextVariablesActiveTab modifiedTab = ContextVariablesActiveTab.MODIFIED;
        ContextVariablesActiveTab notModifiedTab = ContextVariablesActiveTab.NOT_MODIFIED;
        List<ContextVariablesActiveTab> allTabs = Arrays.asList(modifiedTab, notModifiedTab);
        if (activeTabs.containsAll(allTabs)) {
            boolean applyModifiedPaging;
            List pagedNotModifiedVars = ListUtils.applyPagination(notModifiedVars, page, size, null);
            response.setNotModified(pagedNotModifiedVars);
            boolean bl = applyModifiedPaging = CollectionUtils.isEmpty(pagedNotModifiedVars) || pagedNotModifiedVars.size() != size.intValue();
            if (applyModifiedPaging) {
                List<ContextVariable> pagedModifiedVars = this.getPagedModifiedContextVariables(modifiedVars, page, size, shift, isSizeSplit, sizeSplitPage);
                response.setModified(pagedModifiedVars);
            }
        } else if (activeTabs.contains(modifiedTab)) {
            response.setModified(ListUtils.applyPagination(modifiedVars, page, size, null));
        } else if (activeTabs.contains(notModifiedTab)) {
            response.setNotModified(ListUtils.applyPagination(notModifiedVars, page, size, null));
        }
        return response;
    }

    private List<ContextVariable> getPagedModifiedContextVariables(List<ContextVariable> modifiedVars, int page, int size, int shift, boolean isSizeSplit, int sizeSplitPage) {
        if (isSizeSplit) {
            boolean isSizeSplitPage;
            boolean bl = isSizeSplitPage = page == sizeSplitPage;
            if (isSizeSplitPage) {
                return ListUtils.applyPagination(modifiedVars, page - sizeSplitPage, size - shift, null);
            }
            return ListUtils.applyPagination(modifiedVars, page - ++sizeSplitPage, size, size - shift);
        }
        return ListUtils.applyPagination(modifiedVars, page - sizeSplitPage, size, null);
    }

    private ContextVariablesResponse splitContextVariables(List<ContextVariable> allContextVariables) {
        ContextVariablesResponse response = new ContextVariablesResponse();
        if (CollectionUtils.isEmpty(allContextVariables)) {
            return response;
        }
        List notModified = response.getNotModified();
        List modified = response.getModified();
        allContextVariables.forEach(contextVariable -> {
            String beforeValue = contextVariable.getBeforeValue();
            String afterValue = contextVariable.getAfterValue();
            if (Objects.nonNull(beforeValue) && Objects.nonNull(afterValue) && beforeValue.equals(afterValue)) {
                notModified.add(contextVariable);
            } else {
                modified.add(contextVariable);
            }
        });
        Collections.sort(notModified);
        Collections.sort(modified);
        return response;
    }

    public ContextVariablesResponse filterAndSplitContextVariables(List<ContextVariable> contextVariables, List<String> parameters, String beforeValue, String afterValue) {
        ContextVariablesResponse response = this.splitContextVariables(contextVariables);
        List<ContextVariable> filteredModifiedVariables = this.filterContextVariables(response.getModified(), parameters, beforeValue, afterValue);
        response.setModified(filteredModifiedVariables);
        List<ContextVariable> filteredNotModifiedVariables = this.filterContextVariables(response.getNotModified(), parameters, beforeValue, afterValue);
        response.setNotModified(filteredNotModifiedVariables);
        return response;
    }

    public List<ContextVariable> filterContextVariables(List<ContextVariable> contextVariables, List<String> parameters, String beforeValue, String afterValue) {
        if (contextVariables == null) {
            contextVariables = Collections.emptyList();
        } else {
            ArrayList<Predicate<ContextVariable>> predicates = new ArrayList<Predicate<ContextVariable>>();
            if (parameters != null && !parameters.isEmpty()) {
                HashSet<String> paramsSet = new HashSet<String>(parameters);
                predicates.add(variable -> paramsSet.stream().anyMatch(param -> StringUtils.containsIgnoreCase((String)variable.getName(), (String)param)));
            }
            if (StringUtils.isNotEmpty((String)beforeValue)) {
                predicates.add(variable -> variable.getBeforeValue() != null && StringUtils.containsIgnoreCase((String)variable.getBeforeValue(), (String)beforeValue));
            }
            if (StringUtils.isNotEmpty((String)afterValue)) {
                predicates.add(variable -> variable.getAfterValue() != null && StringUtils.containsIgnoreCase((String)variable.getAfterValue(), (String)afterValue));
            }
            contextVariables = contextVariables.stream().filter(variable -> predicates.stream().allMatch(predicate -> predicate.test(variable))).collect(Collectors.toList());
        }
        return contextVariables;
    }
}

