/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpEntityNotFoundException;
import org.qubership.atp.ram.dto.response.ProjectDataResponse;
import org.qubership.atp.ram.models.Project;
import org.qubership.atp.ram.repositories.ProjectsRepository;
import org.qubership.atp.ram.services.CatalogueService;
import org.qubership.atp.ram.services.CrudService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.stereotype.Service;

@Service
public class ProjectsService
extends CrudService<Project> {
    private static final Logger log = LoggerFactory.getLogger(ProjectsService.class);
    private final ProjectsRepository repository;
    private final CatalogueService catalogueService;

    @Override
    protected MongoRepository<Project, UUID> repository() {
        return this.repository;
    }

    public Project getProjectById(UUID projectId) {
        return (Project)this.get(projectId);
    }

    public List<Project> getAllProjects() {
        return this.repository.findAll();
    }

    public List<Project> getProjectsByIds(Collection<UUID> ids) {
        return this.repository.findByUuidIn(ids);
    }

    private Project getProjectByName(String projectName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectName) ? 1 : 0) != 0, (Object)"ProjectName is required!");
        return this.repository.findByName(projectName);
    }

    @Deprecated
    public synchronized Project findOrCreateProjectByName(String projectName) {
        Project result = this.getProjectByName(projectName);
        if (Objects.nonNull(result)) {
            log.debug("Project exists {} by name", (Object)result.getUuid());
            return result;
        }
        result = new Project();
        result.setName(projectName);
        this.repository.save(result);
        log.debug("Project create {} by name", (Object)result.getUuid());
        return result;
    }

    @Deprecated
    public synchronized Project findOrCreateProjectByUuid(UUID projectUuid, String projectName) {
        Project result = this.repository.findByUuid(projectUuid);
        if (Objects.nonNull(result)) {
            log.debug("Project exists {} by ID", (Object)result.getUuid());
            return result;
        }
        result = new Project();
        result.setName(projectName);
        result.setUuid(projectUuid);
        this.repository.save(result);
        log.debug("Project created {} by ID", (Object)result.getUuid());
        return result;
    }

    public String getProjectName(UUID projectUuid) {
        return this.repository.findNameByUuid(projectUuid).getName();
    }

    @Deprecated
    public Project findByUuidNameOrCreateNew(Project project) {
        if (project.getUuid() != null) {
            return this.findOrCreateProjectByUuid(project.getUuid(), project.getName());
        }
        String projectName = project.getName();
        Project result = this.getProjectByName(projectName);
        if (Objects.isNull(result)) {
            log.error("Failed to find Project by name: {}", (Object)projectName);
            throw new AtpEntityNotFoundException("Project", "name", (Object)projectName);
        }
        return result;
    }

    public void deleteByUuid(UUID uuid) {
        this.repository.deleteByUuid(uuid);
    }

    public void synchronizeProjectData(Project project) {
        try {
            ProjectDataResponse projectData = this.catalogueService.getProjectData(project.getUuid());
            project.setTroubleShooterUrl(projectData.getTshooterUrl());
            project.setMissionControlToolUrl(projectData.getMissionControlToolUrl());
            project.setMonitoringToolUrl(projectData.getMonitoringToolUrl());
        }
        catch (Exception e) {
            log.error("Failed to synchronize project data", (Throwable)e);
        }
    }

    public ProjectsService(ProjectsRepository repository, CatalogueService catalogueService) {
        this.repository = repository;
        this.catalogueService = catalogueService;
    }
}

