/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.modelmapper.ModelMapper;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpEntityNotFoundException;
import org.qubership.atp.ram.dto.response.ExecutionSummaryResponse;
import org.qubership.atp.ram.dto.response.LabelNodeReportResponse;
import org.qubership.atp.ram.dto.response.RootCausesStatisticResponse;
import org.qubership.atp.ram.dto.response.ServerSummaryResponse;
import org.qubership.atp.ram.entities.treenodes.labelparams.ReportLabelParam;
import org.qubership.atp.ram.entities.treenodes.labelparams.TestingReportLabelParam;
import org.qubership.atp.ram.enums.ExecutionRequestWidgets;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.TestScopeSections;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.model.datacontext.TestRunsDataContext;
import org.qubership.atp.ram.model.datacontext.TestRunsDataContextLoadOptions;
import org.qubership.atp.ram.models.EnvironmentsInfo;
import org.qubership.atp.ram.models.ExecutionRequest;
import org.qubership.atp.ram.models.FinalRunData;
import org.qubership.atp.ram.models.LabelTemplate;
import org.qubership.atp.ram.models.RamObject;
import org.qubership.atp.ram.models.RerunDetails;
import org.qubership.atp.ram.models.Scope;
import org.qubership.atp.ram.models.SystemInfo;
import org.qubership.atp.ram.models.TestCaseWidgetReportRequest;
import org.qubership.atp.ram.models.TestRun;
import org.qubership.atp.ram.models.TestRunSearchRequest;
import org.qubership.atp.ram.models.ValidationLabelConfigTemplate;
import org.qubership.atp.ram.models.WidgetConfigTemplate;
import org.qubership.atp.ram.models.tree.TreeWalker;
import org.qubership.atp.ram.repositories.ExecutionRequestRepository;
import org.qubership.atp.ram.services.CatalogueService;
import org.qubership.atp.ram.services.EnvironmentsInfoService;
import org.qubership.atp.ram.services.EnvironmentsService;
import org.qubership.atp.ram.services.LabelTemplateNodeService;
import org.qubership.atp.ram.services.LabelsService;
import org.qubership.atp.ram.services.TestRunService;
import org.qubership.atp.ram.services.TreeNodeService;
import org.qubership.atp.ram.services.ValidationLabelConfigTemplateService;
import org.qubership.atp.ram.services.WidgetConfigTemplateService;
import org.qubership.atp.ram.utils.RateCalculator;
import org.qubership.atp.ram.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReportService {
    private static final Logger log = LoggerFactory.getLogger(ReportService.class);
    @Value(value="${catalogue.url}")
    private String catalogueUrl;
    private final EnvironmentsInfoService environmentsInfoService;
    private final EnvironmentsService environmentsService;
    private final ExecutionRequestRepository executionRequestRepository;
    private final TestRunService testRunService;
    private final LabelTemplateNodeService labelTemplateNodeService;
    private final LabelsService labelsService;
    private final ModelMapper modelMapper;
    private final ValidationLabelConfigTemplateService validationLabelConfigTemplateService;
    private final WidgetConfigTemplateService widgetConfigService;
    private final TreeNodeService treeNodeService;
    private final RateCalculator rateCalculator;
    private final CatalogueService catalogueService;

    @Nullable
    public UUID getProjectIdByExecutionRequestId(UUID executionRequestId) {
        ExecutionRequest executionRequest = this.executionRequestRepository.findProjectIdByUuid(executionRequestId);
        if (Objects.isNull(executionRequest)) {
            log.error("Failed to find execution request with id: {} ", (Object)executionRequestId);
            throw new AtpEntityNotFoundException("Execution request", (Object)executionRequestId);
        }
        return executionRequest.getProjectId();
    }

    public List<ServerSummaryResponse> getServerSummaryForExecutionRequest(UUID erId) {
        log.info("Getting environments info by ER {}", (Object)erId);
        EnvironmentsInfo environmentsInfo = this.environmentsInfoService.findQaTaSystemsByExecutionRequestId(erId);
        ArrayList<ServerSummaryResponse> summaryResponses = new ArrayList<ServerSummaryResponse>();
        summaryResponses.addAll(this.getServerSummaryBySystemInfo(environmentsInfo.getQaSystemInfoList()));
        summaryResponses.addAll(this.getServerSummaryBySystemInfo(environmentsInfo.getTaSystemInfoList()));
        return summaryResponses;
    }

    private List<ServerSummaryResponse> getServerSummaryBySystemInfo(List<SystemInfo> systemInfoList) {
        ArrayList<ServerSummaryResponse> summaryResponsesList = new ArrayList<ServerSummaryResponse>();
        systemInfoList.forEach(systemInfo -> systemInfo.getUrls().forEach(url -> {
            ServerSummaryResponse serverSummaryResponse = new ServerSummaryResponse();
            serverSummaryResponse.setBuild(Collections.singletonList(systemInfo.getVersion()));
            serverSummaryResponse.setServer(url);
            summaryResponsesList.add(serverSummaryResponse);
        }));
        return summaryResponsesList;
    }

    public List<RootCausesStatisticResponse> getRootCausesStatisticForExecutionRequestAndPrevious(UUID erId) {
        ExecutionRequest executionRequest = this.executionRequestRepository.findNameStartDatePreviousErIdByUuid(erId);
        ArrayList<RootCausesStatisticResponse> result = new ArrayList<RootCausesStatisticResponse>();
        result.add(this.getRootCauseStatisticForEr(executionRequest));
        UUID previousExecutionRequestId = executionRequest.getPreviousExecutionRequestId();
        if (Objects.nonNull(previousExecutionRequestId)) {
            ExecutionRequest previousExecutionRequest = this.executionRequestRepository.findNameStartDatePreviousErIdByUuid(previousExecutionRequestId);
            result.add(this.getRootCauseStatisticForEr(previousExecutionRequest));
        }
        return result;
    }

    private RootCausesStatisticResponse getRootCauseStatisticForEr(ExecutionRequest executionRequest) {
        if (Objects.isNull(executionRequest)) {
            log.error("Failed to find Execution Request");
            throw new AtpEntityNotFoundException("Execution Request");
        }
        RootCausesStatisticResponse rootCausesStatisticResponse = new RootCausesStatisticResponse();
        rootCausesStatisticResponse.setExecutionRequestName(executionRequest.getName());
        rootCausesStatisticResponse.setStartDate(executionRequest.getStartDate());
        Map<String, Integer> rootCauses = this.testRunService.getTestRunsGroupedByRootCauses(executionRequest.getUuid());
        ArrayList rootCausesGroups = new ArrayList();
        Long countTestRunsForEr = this.testRunService.countAllByExecutionRequestId(executionRequest.getUuid());
        rootCauses.forEach((rootCauseName, rootCauseCount) -> {
            long percent = countTestRunsForEr > 0L ? Math.round(rootCauseCount.doubleValue() / countTestRunsForEr.doubleValue() * 100.0) : 0L;
            rootCausesGroups.add(new RootCausesStatisticResponse.RootCausesGroup(rootCauseName, rootCauseCount, percent));
        });
        rootCausesStatisticResponse.setRootCausesGroups(rootCausesGroups);
        return rootCausesStatisticResponse;
    }

    public LabelNodeReportResponse getTestCasesForExecutionRequest(UUID erId, UUID labelTemplateId, UUID validationTemplateId, boolean isExecutionRequestsSummary, TestCaseWidgetReportRequest request) {
        List<TestRun> testRuns;
        WidgetConfigTemplate.Filters widgetConfigFilters;
        Map<UUID, RerunDetails> rerunDetailsMapping = new HashMap<UUID, RerunDetails>();
        ExecutionRequest executionRequest = this.executionRequestRepository.findByUuid(erId);
        UUID testCasesWidgetId = ExecutionRequestWidgets.TEST_CASES.getWidgetId();
        validationTemplateId = Objects.isNull(validationTemplateId) ? this.widgetConfigService.getValidationTemplateIdByErWidget(executionRequest, testCasesWidgetId) : validationTemplateId;
        ValidationLabelConfigTemplate validationTemplate = null;
        if (Objects.nonNull(validationTemplateId)) {
            validationTemplate = (ValidationLabelConfigTemplate)this.validationLabelConfigTemplateService.get(validationTemplateId);
        }
        if (Objects.isNull(widgetConfigFilters = this.resolveWidgetConfigFilters(request, executionRequest))) {
            testRuns = this.testRunService.findAllByExecutionRequestId(erId);
        } else {
            Set status = widgetConfigFilters.getTestingStatuses();
            Set failureReasons = widgetConfigFilters.getFailureReasons();
            TestRunSearchRequest searchRequest = new TestRunSearchRequest();
            searchRequest.setExecutionRequestId(erId);
            searchRequest.setFailureReasons(failureReasons);
            searchRequest.setInTestingStatuses(status);
            testRuns = this.testRunService.search(searchRequest, 0, Integer.MAX_VALUE).getEntities();
        }
        UUID initialErId = executionRequest.getInitialExecutionRequestId();
        if (isExecutionRequestsSummary) {
            testRuns = this.getSummaryTestRunsAndSetRerunMapping(initialErId, testRuns, rerunDetailsMapping);
        } else {
            boolean isRerun = Objects.nonNull(initialErId);
            Map<UUID, RerunDetails> map = rerunDetailsMapping = isRerun ? this.getRerunMapping(initialErId, testRuns, isRerun) : this.getRerunMapping(erId, testRuns, isRerun);
        }
        if (testRuns != null && !testRuns.isEmpty()) {
            testRuns = testRuns.stream().sorted(Comparator.comparing(RamObject::getName)).collect(Collectors.toList());
        }
        TestRunsDataContextLoadOptions dataContextLoadOptions = new TestRunsDataContextLoadOptions().includeRunFailedLogRecordsMap().includeRunValidationLogRecordsMap().includeRunTestCasesMap().includeTestRunDslNamesMap().includeRootCausesMap();
        TestRunsDataContext dataContext = this.testRunService.getTestRunsDataContext(testRuns, dataContextLoadOptions, false);
        dataContext.setExecutionRequestId(erId);
        UUID testScopeId = executionRequest.getTestScopeId();
        boolean isScopeRun = Objects.nonNull(testScopeId);
        log.debug("Scope run: {}", (Object)isScopeRun);
        LabelNodeReportResponse rootNode = new LabelNodeReportResponse();
        if (Objects.isNull(labelTemplateId)) {
            labelTemplateId = this.widgetConfigService.defineLabelTemplateId(executionRequest, testCasesWidgetId);
        }
        if (Objects.isNull(labelTemplateId)) {
            rootNode = isScopeRun ? this.getTestScopeResponse(rootNode, testRuns, null, validationTemplate, dataContext) : this.getLabelNodeReportResponseWithoutTemplate(testRuns, validationTemplate, dataContext);
        } else {
            LabelTemplate labelTemplate = this.labelTemplateNodeService.getLabelTemplate(labelTemplateId);
            rootNode.setLabelTemplateId(labelTemplate.getUuid());
            rootNode.setLabelTemplateName(labelTemplate.getName());
            if (isScopeRun) {
                rootNode = this.getTestScopeResponse(rootNode, testRuns, labelTemplateId, validationTemplate, dataContext);
            } else {
                LabelTemplate filledTemplate = this.labelTemplateNodeService.populateLabelTemplateWithTestRuns(testRuns, labelTemplate);
                Set testRunIds = filledTemplate.getUnknownNode().getTestRunIds();
                List<TestRun> unknownTestRuns = StreamUtils.filterList(testRuns, testRunIds);
                List<LabelNodeReportResponse.TestRunNodeResponse> testRunsForDefaultNode = this.testRunService.getTestRunNodeWithFailedLogRecords(unknownTestRuns, validationTemplate, dataContext);
                rootNode.setTestRuns(testRunsForDefaultNode);
                List labelNodes = filledTemplate.getLabelNodes();
                this.fillLabelReportsNode(labelNodes, rootNode, validationTemplate, testRuns, dataContext);
            }
        }
        this.setValidationLabelsOrder(rootNode, validationTemplate);
        this.removeEmptyNodes(rootNode);
        this.updateWithRerunDetailsRecursively(rootNode, rerunDetailsMapping, widgetConfigFilters);
        this.removeEmptyNodes(rootNode);
        return rootNode;
    }

    public WidgetConfigTemplate.Filters resolveWidgetConfigFilters(TestCaseWidgetReportRequest request, ExecutionRequest executionRequest) {
        WidgetConfigTemplate.Filters filters = request.getFilters();
        if (Objects.nonNull(filters)) {
            return filters;
        }
        UUID widgetConfigTemplateId = executionRequest.getWidgetConfigTemplateId();
        WidgetConfigTemplate widgetConfigTemplate = Objects.nonNull(widgetConfigTemplateId) ? (WidgetConfigTemplate)this.widgetConfigService.get(widgetConfigTemplateId) : this.widgetConfigService.getWidgetConfigTemplateForEr(executionRequest).getTemplate();
        if (Objects.nonNull(widgetConfigTemplate)) {
            WidgetConfigTemplate.WidgetConfig testCasesWidgetConfig = widgetConfigTemplate.getWidgetConfig(ExecutionRequestWidgets.TEST_CASES.getWidgetId());
            filters = testCasesWidgetConfig.getFilters();
        }
        return filters;
    }

    protected List<TestRun> getSummaryTestRunsAndSetRerunMapping(UUID initialErId, List<TestRun> testRuns, Map<UUID, RerunDetails> rerunDetailsMapping) {
        Map<UUID, TestRun> finalTestRunMapping = this.getFinalTrMapping(initialErId);
        List<TestRun> initialTestRuns = this.testRunService.findAllByExecutionRequestId(initialErId);
        ArrayList<TestRun> summaryTestRuns = new ArrayList<TestRun>();
        initialTestRuns.forEach(initialTestRun -> {
            UUID initialTestRunId = initialTestRun.getUuid();
            Optional<TestRun> matchRun = testRuns.stream().filter(testRun -> testRun.getInitialTestRunId().equals(initialTestRunId)).findFirst();
            TestRun summaryTestRun = matchRun.orElse((TestRun)initialTestRun);
            RerunDetails rerunDetails = new RerunDetails();
            matchRun.ifPresent(testRun -> rerunDetails.setTestingStatus(testRun.getTestingStatus()));
            rerunDetails.setFirstStatus(initialTestRun.getTestingStatus());
            TestRun finalRun = summaryTestRun;
            for (Map.Entry entry : finalTestRunMapping.entrySet()) {
                TestRun finalTr = (TestRun)entry.getValue();
                if (!finalTr.getUuid().equals(initialTestRunId) && (finalTr.getInitialTestRunId() == null || !finalTr.getInitialTestRunId().equals(initialTestRunId))) continue;
                finalRun = finalTr;
            }
            rerunDetails.setFinalStatus(finalRun.getTestingStatus());
            FinalRunData finalRunData = new FinalRunData(finalRun.getExecutionRequestId(), finalRun.getUuid());
            rerunDetails.setFinalRunData(finalRunData);
            rerunDetailsMapping.put(finalRun.getUuid(), rerunDetails);
            summaryTestRuns.add(finalRun);
        });
        return summaryTestRuns;
    }

    protected Map<UUID, TestRun> getFinalTrMapping(UUID initialErId) {
        HashMap<UUID, TestRun> finalTestRuns = new HashMap<UUID, TestRun>();
        List<ExecutionRequest> rerunExecutionRequests = this.executionRequestRepository.findAllByInitialExecutionRequestId(initialErId);
        ExecutionRequest initialExecutionRequest = this.executionRequestRepository.findByUuid(initialErId);
        ArrayList<ExecutionRequest> targetExecutionRequests = new ArrayList<ExecutionRequest>(rerunExecutionRequests);
        targetExecutionRequests.add(initialExecutionRequest);
        targetExecutionRequests.forEach(executionRequest -> {
            List<TestRun> testRuns = this.testRunService.findAllByExecutionRequestId(executionRequest.getUuid());
            Map executionRequestFinalTestRuns = testRuns.stream().filter(TestRun::isFinalTestRun).collect(Collectors.toMap(RamObject::getUuid, Function.identity()));
            finalTestRuns.putAll(executionRequestFinalTestRuns);
        });
        return finalTestRuns;
    }

    private Map<UUID, RerunDetails> getRerunMapping(UUID initialErId, List<TestRun> testRuns, boolean isRerun) {
        HashMap<UUID, RerunDetails> rerunDetailsMapping = new HashMap<UUID, RerunDetails>();
        if (isRerun) {
            List<TestRun> initialTestRuns = this.testRunService.findAllByExecutionRequestId(initialErId);
            Map<UUID, TestRun> initialTestRunsMapping = StreamUtils.toIdEntityMap(initialTestRuns, RamObject::getUuid);
            testRuns.forEach(run -> {
                UUID initialTestRunId = run.getInitialTestRunId();
                TestRun initialTestRun = (TestRun)initialTestRunsMapping.get(initialTestRunId);
                RerunDetails rerunDetails = new RerunDetails();
                rerunDetails.setTestingStatus(run.getTestingStatus());
                if (!Objects.isNull(initialTestRun)) {
                    rerunDetails.setFirstStatus(initialTestRun.getTestingStatus());
                }
                rerunDetails.setFinalStatus(run.getTestingStatus());
                rerunDetails.setFinalRunData(new FinalRunData(run.getExecutionRequestId(), run.getUuid()));
                rerunDetailsMapping.put(run.getUuid(), rerunDetails);
            });
        } else {
            Map<UUID, TestRun> finalTrMapping = this.getFinalTrMapping(initialErId);
            testRuns.forEach(run -> {
                UUID testRunId = run.getUuid();
                TestRun finalTestRun = finalTrMapping.getOrDefault(testRunId, (TestRun)run);
                RerunDetails rerunDetails = new RerunDetails();
                rerunDetails.setTestingStatus(run.getTestingStatus());
                rerunDetails.setFinalRunData(new FinalRunData(finalTestRun.getExecutionRequestId(), finalTestRun.getUuid()));
                rerunDetailsMapping.put(testRunId, rerunDetails);
            });
        }
        return rerunDetailsMapping;
    }

    void updateWithRerunDetailsRecursively(LabelNodeReportResponse rootNode, Map<UUID, RerunDetails> rerunDetailsMapping, WidgetConfigTemplate.Filters widgetConfigFilters) {
        List childrenNodes;
        List testRuns = rootNode.getTestRuns();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)testRuns)) {
            List processedTestRuns = testRuns.stream().peek(testRun -> {
                RerunDetails details = (RerunDetails)rerunDetailsMapping.get(testRun.getUuid());
                testRun.setTestingStatus(details.getTestingStatus());
                testRun.setFirstStatus(details.getFirstStatus());
                testRun.setFinalStatus(details.getFinalStatus());
                testRun.setFinalRun(details.getFinalRunData());
            }).filter(testRun -> this.filterByWidgetConfigFilters((LabelNodeReportResponse.TestRunNodeResponse)testRun, widgetConfigFilters)).collect(Collectors.toList());
            rootNode.setTestRuns(processedTestRuns);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(childrenNodes = rootNode.getChildren()))) {
            childrenNodes.forEach(childrenNode -> this.updateWithRerunDetailsRecursively((LabelNodeReportResponse)childrenNode, rerunDetailsMapping, widgetConfigFilters));
        }
    }

    boolean filterByWidgetConfigFilters(LabelNodeReportResponse.TestRunNodeResponse testRunNode, WidgetConfigTemplate.Filters filters) {
        HashSet<Predicate<LabelNodeReportResponse.TestRunNodeResponse>> conditions = new HashSet<Predicate<LabelNodeReportResponse.TestRunNodeResponse>>();
        if (Objects.nonNull(filters)) {
            Set finalStatuses;
            Set firstStatuses = filters.getFirstStatuses();
            if (!CollectionUtils.isEmpty((Collection)firstStatuses)) {
                conditions.add(node -> firstStatuses.contains(node.getFirstStatus()));
            }
            if (!CollectionUtils.isEmpty((Collection)(finalStatuses = filters.getFinalStatuses()))) {
                conditions.add(node -> finalStatuses.contains(node.getFinalStatus()));
            }
            return conditions.stream().allMatch(condition -> condition.test(testRunNode));
        }
        return true;
    }

    public void removeEmptyNodes(LabelNodeReportResponse rootNode) {
        TreeWalker treeWalker = new TreeWalker();
        treeWalker.walkWithPostProcess((Object)rootNode, LabelNodeReportResponse::getChildren, (root, child) -> {
            if (Objects.nonNull(root)) {
                List rootChildren = root.getChildren();
                if (CollectionUtils.isEmpty((Collection)child.getChildren()) && CollectionUtils.isEmpty((Collection)child.getTestRuns())) {
                    List nodesWithNonEmptyChildren = rootChildren.stream().filter(rootChild -> !rootChild.getLabelName().equals(child.getLabelName())).collect(Collectors.toList());
                    root.setChildren(nodesWithNonEmptyChildren);
                }
            }
        });
    }

    private LabelNodeReportResponse getTestScopeResponse(LabelNodeReportResponse rootNode, List<TestRun> testRuns, UUID labelTemplateId, ValidationLabelConfigTemplate validationTemplate, TestRunsDataContext dataContext) {
        List<LabelNodeReportResponse> scopeGroupNodes = Arrays.asList(new LabelNodeReportResponse(TestScopeSections.PREREQUISITES.getName(), true, () -> StreamUtils.filterByTestScopeSection(testRuns, TestRun::getTestScopeSection, TestScopeSections.PREREQUISITES)), new LabelNodeReportResponse(TestScopeSections.EXECUTION.getName(), true, () -> StreamUtils.filterByTestScopeSection(testRuns, TestRun::getTestScopeSection, TestScopeSections.EXECUTION)), new LabelNodeReportResponse(TestScopeSections.VALIDATION.getName(), true, () -> StreamUtils.filterByTestScopeSection(testRuns, TestRun::getTestScopeSection, TestScopeSections.VALIDATION)));
        scopeGroupNodes.forEach(node -> {
            List<TestRun> scopeGroupTestRuns = (List<TestRun>)node.getTestRunsFilterFunc().get();
            if (!scopeGroupTestRuns.isEmpty()) {
                List<LabelNodeReportResponse.TestRunNodeResponse> testRunResponses;
                if (Objects.nonNull(labelTemplateId)) {
                    LabelTemplate filledGroupNodeTemplate = this.labelTemplateNodeService.populateLabelTemplateWithTestRuns(scopeGroupTestRuns, labelTemplateId);
                    List labelNodes = filledGroupNodeTemplate.getLabelNodes();
                    this.fillLabelReportsNode(labelNodes, (LabelNodeReportResponse)node, validationTemplate, scopeGroupTestRuns, dataContext);
                    Set unknownTestRunIds = filledGroupNodeTemplate.getUnknownNode().getTestRunIds();
                    List<TestRun> unknownTestRuns = StreamUtils.filterList(testRuns, unknownTestRunIds);
                    testRunResponses = this.testRunService.getTestRunNodeWithFailedLogRecords(unknownTestRuns, validationTemplate, dataContext);
                } else {
                    scopeGroupTestRuns = this.treeNodeService.sortScopeGroupTestRuns(scopeGroupTestRuns);
                    testRunResponses = this.testRunService.getTestRunNodeWithFailedLogRecords(scopeGroupTestRuns, validationTemplate, dataContext);
                }
                HashMap<String, TestingStatuses> labelParamMap = new HashMap<String, TestingStatuses>();
                this.mergeLabelParams(labelParamMap, node.getChildren(), child -> child.getLabelParams().stream());
                node.setLabelParams(labelParamMap.entrySet().stream().map(entry -> new TestingReportLabelParam((String)entry.getKey(), (TestingStatuses)entry.getValue())).collect(Collectors.toList()));
                node.setTestRuns(testRunResponses);
            }
        });
        rootNode.setChildren(scopeGroupNodes);
        this.setValidationLabelsOrder(rootNode, validationTemplate);
        return rootNode;
    }

    private void setValidationLabelsOrder(LabelNodeReportResponse rootNode, ValidationLabelConfigTemplate template) {
        List children = rootNode.getChildren();
        List testRuns = rootNode.getTestRuns();
        Set<String> validationLabels = new HashSet<String>();
        if (CollectionUtils.isEmpty((Collection)children) && CollectionUtils.isEmpty((Collection)testRuns)) {
            return;
        }
        if (!CollectionUtils.isEmpty((Collection)children)) {
            validationLabels = children.stream().filter(child -> !CollectionUtils.isEmpty((Collection)child.getLabelParams())).flatMap(child -> child.getLabelParams().stream()).map(ReportLabelParam::getName).collect(Collectors.toSet());
        } else if (!CollectionUtils.isEmpty((Collection)testRuns)) {
            validationLabels = testRuns.stream().filter(testRun -> !CollectionUtils.isEmpty((Collection)testRun.getLabelParams())).flatMap(testRun -> testRun.getLabelParams().stream()).map(ReportLabelParam::getName).collect(Collectors.toSet());
        }
        List<String> orderedValidationLabels = this.treeNodeService.orderValidationLabels(validationLabels, template);
        rootNode.setValidationLabelsOrder(orderedValidationLabels);
    }

    private LabelNodeReportResponse getLabelNodeReportResponseWithoutTemplate(List<TestRun> testRuns, ValidationLabelConfigTemplate template, TestRunsDataContext dataContext) {
        LabelNodeReportResponse labelNodeReportResponse = new LabelNodeReportResponse();
        List<LabelNodeReportResponse.TestRunNodeResponse> testRunsResponses = this.testRunService.getTestRunNodeWithFailedLogRecords(testRuns, template, dataContext);
        labelNodeReportResponse.setTestRuns(testRunsResponses);
        return labelNodeReportResponse;
    }

    private void fillLabelReportsNode(List<LabelTemplate.LabelTemplateNode> labelNodes, LabelNodeReportResponse rootNode, ValidationLabelConfigTemplate template, List<TestRun> testRuns, TestRunsDataContext dataContext) {
        labelNodes.forEach(labelTemplateNode -> {
            if (!"Unknown".equals(labelTemplateNode.getLabelName())) {
                LabelNodeReportResponse reportNode = new LabelNodeReportResponse();
                reportNode.setPassedRate(labelTemplateNode.getPassedRate());
                reportNode.setLabelName(labelTemplateNode.getLabelName());
                if (!CollectionUtils.isEmpty((Collection)labelTemplateNode.getTestRunIds())) {
                    List<TestRun> nodeTestRuns = StreamUtils.filterList(testRuns, labelTemplateNode.getTestRunIds());
                    List<LabelNodeReportResponse.TestRunNodeResponse> testRunsForCurrentNode = this.testRunService.getTestRunNodeWithFailedLogRecords(nodeTestRuns, template, dataContext);
                    reportNode.setTestRuns(testRunsForCurrentNode);
                }
                this.addNodeToReport(Collections.singletonList(reportNode), rootNode);
                if (!CollectionUtils.isEmpty((Collection)labelTemplateNode.getChildren())) {
                    this.fillLabelReportsNode(labelTemplateNode.getChildren(), reportNode, template, testRuns, dataContext);
                }
                this.calculateParamsForLabelReportNode(reportNode);
            }
        });
    }

    private void calculateParamsForLabelReportNode(LabelNodeReportResponse reportNode) {
        List testRuns;
        long duration = 0L;
        ArrayList<TestingStatuses> currentStatuses = new ArrayList<TestingStatuses>();
        HashMap<String, TestingStatuses> labelParamMap = new HashMap<String, TestingStatuses>();
        List children = reportNode.getChildren();
        if (!CollectionUtils.isEmpty((Collection)children)) {
            duration += children.stream().mapToLong(LabelNodeReportResponse::getDuration).sum();
            currentStatuses.addAll(children.stream().map(LabelNodeReportResponse::getStatus).collect(Collectors.toList()));
            this.mergeLabelParams(labelParamMap, children, node -> node.getLabelParams().stream());
        }
        if (!CollectionUtils.isEmpty((Collection)(testRuns = reportNode.getTestRuns()))) {
            duration += testRuns.stream().mapToLong(LabelNodeReportResponse.TestRunNodeResponse::getDuration).sum();
            currentStatuses.addAll(testRuns.stream().map(LabelNodeReportResponse.TestRunNodeResponse::getTestingStatus).collect(Collectors.toList()));
            this.mergeLabelParams(labelParamMap, testRuns, node -> node.getLabelParams().stream());
        }
        reportNode.setDuration(duration);
        reportNode.setStatus(this.calculateStatus(currentStatuses));
        reportNode.setLabelParams(labelParamMap.entrySet().stream().map(entry -> new TestingReportLabelParam((String)entry.getKey(), (TestingStatuses)entry.getValue())).collect(Collectors.toList()));
    }

    private <T> void mergeLabelParams(Map<String, TestingStatuses> paramMap, Collection<T> entities, Function<? super T, ? extends Stream<? extends TestingReportLabelParam>> mapper) {
        BiFunction<TestingStatuses, TestingStatuses, TestingStatuses> statusMergeFunc = (oldStatus, newStatus) -> {
            if (TestingStatuses.FAILED.equals(newStatus) || TestingStatuses.FAILED.equals(oldStatus)) {
                return TestingStatuses.FAILED;
            }
            return newStatus;
        };
        entities.stream().flatMap(mapper).forEach(label -> paramMap.merge(label.getName(), label.getStatus(), statusMergeFunc));
    }

    private TestingStatuses calculateStatus(List<TestingStatuses> testingStatuses) {
        Optional<TestingStatuses> foundStatuses = testingStatuses.stream().filter(statuses -> statuses.equals((Object)TestingStatuses.FAILED) || statuses.equals((Object)TestingStatuses.STOPPED)).findAny();
        if (foundStatuses.isPresent()) {
            return TestingStatuses.FAILED;
        }
        foundStatuses = testingStatuses.stream().filter(arg_0 -> TestingStatuses.WARNING.equals(arg_0)).findAny();
        if (foundStatuses.isPresent()) {
            return TestingStatuses.WARNING;
        }
        return TestingStatuses.PASSED;
    }

    private void addNodeToReport(List<LabelNodeReportResponse> children, LabelNodeReportResponse rootNode) {
        List currentChildren = rootNode.getChildren();
        currentChildren.addAll(children);
        rootNode.setChildren(currentChildren);
    }

    public ExecutionSummaryResponse getExecutionSummary(UUID erId, boolean isExecutionSummaryRunsSummary) {
        ExecutionRequest executionRequest = this.executionRequestRepository.findByUuid(erId);
        return this.getExecutionSummary(executionRequest, isExecutionSummaryRunsSummary);
    }

    public ExecutionSummaryResponse getExecutionSummary(ExecutionRequest executionRequest, boolean isExecutionSummaryRunsSummary) {
        int inProgressTrCount;
        UUID erId = executionRequest.getUuid();
        ExecutionSummaryResponse executionSummaryResponse = (ExecutionSummaryResponse)this.modelMapper.map((Object)executionRequest, ExecutionSummaryResponse.class);
        List<TestRun> testRuns = this.testRunService.findTestRunForExecutionSummaryByExecutionRequestId(erId);
        List<TestRun> notInProgressTestRuns = testRuns.stream().filter(testRun -> !ExecutionStatuses.IN_PROGRESS.equals((Object)testRun.getExecutionStatus())).collect(Collectors.toList());
        Scope testScope = this.catalogueService.getTestScope(executionRequest.getTestScopeId());
        Set flagIds = executionRequest.getFlagIds();
        List prerequisitesCases = testScope != null ? testScope.getPrerequisitesCases() : null;
        List validationCases = testScope != null ? testScope.getValidationCases() : null;
        Predicate<TestRun> isNotIgnoredByScopeFlags = testRun -> !this.rateCalculator.isTestRunIgnoredByFlag((TestRun)testRun, flagIds, prerequisitesCases, validationCases);
        if (isExecutionSummaryRunsSummary) {
            List<TestRun> summarizeTestRuns = this.getSummarizeTestRuns(executionRequest.getInitialExecutionRequestId(), notInProgressTestRuns);
            notInProgressTestRuns = summarizeTestRuns;
            inProgressTrCount = (int)summarizeTestRuns.stream().filter(testRun -> ExecutionStatuses.IN_PROGRESS.equals((Object)testRun.getExecutionStatus())).count();
        } else {
            inProgressTrCount = this.getInProgressTestRunCount(testRuns.size(), notInProgressTestRuns.size());
        }
        notInProgressTestRuns.stream().filter(isNotIgnoredByScopeFlags).forEach(testRun -> {
            if (!Strings.isNullOrEmpty((String)testRun.getUrlToBrowserSession())) {
                List browserSessions = executionSummaryResponse.getBrowserSessionLink();
                browserSessions.add(testRun.getUrlToBrowserSession());
                executionSummaryResponse.setBrowserSessionLink(browserSessions);
            }
            this.updateStatusCount((TestRun)testRun, TestingStatuses.PASSED, executionSummaryResponse.getPassedCount(), arg_0 -> ((ExecutionSummaryResponse)executionSummaryResponse).setPassedCount(arg_0));
            this.updateStatusCount((TestRun)testRun, TestingStatuses.WARNING, executionSummaryResponse.getWarningCount(), arg_0 -> ((ExecutionSummaryResponse)executionSummaryResponse).setWarningCount(arg_0));
            this.updateStatusCount((TestRun)testRun, TestingStatuses.FAILED, executionSummaryResponse.getFailedCount(), arg_0 -> ((ExecutionSummaryResponse)executionSummaryResponse).setFailedCount(arg_0));
            this.updateStatusCount((TestRun)testRun, TestingStatuses.STOPPED, executionSummaryResponse.getStoppedCount(), arg_0 -> ((ExecutionSummaryResponse)executionSummaryResponse).setStoppedCount(arg_0));
            this.updateStatusCount((TestRun)testRun, TestingStatuses.SKIPPED, executionSummaryResponse.getSkippedCount(), arg_0 -> ((ExecutionSummaryResponse)executionSummaryResponse).setSkippedCount(arg_0));
            this.updateStatusCount((TestRun)testRun, TestingStatuses.BLOCKED, executionSummaryResponse.getBlockedCount(), arg_0 -> ((ExecutionSummaryResponse)executionSummaryResponse).setBlockedCount(arg_0));
            this.updateStatusCount((TestRun)testRun, TestingStatuses.NOT_STARTED, executionSummaryResponse.getNotStartedCount(), arg_0 -> ((ExecutionSummaryResponse)executionSummaryResponse).setNotStartedCount(arg_0));
        });
        int trCount = this.getTotalNumberOfTestRun(executionSummaryResponse) + inProgressTrCount;
        executionSummaryResponse.setInProgressCount(Integer.valueOf(inProgressTrCount));
        this.calculateRates(executionSummaryResponse, trCount);
        Set labelIds = executionRequest.getFilteredByLabels();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)labelIds)) {
            executionSummaryResponse.setLabels(this.labelsService.getLabels(labelIds));
        }
        String envLink = this.getEnvLink(executionRequest);
        String envName = this.environmentsService.getEnvironmentNameById(executionRequest.getEnvironmentId());
        executionSummaryResponse.setEnvironmentLink(envLink);
        executionSummaryResponse.setEnvironmentName(envName);
        executionSummaryResponse.setTestCasesCount(trCount);
        if (Objects.nonNull(testScope)) {
            String scopeName = testScope.getName();
            String scopeLink = this.getScopeLink(executionRequest, testScope);
            executionSummaryResponse.setScopeName(scopeName);
            executionSummaryResponse.setScopeLink(scopeLink);
        }
        return executionSummaryResponse;
    }

    protected List<TestRun> getSummarizeTestRuns(UUID initialErId, List<TestRun> testRuns) {
        List<TestRun> initialTestRuns = this.testRunService.findAllByExecutionRequestId(initialErId);
        ArrayList<TestRun> summaryTestRuns = new ArrayList<TestRun>();
        initialTestRuns.forEach(initialTestRun -> {
            UUID initialTestRunId = initialTestRun.getUuid();
            Optional<TestRun> matchRun = testRuns.stream().filter(testRun -> testRun.getInitialTestRunId().equals(initialTestRunId)).findFirst();
            TestRun summaryTestRun = matchRun.isPresent() && matchRun.get().isFinalTestRun() && !initialTestRun.isFinalTestRun() ? matchRun.get() : (initialTestRun.isFinalTestRun() ? initialTestRun : matchRun.orElse((TestRun)initialTestRun));
            summaryTestRuns.add(summaryTestRun);
        });
        return summaryTestRuns;
    }

    private String getScopeLink(ExecutionRequest executionRequest, Scope scope) {
        UUID testScopeId = scope.getUuid();
        UUID projectId = executionRequest.getProjectId();
        UUID testPlanId = executionRequest.getTestPlanId();
        return this.catalogueUrl + "/project/" + projectId + "/plan/" + testPlanId + "/scopes/" + testScopeId;
    }

    private String getEnvLink(ExecutionRequest executionRequest) {
        UUID projectId = executionRequest.getProjectId();
        UUID environmentId = executionRequest.getEnvironmentId();
        return this.catalogueUrl + "/project/" + projectId + "/environments/environment/" + environmentId;
    }

    private void calculateRates(ExecutionSummaryResponse erSummary, int trCount) {
        if (trCount != 0) {
            erSummary.setPassedRate(RateCalculator.calculateRateFloat(erSummary.getPassedCount(), trCount));
            erSummary.setFailedRate(RateCalculator.calculateRateFloat(erSummary.getFailedCount(), trCount));
            erSummary.setStoppedRate(RateCalculator.calculateRateFloat(erSummary.getStoppedCount(), trCount));
            erSummary.setWarningRate(RateCalculator.calculateRateFloat(erSummary.getWarningCount(), trCount));
            erSummary.setNotStartedRate(RateCalculator.calculateRateFloat(erSummary.getNotStartedCount(), trCount));
            erSummary.setBlockedRate(RateCalculator.calculateRateFloat(erSummary.getBlockedCount(), erSummary.getFailedCount() + erSummary.getBlockedCount()));
        }
    }

    private int getTotalNumberOfTestRun(ExecutionSummaryResponse executionSummaryResponse) {
        return executionSummaryResponse.getPassedCount() + executionSummaryResponse.getFailedCount() + executionSummaryResponse.getWarningCount() + executionSummaryResponse.getNotStartedCount() + executionSummaryResponse.getStoppedCount();
    }

    private int getInProgressTestRunCount(int allTestRunCount, int finishedTestRunCount) {
        return allTestRunCount - finishedTestRunCount;
    }

    private void updateStatusCount(TestRun testRun, TestingStatuses currentStatus, int currentCount, Consumer<Integer> setMethod) {
        if (currentStatus.equals((Object)testRun.getTestingStatus())) {
            setMethod.accept(++currentCount);
        }
    }

    public ReportService(EnvironmentsInfoService environmentsInfoService, EnvironmentsService environmentsService, ExecutionRequestRepository executionRequestRepository, TestRunService testRunService, LabelTemplateNodeService labelTemplateNodeService, LabelsService labelsService, ModelMapper modelMapper, ValidationLabelConfigTemplateService validationLabelConfigTemplateService, WidgetConfigTemplateService widgetConfigService, TreeNodeService treeNodeService, RateCalculator rateCalculator, CatalogueService catalogueService) {
        this.environmentsInfoService = environmentsInfoService;
        this.environmentsService = environmentsService;
        this.executionRequestRepository = executionRequestRepository;
        this.testRunService = testRunService;
        this.labelTemplateNodeService = labelTemplateNodeService;
        this.labelsService = labelsService;
        this.modelMapper = modelMapper;
        this.validationLabelConfigTemplateService = validationLabelConfigTemplateService;
        this.widgetConfigService = widgetConfigService;
        this.treeNodeService = treeNodeService;
        this.rateCalculator = rateCalculator;
        this.catalogueService = catalogueService;
    }
}

