/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services;

import org.qubership.atp.ram.dto.event.WebSocketEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.stereotype.Service;

@Service
public class WebSocketNotificationService {
    private static final Logger log = LoggerFactory.getLogger(WebSocketNotificationService.class);
    private final SimpMessageSendingOperations messagingTemplate;

    public <T extends WebSocketEvent<R>, R> void sendEvent(T event) {
        log.debug("Send event via WS with body: {}", event);
        String destination = event.getEventType().getDestinationPrefix() + event.getDestination();
        this.messagingTemplate.convertAndSend((Object)destination, event);
        log.debug("Notification event '{}' has been sent", event);
    }

    public WebSocketNotificationService(SimpMessageSendingOperations messagingTemplate) {
        this.messagingTemplate = messagingTemplate;
    }
}

