/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.ram.services.dictionary;

import java.util.Arrays;
import java.util.List;
import org.qubership.atp.ram.models.dictionary.Dictionary;
import org.qubership.atp.ram.repositories.DictionaryRepository;
import org.qubership.atp.ram.services.dictionary.DictionaryCatalogEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class DictionaryService {
    private static final Logger log = LoggerFactory.getLogger(DictionaryService.class);
    private static DictionaryRepository repository;

    @Autowired
    public void setRepository(DictionaryRepository repository) {
        DictionaryService.repository = repository;
    }

    @Cacheable(value={"dictionaries"}, key="{#name}")
    public List<Dictionary> getAllByName(String name) {
        return Arrays.stream(DictionaryCatalogEnum.values()).filter(dictionaryCatalogEnum -> dictionaryCatalogEnum.name().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new IllegalArgumentException("Can't found dictionary by specified name: " + name)).getSupplier().get();
    }

    @CacheEvict(value={"dictionaries"}, key="{#name}")
    public void evictDictionaryCacheByName(String name) {
        log.info("Dictionary cache for name '{}' has been evicted", (Object)name);
    }

    public static List<Dictionary> getAllByType(String type) {
        return repository.getAllByType(type);
    }
}

